/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.www;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.vfs.FileObject;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.KettleClientEnvironment;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.logging.KettleLogStore;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.TransPreviewFactory;
import org.pentaho.di.trans.steps.rowgenerator.RowGeneratorMeta;
import org.pentaho.di.www.CarteSingleton;
import org.pentaho.di.www.JobMap;
import org.pentaho.di.www.SlaveServerConfig;
import org.pentaho.di.www.SlaveServerDetection;
import org.pentaho.di.www.SocketRepository;
import org.pentaho.di.www.TransformationMap;
import org.pentaho.di.www.WebServer;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class Carte {
    private static Class<?> PKG = Carte.class;
    private WebServer webServer;
    private SlaveServerConfig config;

    public Carte(SlaveServerConfig config) throws Exception {
        this.config = config;
        boolean allOK = true;
        CarteSingleton.setSlaveServerConfig(config);
        LogChannelInterface log = CarteSingleton.getInstance().getLog();
        TransformationMap transformationMap = CarteSingleton.getInstance().getTransformationMap();
        transformationMap.setSlaveServerConfig(config);
        JobMap jobMap = CarteSingleton.getInstance().getJobMap();
        jobMap.setSlaveServerConfig(config);
        List<SlaveServerDetection> detections = Collections.synchronizedList(new ArrayList());
        SocketRepository socketRepository = CarteSingleton.getInstance().getSocketRepository();
        SlaveServer slaveServer = config.getSlaveServer();
        String hostname = slaveServer.getHostname();
        int port = 80;
        if (!Const.isEmpty((String)slaveServer.getPort())) {
            try {
                port = Integer.parseInt(slaveServer.getPort());
            }
            catch (Exception e) {
                log.logError(BaseMessages.getString(PKG, (String)"Carte.Error.CanNotPartPort", (String[])new String[]{slaveServer.getHostname(), "" + port}), (Throwable)e);
                allOK = false;
            }
        }
        if (config.isReportingToMasters()) {
            SlaveServer client = new SlaveServer("Dynamic slave [" + hostname + ":" + port + "]", hostname, "" + port, slaveServer.getUsername(), slaveServer.getPassword());
            for (SlaveServer master : config.getMasters()) {
                try {
                    SlaveServerDetection slaveServerDetection = new SlaveServerDetection(client);
                    master.sendXML(slaveServerDetection.getXML(), "/kettle/registerSlave/");
                    log.logBasic("Registered this slave server to master slave server [" + master.toString() + "] on address [" + master.getServerAndPort() + "]");
                }
                catch (Exception e) {
                    log.logError("Unable to register to master slave server [" + master.toString() + "] on address [" + master.getServerAndPort() + "]");
                    allOK = false;
                }
            }
        }
        if (allOK) {
            this.webServer = new WebServer(log, transformationMap, jobMap, socketRepository, detections, hostname, port, config.isJoining(), config.getPasswordFile());
        }
    }

    public static void main(String[] args) throws Exception {
        KettleEnvironment.init();
        KettleClientEnvironment.getInstance().setClient(KettleClientEnvironment.ClientType.CARTE);
        SlaveServerConfig config = null;
        if (args.length == 1 && !Const.isEmpty((String)args[0])) {
            FileObject file = KettleVFS.getFileObject((String)args[0]);
            Document document = XMLHandler.loadXMLFile((FileObject)file);
            Node configNode = XMLHandler.getSubNode((Node)document, (String)"slave_config");
            config = new SlaveServerConfig((LogChannelInterface)new LogChannel((Object)"Slave server config"), configNode);
            if (config.getAutoSequence() != null) {
                config.readAutoSequences();
            }
            config.setFilename(args[0]);
        }
        if (args.length == 2 && !Const.isEmpty((String)args[0]) && !Const.isEmpty((String)args[1])) {
            String hostname = args[0];
            String port = args[1];
            SlaveServer slaveServer = new SlaveServer(hostname + ":" + port, hostname, port, null, null);
            config = new SlaveServerConfig();
            config.setSlaveServer(slaveServer);
        }
        if (config == null) {
            System.err.println(BaseMessages.getString(PKG, (String)"Carte.Usage.Text", (String[])new String[0]));
            System.err.println();
            System.err.println(BaseMessages.getString(PKG, (String)"Carte.Usage.Example", (String[])new String[0]) + ": Carte 127.0.0.1 8080");
            System.err.println(BaseMessages.getString(PKG, (String)"Carte.Usage.Example", (String[])new String[0]) + ": Carte 192.168.1.221 8081");
            System.err.println();
            System.err.println(BaseMessages.getString(PKG, (String)"Carte.Usage.Example", (String[])new String[0]) + ": Carte /foo/bar/carte-config.xml");
            System.err.println(BaseMessages.getString(PKG, (String)"Carte.Usage.Example", (String[])new String[0]) + ": Carte http://www.example.com/carte-config.xml");
            System.exit(1);
        }
        Carte.runCarte(config);
    }

    public static void runCarte(SlaveServerConfig config) throws Exception {
        KettleLogStore.init((int)config.getMaxLogLines(), (int)config.getMaxLogTimeoutMinutes());
        config.setJoining(true);
        new Carte(config);
    }

    public static Trans generateTestTransformation() {
        RowGeneratorMeta A = new RowGeneratorMeta();
        A.allocate(3);
        A.setRowLimit("100000000");
        A.getFieldName()[0] = "ID";
        A.getFieldType()[0] = ValueMeta.getTypeDesc((int)5);
        A.getFieldLength()[0] = 7;
        A.getValue()[0] = "1234";
        A.getFieldName()[1] = "Name";
        A.getFieldType()[1] = ValueMeta.getTypeDesc((int)2);
        A.getFieldLength()[1] = 35;
        A.getValue()[1] = "Some name";
        A.getFieldName()[2] = "Last updated";
        A.getFieldType()[2] = ValueMeta.getTypeDesc((int)3);
        A.getFieldFormat()[2] = "yyyy/MM/dd";
        A.getValue()[2] = "2006/11/13";
        TransMeta transMeta = TransPreviewFactory.generatePreviewTransformation(null, A, "A");
        transMeta.setName("Row generator test");
        transMeta.setSizeRowset(2500);
        transMeta.setFeedbackSize(50000);
        transMeta.setUsingThreadPriorityManagment(false);
        return new Trans(transMeta);
    }

    public WebServer getWebServer() {
        return this.webServer;
    }

    public void setWebServer(WebServer webServer) {
        this.webServer = webServer;
    }

    public SlaveServerConfig getConfig() {
        return this.config;
    }

    public void setConfig(SlaveServerConfig config) {
        this.config = config;
    }
}

