/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.www;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLEncoder;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Encoder;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.gui.Point;
import org.pentaho.di.core.logging.KettleLogStore;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.step.BaseStepData;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepStatus;
import org.pentaho.di.www.BaseHttpServlet;
import org.pentaho.di.www.CarteObjectEntry;
import org.pentaho.di.www.CartePluginInterface;
import org.pentaho.di.www.SlaveServerTransStatus;
import org.pentaho.di.www.TransformationMap;
import org.pentaho.di.www.WebResult;

public class GetTransStatusServlet
extends BaseHttpServlet
implements CartePluginInterface {
    private static Class<?> PKG = GetTransStatusServlet.class;
    private static final long serialVersionUID = 3634806745372015720L;
    public static final String CONTEXT_PATH = "/kettle/transStatus";

    public GetTransStatusServlet() {
    }

    public GetTransStatusServlet(TransformationMap transformationMap) {
        super(transformationMap);
    }

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Trans trans;
        CarteObjectEntry entry;
        if (this.isJettyMode() && !request.getContextPath().startsWith(CONTEXT_PATH)) {
            return;
        }
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"TransStatusServlet.Log.TransStatusRequested", (String[])new String[0]));
        }
        String transName = request.getParameter("name");
        String id = request.getParameter("id");
        boolean useXML = "Y".equalsIgnoreCase(request.getParameter("xml"));
        int startLineNr = Const.toInt((String)request.getParameter("from"), (int)0);
        response.setStatus(200);
        if (useXML) {
            response.setContentType("text/xml");
            response.setCharacterEncoding("UTF-8");
        } else {
            response.setCharacterEncoding("UTF-8");
            response.setContentType("text/html;charset=UTF-8");
        }
        PrintWriter out = response.getWriter();
        if (Const.isEmpty((String)id)) {
            entry = this.getTransformationMap().getFirstCarteObjectEntry(transName);
            if (entry == null) {
                trans = null;
            } else {
                id = entry.getId();
                trans = this.getTransformationMap().getTransformation(entry);
            }
        } else {
            entry = new CarteObjectEntry(transName, id);
            trans = this.getTransformationMap().getTransformation(entry);
        }
        Encoder encoder = ESAPI.encoder();
        if (trans != null) {
            String status = trans.getStatus();
            int lastLineNr = KettleLogStore.getLastBufferLineNr();
            String logText = KettleLogStore.getAppender().getBuffer(trans.getLogChannel().getLogChannelId(), false, startLineNr, lastLineNr).toString();
            if (useXML) {
                response.setContentType("text/xml");
                response.setCharacterEncoding("UTF-8");
                out.print(XMLHandler.getXMLHeader((String)"UTF-8"));
                SlaveServerTransStatus transStatus = new SlaveServerTransStatus(transName, entry.getId(), status);
                transStatus.setFirstLoggingLineNr(startLineNr);
                transStatus.setLastLoggingLineNr(lastLineNr);
                for (int i = 0; i < trans.nrSteps(); ++i) {
                    StepInterface baseStep = trans.getRunThread(i);
                    if (!baseStep.isRunning() && baseStep.getStatus() == BaseStepData.StepExecutionStatus.STATUS_EMPTY) continue;
                    StepStatus stepStatus = new StepStatus(baseStep);
                    transStatus.getStepStatusList().add(stepStatus);
                }
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                GZIPOutputStream gzos = new GZIPOutputStream(baos);
                gzos.write(logText.getBytes());
                gzos.close();
                String loggingString = new String(Base64.encodeBase64((byte[])baos.toByteArray()));
                transStatus.setLoggingString(loggingString);
                transStatus.setResult(trans.getResult());
                transStatus.setPaused(trans.isPaused());
                try {
                    out.println(transStatus.getXML());
                }
                catch (KettleException e) {
                    throw new ServletException("Unable to get the transformation status in XML format", (Throwable)e);
                }
            }
            response.setContentType("text/html;charset=UTF-8");
            out.println("<HTML>");
            out.println("<HEAD>");
            out.println("<TITLE>" + BaseMessages.getString(PKG, (String)"TransStatusServlet.KettleTransStatus", (String[])new String[0]) + "</TITLE>");
            out.println("<META http-equiv=\"Refresh\" content=\"10;url=" + this.convertContextPath(CONTEXT_PATH) + "?name=" + URLEncoder.encode(transName, "UTF-8") + "&id=" + URLEncoder.encode(id, "UTF-8") + "\">");
            out.println("<META http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">");
            out.println("</HEAD>");
            out.println("<BODY>");
            out.println("<H1>" + encoder.encodeForHTML(BaseMessages.getString(PKG, (String)"TransStatusServlet.TopTransStatus", (String[])new String[]{transName})) + "</H1>");
            try {
                out.println("<table border=\"1\">");
                out.print("<tr> <th>" + BaseMessages.getString(PKG, (String)"TransStatusServlet.TransName", (String[])new String[0]) + "</th> <th>" + BaseMessages.getString(PKG, (String)"TransStatusServlet.CarteObjectId", (String[])new String[0]) + "</th> <th>" + BaseMessages.getString(PKG, (String)"TransStatusServlet.TransStatus", (String[])new String[0]) + "</th> </tr>");
                out.print("<tr>");
                out.print("<td>" + encoder.encodeForHTML(transName) + "</td>");
                out.print("<td>" + encoder.encodeForHTML(id) + "</td>");
                out.print("<td>" + encoder.encodeForHTML(status) + "</td>");
                out.print("</tr>");
                out.print("</table>");
                out.print("<p>");
                Point max = trans.getTransMeta().getMaximum();
                max.x += 20;
                max.y += 20;
                out.print("<iframe height=\"" + max.y + "\" width=\"" + max.x + "\" seamless src=\"" + this.convertContextPath("/kettle/transImage") + "?name=" + URLEncoder.encode(transName, "UTF-8") + "&id=" + URLEncoder.encode(id, "UTF-8") + "\"></iframe>");
                out.print("<p>");
                if (trans.isFinished() && trans.isRunning() || !trans.isRunning() && !trans.isPreparing() && !trans.isInitializing()) {
                    out.print("<a href=\"" + this.convertContextPath("/kettle/startTrans") + "?name=" + URLEncoder.encode(transName, "UTF-8") + "&id=" + URLEncoder.encode(id, "UTF-8") + "\">" + BaseMessages.getString(PKG, (String)"TransStatusServlet.StartTrans", (String[])new String[0]) + "</a>");
                    out.print("<p>");
                    out.print("<a href=\"" + this.convertContextPath("/kettle/prepareExec") + "?name=" + URLEncoder.encode(transName, "UTF-8") + "&id=" + URLEncoder.encode(id, "UTF-8") + "\">" + BaseMessages.getString(PKG, (String)"TransStatusServlet.PrepareTrans", (String[])new String[0]) + "</a><br>");
                } else if (trans.isRunning()) {
                    out.print("<a href=\"" + this.convertContextPath("/kettle/pauseTrans") + "?name=" + URLEncoder.encode(transName, "UTF-8") + "&id=" + URLEncoder.encode(id, "UTF-8") + "\">" + BaseMessages.getString(PKG, (String)"PauseStatusServlet.PauseResumeTrans", (String[])new String[0]) + "</a><br>");
                    out.print("<a href=\"" + this.convertContextPath("/kettle/stopTrans") + "?name=" + URLEncoder.encode(transName, "UTF-8") + "&id=" + URLEncoder.encode(id, "UTF-8") + "\">" + BaseMessages.getString(PKG, (String)"TransStatusServlet.StopTrans", (String[])new String[0]) + "</a>");
                    out.print("<p>");
                }
                out.print("<a href=\"" + this.convertContextPath("/kettle/cleanupTrans") + "?name=" + URLEncoder.encode(transName, "UTF-8") + "&id=" + URLEncoder.encode(id, "UTF-8") + "\">" + BaseMessages.getString(PKG, (String)"TransStatusServlet.CleanupTrans", (String[])new String[0]) + "</a>");
                out.print("<p>");
                out.println("<table border=\"1\">");
                out.print("<tr> <th>" + BaseMessages.getString(PKG, (String)"TransStatusServlet.Stepname", (String[])new String[0]) + "</th> <th>" + BaseMessages.getString(PKG, (String)"TransStatusServlet.CopyNr", (String[])new String[0]) + "</th> <th>" + BaseMessages.getString(PKG, (String)"TransStatusServlet.Read", (String[])new String[0]) + "</th> <th>" + BaseMessages.getString(PKG, (String)"TransStatusServlet.Written", (String[])new String[0]) + "</th> <th>" + BaseMessages.getString(PKG, (String)"TransStatusServlet.Input", (String[])new String[0]) + "</th> <th>" + BaseMessages.getString(PKG, (String)"TransStatusServlet.Output", (String[])new String[0]) + "</th> " + "<th>" + BaseMessages.getString(PKG, (String)"TransStatusServlet.Updated", (String[])new String[0]) + "</th> <th>" + BaseMessages.getString(PKG, (String)"TransStatusServlet.Rejected", (String[])new String[0]) + "</th> <th>" + BaseMessages.getString(PKG, (String)"TransStatusServlet.Errors", (String[])new String[0]) + "</th> <th>" + BaseMessages.getString(PKG, (String)"TransStatusServlet.Active", (String[])new String[0]) + "</th> <th>" + BaseMessages.getString(PKG, (String)"TransStatusServlet.Time", (String[])new String[0]) + "</th> " + "<th>" + BaseMessages.getString(PKG, (String)"TransStatusServlet.Speed", (String[])new String[0]) + "</th> <th>" + BaseMessages.getString(PKG, (String)"TransStatusServlet.prinout", (String[])new String[0]) + "</th> </tr>");
                for (int i = 0; i < trans.nrSteps(); ++i) {
                    StepInterface step = trans.getRunThread(i);
                    if (!step.isRunning() && step.getStatus() == BaseStepData.StepExecutionStatus.STATUS_EMPTY) continue;
                    StepStatus stepStatus = new StepStatus(step);
                    boolean snif = false;
                    if (step.isRunning() && !step.isStopped() && !step.isPaused()) {
                        snif = true;
                        String sniffLink = " <a href=\"" + this.convertContextPath("/kettle/sniffStep") + "?trans=" + URLEncoder.encode(transName, "UTF-8") + "&id=" + URLEncoder.encode(id, "UTF-8") + "&lines=50" + "&copynr=" + step.getCopy() + "&type=" + "output" + "&step=" + URLEncoder.encode(step.getStepname(), "UTF-8") + "\">" + encoder.encodeForHTML(stepStatus.getStepname()) + "</a>";
                        stepStatus.setStepname(sniffLink);
                    }
                    out.print(stepStatus.getHTMLTableRow(snif));
                }
                out.println("</table>");
                out.println("<p>");
                out.print("<a href=\"" + this.convertContextPath(CONTEXT_PATH) + "?name=" + URLEncoder.encode(transName, "UTF-8") + "&id=" + URLEncoder.encode(id, "UTF-8") + "&xml=y\">" + BaseMessages.getString(PKG, (String)"TransStatusServlet.ShowAsXml", (String[])new String[0]) + "</a><br>");
                out.print("<a href=\"" + this.convertContextPath("/kettle/status") + "\">" + BaseMessages.getString(PKG, (String)"TransStatusServlet.BackToStatusPage", (String[])new String[0]) + "</a><br>");
                out.print("<p><a href=\"" + this.convertContextPath(CONTEXT_PATH) + "?name=" + URLEncoder.encode(transName, "UTF-8") + "&id=" + URLEncoder.encode(id, "UTF-8") + "\">" + BaseMessages.getString(PKG, (String)"TransStatusServlet.Refresh", (String[])new String[0]) + "</a>");
                out.println("<p>");
                out.println("<textarea id=\"translog\" cols=\"120\" rows=\"20\" wrap=\"off\" name=\"Transformation log\" readonly=\"readonly\">" + encoder.encodeForHTML(logText) + "</textarea>");
                out.println("<script type=\"text/javascript\"> ");
                out.println("  translog.scrollTop=translog.scrollHeight; ");
                out.println("</script> ");
                out.println("<p>");
            }
            catch (Exception ex) {
                out.println("<p>");
                out.println("<pre>");
                out.println(encoder.encodeForHTML(Const.getStackTracker((Throwable)ex)));
                out.println("</pre>");
            }
            out.println("<p>");
            out.println("</BODY>");
            out.println("</HTML>");
        } else if (useXML) {
            out.println(new WebResult("ERROR", BaseMessages.getString(PKG, (String)"TransStatusServlet.Log.CoundNotFindSpecTrans", (String[])new String[]{transName})));
        } else {
            out.println("<H1>" + encoder.encodeForHTML(BaseMessages.getString(PKG, (String)"TransStatusServlet.Log.CoundNotFindTrans", (String[])new String[]{transName})) + "</H1>");
            out.println("<a href=\"" + this.convertContextPath("/kettle/status") + "\">" + BaseMessages.getString(PKG, (String)"TransStatusServlet.BackToStatusPage", (String[])new String[0]) + "</a><p>");
        }
    }

    public String toString() {
        return "Trans Status Handler";
    }

    @Override
    public String getService() {
        return "/kettle/transStatus (" + this.toString() + ")";
    }

    @Override
    public String getContextPath() {
        return CONTEXT_PATH;
    }
}

