/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.www;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.KettleLogStore;
import org.pentaho.di.core.logging.LogLevel;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.logging.LoggingObjectType;
import org.pentaho.di.core.logging.SimpleLoggingObject;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobConfiguration;
import org.pentaho.di.job.JobExecutionConfiguration;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.www.BaseHttpServlet;
import org.pentaho.di.www.CartePluginInterface;
import org.pentaho.di.www.JobMap;
import org.pentaho.di.www.WebResult;

public class RunJobServlet
extends BaseHttpServlet
implements CartePluginInterface {
    private static final long serialVersionUID = 1192413943669836775L;
    private static Class<?> PKG = RunJobServlet.class;
    public static final String CONTEXT_PATH = "/kettle/runJob";

    public RunJobServlet() {
    }

    public RunJobServlet(JobMap jobMap) {
        super(jobMap);
    }

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.isJettyMode() && !request.getContextPath().startsWith(CONTEXT_PATH)) {
            return;
        }
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"RunJobServlet.Log.RunJobRequested", (String[])new String[0]));
        }
        String[] knownOptions = new String[]{"job", "level"};
        String transOption = request.getParameter("job");
        String levelOption = request.getParameter("level");
        response.setStatus(200);
        PrintWriter out = response.getWriter();
        try {
            Repository repository = this.transformationMap.getSlaveServerConfig().getRepository();
            JobMeta jobMeta = this.loadJob(repository, transOption);
            String[] parameters = jobMeta.listParameters();
            Enumeration parameterNames = request.getParameterNames();
            while (parameterNames.hasMoreElements()) {
                String parameter = (String)parameterNames.nextElement();
                String[] values = request.getParameterValues(parameter);
                if (Const.indexOfString((String)parameter, (String[])knownOptions) >= 0) continue;
                if (Const.indexOfString((String)parameter, (String[])parameters) < 0) {
                    jobMeta.setVariable(parameter, values[0]);
                    continue;
                }
                jobMeta.setParameterValue(parameter, values[0]);
            }
            JobExecutionConfiguration jobExecutionConfiguration = new JobExecutionConfiguration();
            LogLevel logLevel = LogLevel.getLogLevelForCode((String)levelOption);
            jobExecutionConfiguration.setLogLevel(logLevel);
            JobConfiguration jobConfiguration = new JobConfiguration(jobMeta, jobExecutionConfiguration);
            String carteObjectId = UUID.randomUUID().toString();
            SimpleLoggingObject servletLoggingObject = new SimpleLoggingObject(CONTEXT_PATH, LoggingObjectType.CARTE, null);
            servletLoggingObject.setContainerObjectId(carteObjectId);
            servletLoggingObject.setLogLevel(logLevel);
            Job job = new Job(repository, jobMeta, (LoggingObjectInterface)servletLoggingObject);
            job.initializeVariablesFrom(null);
            job.getJobMeta().setInternalKettleVariables(job);
            job.injectVariables(jobConfiguration.getJobExecutionConfiguration().getVariables());
            job.copyParametersFrom(jobMeta);
            job.clearParameters();
            jobMeta.activateParameters();
            job.setSocketRepository(this.getSocketRepository());
            this.getJobMap().addJob(job.getJobname(), carteObjectId, job, jobConfiguration);
            String message = "Job '" + job.getJobname() + "' was added to the list with id " + carteObjectId;
            this.logBasic(message);
            try {
                job.start();
                WebResult webResult = new WebResult("OK", "Job started", carteObjectId);
                out.println(webResult.getXML());
                out.flush();
            }
            catch (Exception executionException) {
                String logging = KettleLogStore.getAppender().getBuffer(job.getLogChannelId(), false).toString();
                throw new KettleException("Error executing Job: " + logging, (Throwable)executionException);
            }
        }
        catch (Exception ex) {
            out.println(new WebResult("ERROR", BaseMessages.getString(PKG, (String)"RunJobServlet.Error.UnexpectedError", (String[])new String[]{Const.CR + Const.getStackTracker((Throwable)ex)})));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JobMeta loadJob(Repository repository, String job) throws KettleException {
        if (repository == null) {
            throw new KettleException("Repository required.");
        }
        Repository repository2 = repository;
        synchronized (repository2) {
            String name;
            String directoryPath;
            int lastSlash = job.lastIndexOf("/");
            if (lastSlash < 0) {
                directoryPath = "/";
                name = job;
            } else {
                directoryPath = job.substring(0, lastSlash);
                name = job.substring(lastSlash + 1);
            }
            RepositoryDirectoryInterface directory = repository.loadRepositoryDirectoryTree().findDirectory(directoryPath);
            ObjectId jobID = repository.getJobId(name, directory);
            JobMeta transJob = repository.loadJob(jobID, null);
            return transJob;
        }
    }

    public String toString() {
        return "Run Job";
    }

    @Override
    public String getService() {
        return "/kettle/runJob (" + this.toString() + ")";
    }

    @Override
    public String getContextPath() {
        return CONTEXT_PATH;
    }
}

