/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.www;

import java.net.SocketException;
import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.jdbc.TransDataService;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.logging.LoggingObjectType;
import org.pentaho.di.core.logging.SimpleLoggingObject;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.RepositoryPluginType;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.metastore.MetaStoreConst;
import org.pentaho.di.repository.RepositoriesMeta;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryMeta;
import org.pentaho.di.www.SlaveSequence;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.metastore.api.exceptions.MetaStoreException;
import org.pentaho.metastore.stores.delegate.DelegatingMetaStore;
import org.pentaho.metastore.stores.xml.XmlMetaStore;
import org.w3c.dom.Node;

public class SlaveServerConfig {
    public static final String XML_TAG = "slave_config";
    public static final String XML_TAG_MASTERS = "masters";
    public static final String XML_TAG_REPOSITORY = "repository";
    public static final String XML_TAG_SEQUENCES = "sequences";
    public static final String XML_TAG_AUTOSEQUENCE = "autosequence";
    public static final String XML_TAG_AUTO_CREATE = "autocreate";
    public static final String XML_TAG_SERVICES = "services";
    public static final String XML_TAG_SERVICE = "service";
    private List<SlaveServer> masters;
    private SlaveServer slaveServer;
    private boolean reportingToMasters;
    private boolean joining;
    private int maxLogLines;
    private int maxLogTimeoutMinutes;
    private int objectTimeoutMinutes;
    private String filename;
    private List<DatabaseMeta> databases;
    private List<SlaveSequence> slaveSequences;
    private SlaveSequence autoSequence;
    private boolean automaticCreationAllowed;
    private List<TransDataService> services;
    private Repository repository;
    private RepositoryMeta repositoryMeta;
    private String repositoryId;
    private String repositoryUsername;
    private String repositoryPassword;
    private DelegatingMetaStore metaStore;
    private String passwordFile;

    public SlaveServerConfig() {
        this.masters = new ArrayList<SlaveServer>();
        this.databases = new ArrayList<DatabaseMeta>();
        this.slaveSequences = new ArrayList<SlaveSequence>();
        this.automaticCreationAllowed = false;
        this.services = new ArrayList<TransDataService>();
        this.metaStore = new DelegatingMetaStore();
        try {
            XmlMetaStore localStore = new XmlMetaStore(MetaStoreConst.getDefaultPentahoMetaStoreLocation());
            this.metaStore.addMetaStore((IMetaStore)localStore);
            this.metaStore.setActiveMetaStoreName(localStore.getName());
        }
        catch (MetaStoreException e) {
            throw new RuntimeException("Unable to open local Pentaho meta store", e);
        }
        this.passwordFile = null;
    }

    public SlaveServerConfig(SlaveServer slaveServer) {
        this();
        this.slaveServer = slaveServer;
    }

    public SlaveServerConfig(List<SlaveServer> masters, boolean reportingToMasters, SlaveServer slaveServer) {
        this.masters = masters;
        this.reportingToMasters = reportingToMasters;
        this.slaveServer = slaveServer;
    }

    public String getXML() {
        StringBuffer xml = new StringBuffer();
        xml.append(XMLHandler.openTag((String)XML_TAG));
        for (SlaveServer slaveServer : this.masters) {
            xml.append(slaveServer.getXML());
        }
        XMLHandler.addTagValue((String)"report_to_masters", (boolean)this.reportingToMasters);
        if (this.slaveServer != null) {
            xml.append(this.slaveServer.getXML());
        }
        XMLHandler.addTagValue((String)"joining", (boolean)this.joining);
        XMLHandler.addTagValue((String)"max_log_lines", (int)this.maxLogLines);
        XMLHandler.addTagValue((String)"max_log_timeout_minutes", (int)this.maxLogTimeoutMinutes);
        XMLHandler.addTagValue((String)"object_timeout_minutes", (int)this.objectTimeoutMinutes);
        xml.append(XMLHandler.openTag((String)XML_TAG_SEQUENCES));
        for (SlaveSequence slaveSequence : this.slaveSequences) {
            xml.append(XMLHandler.openTag((String)"sequence"));
            xml.append(slaveSequence.getXML());
            xml.append(XMLHandler.closeTag((String)"sequence"));
        }
        xml.append(XMLHandler.closeTag((String)XML_TAG_SEQUENCES));
        if (this.autoSequence != null) {
            xml.append(XMLHandler.openTag((String)XML_TAG_AUTOSEQUENCE));
            xml.append(this.autoSequence.getXML());
            xml.append(XMLHandler.addTagValue((String)XML_TAG_AUTO_CREATE, (boolean)this.automaticCreationAllowed));
            xml.append(XMLHandler.closeTag((String)XML_TAG_AUTOSEQUENCE));
        }
        xml.append(XMLHandler.openTag((String)XML_TAG_SERVICES));
        for (TransDataService service : this.services) {
            xml.append(XMLHandler.openTag((String)XML_TAG_SERVICE));
            xml.append(service.getXML());
            xml.append(XMLHandler.closeTag((String)XML_TAG_SERVICE));
        }
        xml.append(XMLHandler.closeTag((String)XML_TAG_SERVICES));
        if (this.repositoryMeta != null) {
            xml.append(XMLHandler.openTag((String)XML_TAG_REPOSITORY));
            xml.append("  ").append(XMLHandler.addTagValue((String)"id", (String)this.repositoryMeta.getId()));
            xml.append("  ").append(XMLHandler.addTagValue((String)"username", (String)this.repositoryUsername));
            xml.append("  ").append(XMLHandler.addTagValue((String)"password", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.repositoryPassword)));
            xml.append(XMLHandler.closeTag((String)XML_TAG_REPOSITORY));
        }
        xml.append(XMLHandler.closeTag((String)XML_TAG));
        return xml.toString();
    }

    public SlaveServerConfig(LogChannelInterface log, Node node) throws KettleXMLException {
        this();
        Node mastersNode = XMLHandler.getSubNode((Node)node, (String)XML_TAG_MASTERS);
        int nrMasters = XMLHandler.countNodes((Node)mastersNode, (String)"slaveserver");
        for (int i = 0; i < nrMasters; ++i) {
            Node masterSlaveNode = XMLHandler.getSubNodeByNr((Node)mastersNode, (String)"slaveserver", (int)i);
            SlaveServer masterSlaveServer = new SlaveServer(masterSlaveNode);
            this.checkNetworkInterfaceSetting(log, masterSlaveNode, masterSlaveServer);
            this.masters.add(masterSlaveServer);
        }
        this.reportingToMasters = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)node, (String)"report_to_masters"));
        Node slaveNode = XMLHandler.getSubNode((Node)node, (String)"slaveserver");
        if (slaveNode != null) {
            this.slaveServer = new SlaveServer(slaveNode);
            this.checkNetworkInterfaceSetting(log, slaveNode, this.slaveServer);
        }
        this.joining = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)node, (String)"joining"));
        this.maxLogLines = Const.toInt((String)XMLHandler.getTagValue((Node)node, (String)"max_log_lines"), (int)0);
        this.maxLogTimeoutMinutes = Const.toInt((String)XMLHandler.getTagValue((Node)node, (String)"max_log_timeout_minutes"), (int)0);
        this.objectTimeoutMinutes = Const.toInt((String)XMLHandler.getTagValue((Node)node, (String)"object_timeout_minutes"), (int)0);
        List dbNodes = XMLHandler.getNodes((Node)node, (String)"connection");
        for (Node dbNode : dbNodes) {
            this.databases.add(new DatabaseMeta(dbNode));
        }
        Node sequencesNode = XMLHandler.getSubNode((Node)node, (String)XML_TAG_SEQUENCES);
        List seqNodes = XMLHandler.getNodes((Node)sequencesNode, (String)"sequence");
        for (Node seqNode : seqNodes) {
            this.slaveSequences.add(new SlaveSequence(seqNode, this.databases));
        }
        Node autoSequenceNode = XMLHandler.getSubNode((Node)node, (String)XML_TAG_AUTOSEQUENCE);
        if (autoSequenceNode != null) {
            this.autoSequence = new SlaveSequence(autoSequenceNode, this.databases);
            this.automaticCreationAllowed = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)autoSequenceNode, (String)XML_TAG_AUTO_CREATE));
        }
        Node servicesNode = XMLHandler.getSubNode((Node)node, (String)XML_TAG_SERVICES);
        List servicesNodes = XMLHandler.getNodes((Node)servicesNode, (String)XML_TAG_SERVICE);
        for (Node serviceNode : servicesNodes) {
            TransDataService service = new TransDataService(serviceNode);
            this.services.add(service);
        }
        Node repositoryNode = XMLHandler.getSubNode((Node)node, (String)XML_TAG_REPOSITORY);
        this.repositoryId = XMLHandler.getTagValue((Node)repositoryNode, (String)"name");
        this.repositoryUsername = XMLHandler.getTagValue((Node)repositoryNode, (String)"username");
        this.repositoryPassword = XMLHandler.getTagValue((Node)repositoryNode, (String)"password");
    }

    private void openRepository(String repositoryId) throws KettleException {
        try {
            RepositoriesMeta repositoriesMeta = new RepositoriesMeta();
            repositoriesMeta.readData();
            this.repositoryMeta = repositoriesMeta.findRepository(repositoryId);
            PluginRegistry registry = PluginRegistry.getInstance();
            this.repository = (Repository)registry.loadClass(RepositoryPluginType.class, (Object)this.repositoryMeta, Repository.class);
            this.repository.init(this.repositoryMeta);
            this.repository.connect(this.repositoryUsername, this.repositoryPassword);
            if (this.repository.getMetaStore() != null) {
                this.metaStore.addMetaStore(0, this.repository.getMetaStore());
                this.metaStore.setActiveMetaStoreName(this.repository.getMetaStore().getName());
            }
            LogChannel.GENERAL.logBasic("Connected to repository '" + this.repository.getName() + "'");
        }
        catch (Exception e) {
            throw new KettleException("Unable to open repository connection", (Throwable)e);
        }
    }

    public void readAutoSequences() throws KettleException {
        if (this.autoSequence == null) {
            return;
        }
        Database database = null;
        try {
            DatabaseMeta databaseMeta = this.autoSequence.getDatabaseMeta();
            SimpleLoggingObject loggingInterface = new SimpleLoggingObject("auto-sequence", LoggingObjectType.GENERAL, null);
            database = new Database((LoggingObjectInterface)loggingInterface, databaseMeta);
            database.connect();
            String schemaTable = databaseMeta.getQuotedSchemaTableCombination(this.autoSequence.getSchemaName(), this.autoSequence.getTableName());
            String seqField = databaseMeta.quoteField(this.autoSequence.getSequenceNameField());
            String valueField = databaseMeta.quoteField(this.autoSequence.getValueField());
            String sql = "SELECT " + seqField + ", " + valueField + " FROM " + schemaTable;
            List rows = database.getRows(sql, 0);
            RowMetaInterface rowMeta = database.getReturnRowMeta();
            for (Object[] row : rows) {
                Long value;
                String sequenceName = rowMeta.getString(row, seqField, null);
                if (Const.isEmpty((String)sequenceName) || (value = rowMeta.getInteger(row, valueField, null)) == null) continue;
                SlaveSequence slaveSequence = new SlaveSequence(sequenceName, value, databaseMeta, this.autoSequence.getSchemaName(), this.autoSequence.getTableName(), this.autoSequence.getSequenceNameField(), this.autoSequence.getValueField());
                this.slaveSequences.add(slaveSequence);
                LogChannel.GENERAL.logBasic("Automatically created slave sequence '" + slaveSequence.getName() + "' with start value " + slaveSequence.getStartValue());
            }
        }
        catch (Exception e) {
            throw new KettleException("Unable to automatically configure slave sequences", (Throwable)e);
        }
        finally {
            if (database != null) {
                database.disconnect();
            }
        }
    }

    private void checkNetworkInterfaceSetting(LogChannelInterface log, Node slaveNode, SlaveServer slaveServer) {
        String networkInterfaceName = XMLHandler.getTagValue((Node)slaveNode, (String)"network_interface");
        if (!Const.isEmpty((String)networkInterfaceName)) {
            try {
                String newHostname = Const.getIPAddress((String)networkInterfaceName);
                if (newHostname != null) {
                    slaveServer.setHostname(newHostname);
                    slaveServer.setName(slaveServer.getName() + "-" + newHostname);
                    log.logBasic("Hostname for slave server [" + slaveServer.getName() + "] is set to [" + newHostname + "], information derived from network " + networkInterfaceName);
                }
            }
            catch (SocketException e) {
                log.logError("Unable to get the IP address for network interface " + networkInterfaceName + " for slave server [" + slaveServer.getName() + "]", (Throwable)e);
            }
        }
    }

    public SlaveServerConfig(String hostname, int port, boolean joining) {
        this();
        this.joining = joining;
        this.slaveServer = new SlaveServer(hostname + ":" + port, hostname, "" + port, null, null);
    }

    public List<SlaveServer> getMasters() {
        return this.masters;
    }

    public void setMasters(List<SlaveServer> masters) {
        this.masters = masters;
    }

    public SlaveServer getSlaveServer() {
        return this.slaveServer;
    }

    public void setSlaveServer(SlaveServer slaveServer) {
        this.slaveServer = slaveServer;
    }

    public boolean isReportingToMasters() {
        return this.reportingToMasters;
    }

    public void setReportingToMasters(boolean reportingToMaster) {
        this.reportingToMasters = reportingToMaster;
    }

    public boolean isJoining() {
        return this.joining;
    }

    public void setJoining(boolean joining) {
        this.joining = joining;
    }

    public int getMaxLogLines() {
        return this.maxLogLines;
    }

    public void setMaxLogLines(int maxLogLines) {
        this.maxLogLines = maxLogLines;
    }

    public int getMaxLogTimeoutMinutes() {
        return this.maxLogTimeoutMinutes;
    }

    public void setMaxLogTimeoutMinutes(int maxLogTimeoutMinutes) {
        this.maxLogTimeoutMinutes = maxLogTimeoutMinutes;
    }

    public int getObjectTimeoutMinutes() {
        return this.objectTimeoutMinutes;
    }

    public void setObjectTimeoutMinutes(int objectTimeoutMinutes) {
        this.objectTimeoutMinutes = objectTimeoutMinutes;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public List<DatabaseMeta> getDatabases() {
        return this.databases;
    }

    public void setDatabases(List<DatabaseMeta> databases) {
        this.databases = databases;
    }

    public List<SlaveSequence> getSlaveSequences() {
        return this.slaveSequences;
    }

    public void setSlaveSequences(List<SlaveSequence> slaveSequences) {
        this.slaveSequences = slaveSequences;
    }

    public SlaveSequence getAutoSequence() {
        return this.autoSequence;
    }

    public void setAutoSequence(SlaveSequence autoSequence) {
        this.autoSequence = autoSequence;
    }

    public boolean isAutomaticCreationAllowed() {
        return this.automaticCreationAllowed;
    }

    public void setAutomaticCreationAllowed(boolean automaticCreationAllowed) {
        this.automaticCreationAllowed = automaticCreationAllowed;
    }

    public List<TransDataService> getServices() {
        return this.services;
    }

    public void setServices(List<TransDataService> services) {
        this.services = services;
    }

    public Repository getRepository() throws KettleException {
        if (!Const.isEmpty((String)this.repositoryId) && this.repository == null) {
            this.openRepository(this.repositoryId);
        }
        return this.repository;
    }

    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    public String getRepositoryUsername() {
        return this.repositoryUsername;
    }

    public void setRepositoryUsername(String repositoryUsername) {
        this.repositoryUsername = repositoryUsername;
    }

    public String getRepositoryPassword() {
        return this.repositoryPassword;
    }

    public void setRepositoryPassword(String repositoryPassword) {
        this.repositoryPassword = repositoryPassword;
    }

    public DelegatingMetaStore getMetaStore() {
        return this.metaStore;
    }

    public void setMetaStore(DelegatingMetaStore metaStore) {
        this.metaStore = metaStore;
    }

    public String getPasswordFile() {
        return this.passwordFile;
    }

    public void setPasswordFile(String passwordFile) {
        this.passwordFile = passwordFile;
    }

    public String getRepositoryId() {
        return this.repositoryId;
    }

    public void setRepositoryId(String repositoryId) {
        this.repositoryId = repositoryId;
    }
}

