/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.www;

import com.sun.jersey.spi.container.servlet.ServletContainer;
import java.io.File;
import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.servlet.Servlet;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.bio.SocketConnector;
import org.mortbay.jetty.handler.ContextHandlerCollection;
import org.mortbay.jetty.handler.ResourceHandler;
import org.mortbay.jetty.plus.jaas.JAASUserRealm;
import org.mortbay.jetty.security.Constraint;
import org.mortbay.jetty.security.ConstraintMapping;
import org.mortbay.jetty.security.HashUserRealm;
import org.mortbay.jetty.security.SecurityHandler;
import org.mortbay.jetty.security.UserRealm;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.ServletHolder;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.plugins.CartePluginType;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.www.CartePluginInterface;
import org.pentaho.di.www.GetRootServlet;
import org.pentaho.di.www.JobMap;
import org.pentaho.di.www.SlaveServerDetection;
import org.pentaho.di.www.SocketRepository;
import org.pentaho.di.www.TransformationMap;

public class WebServer {
    private static Class<?> PKG = WebServer.class;
    private LogChannelInterface log;
    public static final int PORT = 80;
    private Server server;
    private TransformationMap transformationMap;
    private JobMap jobMap;
    private List<SlaveServerDetection> detections;
    private SocketRepository socketRepository;
    private String hostname;
    private int port;
    private Timer slaveMonitoringTimer;
    private String passwordFile;

    public WebServer(LogChannelInterface log, TransformationMap transformationMap, JobMap jobMap, SocketRepository socketRepository, List<SlaveServerDetection> detections, String hostname, int port, boolean join, String passwordFile) throws Exception {
        this.log = log;
        this.transformationMap = transformationMap;
        this.jobMap = jobMap;
        this.socketRepository = socketRepository;
        this.detections = detections;
        this.hostname = hostname;
        this.port = port;
        this.passwordFile = passwordFile;
        this.startServer();
        this.startSlaveMonitoring();
        if (join) {
            this.server.join();
        }
    }

    public WebServer(LogChannelInterface log, TransformationMap transformationMap, JobMap jobMap, SocketRepository socketRepository, List<SlaveServerDetection> slaveServers, String hostname, int port) throws Exception {
        this(log, transformationMap, jobMap, socketRepository, slaveServers, hostname, port, true);
    }

    public WebServer(LogChannelInterface log, TransformationMap transformationMap, JobMap jobMap, SocketRepository socketRepository, List<SlaveServerDetection> detections, String hostname, int port, boolean join) throws Exception {
        this(log, transformationMap, jobMap, socketRepository, detections, hostname, port, join, null);
    }

    public Server getServer() {
        return this.server;
    }

    public void startServer() throws Exception {
        this.server = new Server();
        Constraint constraint = new Constraint();
        constraint.setName("BASIC");
        constraint.setRoles(new String[]{"*"});
        constraint.setAuthenticate(true);
        ConstraintMapping constraintMapping = new ConstraintMapping();
        constraintMapping.setConstraint(constraint);
        constraintMapping.setPathSpec("/*");
        SecurityHandler securityHandler = new SecurityHandler();
        if (System.getProperty("loginmodulename") != null && System.getProperty("java.security.auth.login.config") != null) {
            JAASUserRealm jaasRealm = new JAASUserRealm("Kettle");
            jaasRealm.setLoginModuleName(System.getProperty("loginmodulename"));
            securityHandler.setUserRealm((UserRealm)jaasRealm);
        } else {
            if (Const.isEmpty((String)this.passwordFile)) {
                File homePwdFile = new File(Const.getKettleCartePasswordFile());
                this.passwordFile = homePwdFile.exists() ? Const.getKettleCartePasswordFile() : Const.getKettleLocalCartePasswordFile();
            }
            securityHandler.setUserRealm((UserRealm)new HashUserRealm("Kettle", this.passwordFile));
        }
        securityHandler.setConstraintMappings(new ConstraintMapping[]{constraintMapping});
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        Context root = new Context((HandlerContainer)contexts, "/", 1);
        GetRootServlet rootServlet = new GetRootServlet();
        rootServlet.setJettyMode(true);
        root.addServlet(new ServletHolder((Servlet)rootServlet), "/*");
        PluginRegistry pluginRegistry = PluginRegistry.getInstance();
        List plugins = pluginRegistry.getPlugins(CartePluginType.class);
        for (PluginInterface plugin : plugins) {
            CartePluginInterface servlet = (CartePluginInterface)pluginRegistry.loadClass(plugin);
            servlet.setup(this.transformationMap, this.jobMap, this.socketRepository, this.detections);
            servlet.setJettyMode(true);
            Context servletContext = new Context((HandlerContainer)contexts, servlet.getContextPath(), 1);
            ServletHolder servletHolder = new ServletHolder((Servlet)servlet);
            servletContext.addServlet(servletHolder, "/*");
        }
        ServletHolder jerseyServletHolder = new ServletHolder(ServletContainer.class);
        jerseyServletHolder.setInitParameter("com.sun.jersey.config.property.resourceConfigClass", "com.sun.jersey.api.core.PackagesResourceConfig");
        jerseyServletHolder.setInitParameter("com.sun.jersey.config.property.packages", "org.pentaho.di.www.jaxrs");
        root.addServlet(jerseyServletHolder, "/api/*");
        ResourceHandler resourceHandler = new ResourceHandler();
        resourceHandler.setResourceBase("temp");
        this.server.setHandlers(new Handler[]{securityHandler, contexts, resourceHandler});
        this.createListeners();
        this.server.start();
    }

    public void stopServer() {
        try {
            if (this.server != null) {
                if (this.slaveMonitoringTimer != null) {
                    this.slaveMonitoringTimer.cancel();
                    this.slaveMonitoringTimer = null;
                }
                this.socketRepository.closeAll();
                this.server.stop();
            }
        }
        catch (Exception e) {
            this.log.logError(BaseMessages.getString(PKG, (String)"WebServer.Error.FailedToStop.Title", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"WebServer.Error.FailedToStop.Msg", (String[])new String[]{"" + e})});
        }
    }

    private void createListeners() {
        SocketConnector connector = new SocketConnector();
        connector.setPort(this.port);
        connector.setHost(this.hostname);
        connector.setName(BaseMessages.getString(PKG, (String)"WebServer.Log.KettleHTTPListener", (String[])new String[]{this.hostname}));
        this.log.logBasic(BaseMessages.getString(PKG, (String)"WebServer.Log.CreateListener", (String[])new String[]{this.hostname, "" + this.port}));
        this.server.setConnectors(new Connector[]{connector});
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public List<SlaveServerDetection> getDetections() {
        return this.detections;
    }

    private void startSlaveMonitoring() {
        this.slaveMonitoringTimer = new Timer("WebServer Timer");
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                for (SlaveServerDetection slaveServerDetection : WebServer.this.detections) {
                    SlaveServer slaveServer = slaveServerDetection.getSlaveServer();
                    try {
                        slaveServer.getStatus();
                        slaveServerDetection.setActive(true);
                        slaveServerDetection.setLastActiveDate(new Date());
                    }
                    catch (Exception e) {
                        slaveServerDetection.setActive(false);
                        slaveServerDetection.setLastInactiveDate(new Date());
                    }
                }
            }
        };
        this.slaveMonitoringTimer.schedule(timerTask, 20000L, 20000L);
    }

    public SocketRepository getSocketRepository() {
        return this.socketRepository;
    }

    public void setSocketRepository(SocketRepository socketRepository) {
        this.socketRepository = socketRepository;
    }

    public String getPasswordFile() {
        return this.passwordFile;
    }

    public void setPasswordFile(String passwordFile) {
        this.passwordFile = passwordFile;
    }
}

