/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.jdbc;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.jdbc.HiveBaseResultSet;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Schema;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.service.HiveInterface;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Writable;

public class HiveQueryResultSet
extends HiveBaseResultSet {
    public static final Log LOG = LogFactory.getLog(HiveQueryResultSet.class);
    private HiveInterface client;
    private SerDe serde;
    private int maxRows = 0;
    private int rowsFetched = 0;

    public HiveQueryResultSet(HiveInterface client, Statement statement, int maxRows) throws SQLException {
        this(client, maxRows);
        this.statement = statement;
    }

    public HiveQueryResultSet(HiveInterface client, int maxRows) throws SQLException {
        this.client = client;
        this.maxRows = maxRows;
        this.initSerde();
        this.row = Arrays.asList(new Object[this.columnNames.size()]);
    }

    public HiveQueryResultSet(HiveInterface client, Statement statement) throws SQLException {
        this(client);
        this.statement = statement;
    }

    public HiveQueryResultSet(HiveInterface client) throws SQLException {
        this(client, 0);
    }

    private void initSerde() throws SQLException {
        try {
            Schema fullSchema = this.client.getSchema();
            List schema = fullSchema.getFieldSchemas();
            this.columnNames = new ArrayList();
            this.columnTypes = new ArrayList();
            StringBuilder namesSb = new StringBuilder();
            StringBuilder typesSb = new StringBuilder();
            if (schema != null && !schema.isEmpty()) {
                for (int pos = 0; pos < schema.size(); ++pos) {
                    if (pos != 0) {
                        namesSb.append(",");
                        typesSb.append(",");
                    }
                    this.columnNames.add(((FieldSchema)schema.get(pos)).getName());
                    this.columnTypes.add(((FieldSchema)schema.get(pos)).getType());
                    namesSb.append(((FieldSchema)schema.get(pos)).getName());
                    typesSb.append(((FieldSchema)schema.get(pos)).getType());
                }
            }
            String names = namesSb.toString();
            String types = typesSb.toString();
            this.serde = new LazySimpleSerDe();
            Properties props = new Properties();
            if (names.length() > 0) {
                LOG.info((Object)("Column names: " + names));
                props.setProperty("columns", names);
            }
            if (types.length() > 0) {
                LOG.info((Object)("Column types: " + types));
                props.setProperty("columns.types", types);
            }
            this.serde.initialize(new Configuration(), props);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new SQLException("Could not create ResultSet: " + ex.getMessage());
        }
    }

    public void close() throws SQLException {
        this.client = null;
    }

    public boolean next() throws SQLException {
        if (this.maxRows > 0 && this.rowsFetched >= this.maxRows) {
            return false;
        }
        String rowStr = "";
        try {
            try {
                rowStr = this.client.fetchOne();
                ++this.rowsFetched;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Fetched row string: " + rowStr));
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (!"".equals(rowStr)) {
                StructObjectInspector soi = (StructObjectInspector)this.serde.getObjectInspector();
                List fieldRefs = soi.getAllStructFieldRefs();
                Object data = this.serde.deserialize((Writable)new BytesWritable(rowStr.getBytes()));
                assert (this.row.size() == fieldRefs.size()) : this.row.size() + ", " + fieldRefs.size();
                for (int i = 0; i < fieldRefs.size(); ++i) {
                    StructField fieldRef = (StructField)fieldRefs.get(i);
                    ObjectInspector oi = fieldRef.getFieldObjectInspector();
                    Object obj = soi.getStructFieldData(data, fieldRef);
                    this.row.set(i, HiveQueryResultSet.convertLazyToJava(obj, oi));
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Deserialized row: " + this.row));
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new SQLException("Error retrieving next row");
        }
        return !"".equals(rowStr);
    }

    private static Object convertLazyToJava(Object o, ObjectInspector oi) {
        Object obj = ObjectInspectorUtils.copyToStandardObject((Object)o, (ObjectInspector)oi, (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.JAVA);
        if (obj != null && oi.getCategory() != ObjectInspector.Category.PRIMITIVE) {
            obj = obj.toString();
        }
        return obj;
    }
}

