/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.market.entry;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.core.market.Market;
import org.pentaho.di.core.market.entry.MarketEntry;
import org.pentaho.di.core.market.entry.MarketEntryType;
import org.pentaho.di.core.market.place.Marketplace;
import org.pentaho.di.core.market.place.Marketplaces;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.spoon.Spoon;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class MarketEntries
extends ArrayList<MarketEntry> {
    private static Class<?> MARKET_PKG = Market.class;
    private static final long serialVersionUID = 8998824890650364532L;

    public MarketEntries() {
        Marketplaces marketplaces = new Marketplaces();
        for (Marketplace marketplace : marketplaces) {
            try {
                Document doc = XMLHandler.loadXMLFile((InputStream)KettleVFS.getInputStream((String)marketplace.getEntriesUrl()));
                Node marketNode = XMLHandler.getSubNode((Node)doc, (String)"market");
                List entryNodes = XMLHandler.getNodes((Node)marketNode, (String)MarketEntry.XML_TAG);
                for (Node entryNode : entryNodes) {
                    MarketEntry entry = new MarketEntry(entryNode);
                    if (entry.getType() == null || entry.getType() == MarketEntryType.Platform) continue;
                    this.add(new MarketEntry(entryNode));
                }
            }
            catch (Exception e) {
                new ErrorDialog(Spoon.getInstance().getShell(), BaseMessages.getString(MARKET_PKG, (String)"Market.error", (String[])new String[0]), BaseMessages.getString(MARKET_PKG, (String)"MarketEntry.read.error", (String[])new String[]{marketplace.getName(), marketplace.getEntriesUrl()}), e);
            }
        }
    }
}

