/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.market.entry;

import java.util.Iterator;
import java.util.List;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.market.SupportLevel;
import org.pentaho.di.core.market.entry.MarketEntryType;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.core.xml.XMLInterface;
import org.w3c.dom.Node;

public class MarketEntry
implements XMLInterface {
    public static String XML_TAG = "market_entry";
    private String id;
    private MarketEntryType type;
    private String name;
    private String version;
    private String author;
    private String description;
    private String documentationUrl;
    private String sourceUrl;
    private String forumUrl;
    private String casesUrl;
    private String packageUrl;
    private String licenseName;
    private String licenseText;
    private SupportLevel supportLevel;
    private String supportMessage;
    private String supportOrganization;
    private String supportUrl;
    private String minPdiVersion;
    private String maxPdiVersion;
    private transient boolean installed;
    private transient String installedBranch;
    private transient String installedVersion;
    private transient String installedBuildId;
    private transient String marketPlaceName;

    public MarketEntry() {
    }

    public MarketEntry(String id, MarketEntryType type, String name, String version, String author, String description, String documentationUrl, String sourceUrl, String forumUrl, String casesUrl, String packageUrl, String licenseName, String licenseText, SupportLevel supportLevel, String supportMessage, String supportOrganization, String supportUrl, String minPdiVersion, String maxPdiVersion) throws KettleException {
        this();
        this.id = id;
        this.type = type;
        this.name = name;
        this.version = version;
        this.author = author;
        this.description = description;
        this.documentationUrl = documentationUrl;
        this.sourceUrl = sourceUrl;
        this.forumUrl = forumUrl;
        this.casesUrl = casesUrl;
        this.packageUrl = packageUrl;
        this.licenseName = licenseName;
        this.licenseText = licenseText;
        this.supportLevel = supportLevel;
        this.supportMessage = supportMessage;
        this.supportOrganization = supportOrganization;
        this.supportUrl = supportUrl;
        this.minPdiVersion = minPdiVersion;
        this.maxPdiVersion = maxPdiVersion;
        if (type == null) {
            throw new KettleException("The market entry type can't be null");
        }
    }

    public MarketEntry(String id, MarketEntryType type) throws KettleException {
        this(id, type, null, null, null, null, null, null, null, null, null, null, null, SupportLevel.NOT_SUPPORTED, null, null, null, null, null);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MarketEntry)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return ((MarketEntry)obj).getId().equals(this.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return "MarketEntry:" + this.getType().name() + ":" + this.id;
    }

    public String getXML() throws KettleException {
        StringBuilder xml = new StringBuilder();
        xml.append(XMLHandler.openTag((String)XML_TAG));
        xml.append(XMLHandler.addTagValue((String)"id", (String)this.id, (boolean)false, (String[])new String[0]));
        xml.append(XMLHandler.addTagValue((String)"type", (String)this.type.toString(), (boolean)false, (String[])new String[0]));
        xml.append(XMLHandler.addTagValue((String)"name", (String)this.name, (boolean)false, (String[])new String[0]));
        xml.append(XMLHandler.addTagValue((String)"description", (String)this.description, (boolean)false, (String[])new String[0]));
        xml.append(XMLHandler.openTag((String)"versions"));
        xml.append(XMLHandler.openTag((String)"version"));
        xml.append(XMLHandler.addTagValue((String)"version", (String)this.version, (boolean)false, (String[])new String[0]));
        xml.append(XMLHandler.addTagValue((String)"min_parent_version", (String)this.minPdiVersion, (boolean)false, (String[])new String[0]));
        xml.append(XMLHandler.addTagValue((String)"max_parent_version", (String)this.maxPdiVersion, (boolean)false, (String[])new String[0]));
        xml.append(XMLHandler.addTagValue((String)"package_url", (String)this.packageUrl, (boolean)false, (String[])new String[0]));
        xml.append(XMLHandler.addTagValue((String)"source_url", (String)this.sourceUrl, (boolean)false, (String[])new String[0]));
        xml.append(XMLHandler.closeTag((String)"version"));
        xml.append(XMLHandler.closeTag((String)"versions"));
        xml.append(XMLHandler.addTagValue((String)"author", (String)this.author, (boolean)false, (String[])new String[0]));
        xml.append(XMLHandler.addTagValue((String)"documentation_url", (String)this.documentationUrl, (boolean)false, (String[])new String[0]));
        xml.append(XMLHandler.addTagValue((String)"forum_url", (String)this.forumUrl, (boolean)false, (String[])new String[0]));
        xml.append(XMLHandler.addTagValue((String)"cases_url", (String)this.casesUrl, (boolean)false, (String[])new String[0]));
        xml.append(XMLHandler.addTagValue((String)"license_name", (String)this.licenseName, (boolean)false, (String[])new String[0]));
        xml.append(XMLHandler.addTagValue((String)"license_text", (String)this.licenseText, (boolean)false, (String[])new String[0]));
        xml.append(XMLHandler.addTagValue((String)"support_level", (String)this.supportLevel.toString(), (boolean)false, (String[])new String[0]));
        xml.append(XMLHandler.addTagValue((String)"support_message", (String)this.supportMessage, (boolean)false, (String[])new String[0]));
        xml.append(XMLHandler.addTagValue((String)"support_organization", (String)this.supportOrganization, (boolean)false, (String[])new String[0]));
        xml.append(XMLHandler.addTagValue((String)"support_url", (String)this.supportUrl, (boolean)false, (String[])new String[0]));
        xml.append(XMLHandler.closeTag((String)XML_TAG));
        return xml.toString();
    }

    public MarketEntry(Node node) {
        this();
        Node versionsNode;
        List versionNodes;
        Iterator i$;
        this.id = XMLHandler.getTagValue((Node)node, (String)"id");
        this.type = MarketEntryType.getMarketEntryType(XMLHandler.getTagValue((Node)node, (String)"type"));
        this.name = XMLHandler.getTagValue((Node)node, (String)"name");
        this.description = XMLHandler.getTagValue((Node)node, (String)"description");
        this.author = XMLHandler.getTagValue((Node)node, (String)"author");
        List versionsNodes = XMLHandler.getNodes((Node)node, (String)"versions");
        Iterator i$2 = versionsNodes.iterator();
        if (i$2.hasNext() && (i$ = (versionNodes = XMLHandler.getNodes((Node)(versionsNode = (Node)i$2.next()), (String)"version")).iterator()).hasNext()) {
            Node versionNode = (Node)i$.next();
            this.version = XMLHandler.getTagValue((Node)versionNode, (String)"version");
            this.packageUrl = XMLHandler.getTagValue((Node)versionNode, (String)"package_url");
            this.sourceUrl = XMLHandler.getTagValue((Node)versionNode, (String)"source_url");
            this.minPdiVersion = XMLHandler.getTagValue((Node)versionNode, (String)"min_parent_version");
            this.maxPdiVersion = XMLHandler.getTagValue((Node)versionNode, (String)"max_parent_version");
        }
        this.documentationUrl = XMLHandler.getTagValue((Node)node, (String)"documentation_url");
        this.forumUrl = XMLHandler.getTagValue((Node)node, (String)"forum_url");
        this.casesUrl = XMLHandler.getTagValue((Node)node, (String)"cases_url");
        this.licenseName = XMLHandler.getTagValue((Node)node, (String)"license_name");
        this.licenseText = XMLHandler.getTagValue((Node)node, (String)"license_text");
        this.supportLevel = SupportLevel.getSupportLevel(XMLHandler.getTagValue((Node)node, (String)"support_level"));
        this.supportMessage = XMLHandler.getTagValue((Node)node, (String)"support_message");
        this.supportOrganization = XMLHandler.getTagValue((Node)node, (String)"support_organization");
        this.supportUrl = XMLHandler.getTagValue((Node)node, (String)"support_url");
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDocumentationUrl() {
        return this.documentationUrl;
    }

    public void setDocumentationUrl(String documentationUrl) {
        this.documentationUrl = documentationUrl;
    }

    public String getPackageUrl() {
        return this.packageUrl;
    }

    public void setPackageUrl(String packageUrl) {
        this.packageUrl = packageUrl;
    }

    public String getLicenseName() {
        return this.licenseName;
    }

    public void setLicenseName(String licenseName) {
        this.licenseName = licenseName;
    }

    public String getLicenseText() {
        return this.licenseText;
    }

    public void setLicenseText(String licenseText) {
        this.licenseText = licenseText;
    }

    public SupportLevel getSupportLevel() {
        return this.supportLevel;
    }

    public void setSupportLevel(SupportLevel supportLevel) {
        this.supportLevel = supportLevel;
    }

    public String getSupportMessage() {
        return this.supportMessage;
    }

    public void setSupportMessage(String supportMessage) {
        this.supportMessage = supportMessage;
    }

    public String getSupportOrganization() {
        return this.supportOrganization;
    }

    public void setSupportOrganization(String supportOrganization) {
        this.supportOrganization = supportOrganization;
    }

    public String getSupportUrl() {
        return this.supportUrl;
    }

    public void setSupportUrl(String supportUrl) {
        this.supportUrl = supportUrl;
    }

    public MarketEntryType getType() {
        return this.type;
    }

    public void setType(MarketEntryType type) {
        this.type = type;
    }

    public String getSourceUrl() {
        return this.sourceUrl;
    }

    public void setSourceUrl(String sourceUrl) {
        this.sourceUrl = sourceUrl;
    }

    public String getForumUrl() {
        return this.forumUrl;
    }

    public void setForumUrl(String forumUrl) {
        this.forumUrl = forumUrl;
    }

    public String getCasesUrl() {
        return this.casesUrl;
    }

    public void setCasesUrl(String casesUrl) {
        this.casesUrl = casesUrl;
    }

    public String getMarketPlaceName() {
        return this.marketPlaceName;
    }

    public void setMarketPlaceName(String marketPlaceName) {
        this.marketPlaceName = marketPlaceName;
    }

    public String getMinPdiVersion() {
        return this.minPdiVersion;
    }

    public void setMinPdiVersion(String minPdiVersion) {
        this.minPdiVersion = minPdiVersion;
    }

    public String getMaxPdiVersion() {
        return this.maxPdiVersion;
    }

    public void setMaxPdiVersion(String maxPdiVersion) {
        this.maxPdiVersion = maxPdiVersion;
    }

    public boolean isInstalled() {
        return this.installed;
    }

    public void setInstalled(boolean installed) {
        this.installed = installed;
    }

    public String getInstalledBranch() {
        return this.installedBranch;
    }

    public void setInstalledBranch(String installedBranch) {
        this.installedBranch = installedBranch;
    }

    public String getInstalledBuildId() {
        return this.installedBuildId;
    }

    public void setInstalledBuildId(String installedBuildId) {
        this.installedBuildId = installedBuildId;
    }

    public String getInstalledVersion() {
        return this.installedVersion;
    }

    public void setInstalledVersion(String installedVersion) {
        this.installedVersion = installedVersion;
    }
}

