/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.auth;

import javax.security.sasl.AuthenticationException;
import org.apache.hive.service.auth.AnonymousAuthenticationProviderImpl;
import org.apache.hive.service.auth.LdapAuthenticationProviderImpl;
import org.apache.hive.service.auth.PasswdAuthenticationProvider;

public class AuthenticationProviderFactory {
    private AuthenticationProviderFactory() {
    }

    public static PasswdAuthenticationProvider getAuthenticationProvider(AuthMethods authMethod) throws AuthenticationException {
        if (authMethod.equals((Object)AuthMethods.LDAP)) {
            return new LdapAuthenticationProviderImpl();
        }
        if (authMethod.equals((Object)AuthMethods.NONE)) {
            return new AnonymousAuthenticationProviderImpl();
        }
        throw new AuthenticationException("Unsupported authentication method");
    }

    public static enum AuthMethods {
        LDAP("LDAP"),
        NONE("NONE");

        String authMethod;

        private AuthMethods(String authMethod) {
            this.authMethod = authMethod;
        }

        public String getAuthMethod() {
            return this.authMethod;
        }

        public static AuthMethods getValidAuthMethod(String authMethodStr) throws AuthenticationException {
            for (AuthMethods auth : AuthMethods.values()) {
                if (!authMethodStr.equals(auth.getAuthMethod())) continue;
                return auth;
            }
            throw new AuthenticationException("Not a valid authentication method");
        }
    }
}

