/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.cocoa.NSApplication;
import org.eclipse.swt.internal.cocoa.NSButton;
import org.eclipse.swt.internal.cocoa.NSCalendarDate;
import org.eclipse.swt.internal.cocoa.NSColor;
import org.eclipse.swt.internal.cocoa.NSControl;
import org.eclipse.swt.internal.cocoa.NSDate;
import org.eclipse.swt.internal.cocoa.NSDatePicker;
import org.eclipse.swt.internal.cocoa.NSEvent;
import org.eclipse.swt.internal.cocoa.NSFont;
import org.eclipse.swt.internal.cocoa.NSGraphicsContext;
import org.eclipse.swt.internal.cocoa.NSImage;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTButton;
import org.eclipse.swt.internal.cocoa.SWTDatePicker;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TypedListener;

public class DateTime
extends Composite {
    static final int MIN_YEAR = 1752;
    static final int MAX_YEAR = 9999;
    NSButton buttonView;
    Shell popupShell;
    DateTime popupCalendar;
    int savedYear;
    int savedMonth;
    int savedDay;
    Listener clickListener;

    public DateTime(Composite composite, int n) {
        super(composite, DateTime.checkStyle(n));
    }

    static int checkStyle(int n) {
        n &= 0xFFFFFCFF;
        if (((n = DateTime.checkBits(n, 65536, 32768, 0x10000000, 0, 0, 0)) & 0x20) == 0) {
            n &= 0xFFFFFFFB;
        }
        return DateTime.checkBits(n, 32, 128, 1024, 0, 0, 0);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        int n3 = 0;
        int n4 = 0;
        NSControl nSControl = (NSControl)this.view;
        NSSize nSSize = nSControl.cell().cellSize();
        n3 = (int)Math.ceil(nSSize.width);
        n4 = (int)Math.ceil(nSSize.height);
        if ((this.style & 4) != 0) {
            nSSize = this.buttonView.cell().cellSize();
            n3 += (int)Math.ceil(nSSize.width) - this.getBezelSize() * 2;
            n4 = Math.max(n4, (int)Math.ceil(nSSize.height));
        }
        if (n3 == 0) {
            n3 = 64;
        }
        if (n4 == 0) {
            n4 = 64;
        }
        if (n != -1) {
            n3 = n;
        }
        if (n2 != -1) {
            n4 = n2;
        }
        int n5 = this.getBorderWidth();
        return new Point(n3 += n5 * 2, n4 += n5 * 2);
    }

    void createHandle() {
        NSDatePicker nSDatePicker = (NSDatePicker)new SWTDatePicker().alloc();
        nSDatePicker.init();
        int n = (this.style & 4) != 0 ? 2 : 0;
        int n2 = 0;
        if ((this.style & 0x400) != 0) {
            n = 1;
            n2 = 224;
        } else {
            if ((this.style & 0x80) != 0) {
                int n3 = n2 = (this.style & 0x8000) != 0 ? 12 : 14;
            }
            if ((this.style & 0x20) != 0) {
                n2 = (this.style & 0x8000) != 0 ? 192 : 224;
            }
        }
        nSDatePicker.setBezeled((this.style & 0x800) != 0);
        if ((this.style & 0x800) == 0) {
            nSDatePicker.setFocusRingType(1L);
        }
        nSDatePicker.setDrawsBackground(true);
        nSDatePicker.setDatePickerStyle(n);
        nSDatePicker.setDatePickerElements(n2);
        NSCalendarDate nSCalendarDate = NSCalendarDate.calendarDate();
        nSDatePicker.setDateValue(nSCalendarDate);
        nSDatePicker.setTarget(nSDatePicker);
        nSDatePicker.setAction(OS.sel_sendSelection);
        this.view = nSDatePicker;
        if ((this.style & 4) != 0) {
            NSButton nSButton = (NSButton)new SWTButton().alloc();
            nSButton.init();
            nSButton.setButtonType(0L);
            nSButton.setBezelStyle(14L);
            nSButton.setFocusRingType(1L);
            nSButton.setTitle(NSString.stringWith(""));
            nSButton.setImagePosition(0L);
            nSButton.setTarget(this.view);
            nSButton.setAction(OS.sel_sendVerticalSelection);
            this.view.addSubview(nSButton);
            this.buttonView = nSButton;
            this.createPopupShell(-1, -1, -1);
        }
    }

    void createPopupShell(int n, int n2, int n3) {
        this.popupShell = new Shell(this.getShell(), 16392);
        this.popupShell.isPopup = true;
        this.popupShell.window.setHasShadow(true);
        this.popupCalendar = new DateTime(this.popupShell, 1024);
        if (this.font != null) {
            this.popupCalendar.setFont(this.font);
        }
        if (this.clickListener == null) {
            this.clickListener = new Listener(){

                public void handleEvent(Event event) {
                    Control control;
                    if (event.widget instanceof Control && event.widget != DateTime.this && (control = (Control)event.widget).getShell() != DateTime.this.popupShell) {
                        DateTime.this.hideCalendar();
                    }
                }
            };
        }
        this.popupCalendar.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                int n = DateTime.this.popupCalendar.getYear();
                int n2 = DateTime.this.popupCalendar.getMonth();
                int n3 = DateTime.this.popupCalendar.getDay();
                DateTime.this.setDate(n, n2, n3);
                Event event2 = new Event();
                event2.time = event.time;
                DateTime.this.notifyListeners(13, event2);
                DateTime.this.hideCalendar();
            }
        });
        this.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                if (DateTime.this.popupShell != null && !DateTime.this.popupShell.isDisposed()) {
                    DateTime.this.disposePopupShell();
                }
            }
        });
        this.addListener(16, new Listener(){

            public void handleEvent(Event event) {
                DateTime.this.hideCalendar();
                DateTime.this.display.removeFilter(3, DateTime.this.clickListener);
            }
        });
        if (n != -1) {
            this.popupCalendar.setDate(n, n2, n3);
        }
    }

    NSFont defaultNSFont() {
        return this.display.datePickerFont;
    }

    void deregister() {
        super.deregister();
        if (this.buttonView != null) {
            this.display.removeWidget(this.buttonView);
            this.display.removeWidget(this.buttonView.cell());
        }
    }

    void disposePopupShell() {
        this.popupShell.dispose();
        this.popupShell = null;
        this.popupCalendar = null;
    }

    void drawBackground(long l, NSGraphicsContext nSGraphicsContext, NSRect nSRect) {
        if (l != this.view.id) {
            return;
        }
        this.fillBackground(this.view, nSGraphicsContext, nSRect, -1);
    }

    void showCalendar() {
        if (this.isDropped()) {
            return;
        }
        this.savedYear = this.getYear();
        this.savedMonth = this.getMonth();
        this.savedDay = this.getDay();
        if (this.getShell() != this.popupShell.getParent()) {
            this.disposePopupShell();
            this.createPopupShell(this.savedYear, this.savedMonth, this.savedDay);
        }
        Point point = this.getSize();
        Point point2 = this.popupCalendar.computeSize(-1, -1, false);
        this.popupCalendar.setBounds(1, 1, Math.max(point.x - 2, point2.x), point2.y);
        this.popupCalendar.setDate(this.savedYear, this.savedMonth, this.savedDay);
        Rectangle rectangle = this.display.map((Control)this.getParent(), null, this.getBounds());
        Rectangle rectangle2 = this.getMonitor().getClientArea();
        int n = Math.max(point.x, point2.x + 2);
        int n2 = point2.y + 2;
        int n3 = rectangle.x;
        int n4 = rectangle.y + point.y;
        if (n4 + n2 > rectangle2.y + rectangle2.height) {
            n4 = rectangle.y - n2;
        }
        if (n3 + n > rectangle2.x + rectangle2.width) {
            n3 = rectangle2.x + rectangle2.width - point2.x;
        }
        this.popupShell.setBounds(n3, n4, n, n2);
        this.popupShell.setVisible(true);
        if (this.isFocusControl()) {
            this.popupCalendar.setFocus();
        }
        this.display.addFilter(3, this.clickListener);
    }

    void hideCalendar() {
        if (!this.isDropped()) {
            return;
        }
        this.popupShell.setVisible(false);
        if (!this.isDisposed() && this.isFocusControl()) {
            this.setFocus();
        }
        this.display.removeFilter(3, this.clickListener);
    }

    int getBezelInset() {
        return this.buttonView.cell().controlSize() == 2L ? 3 : 1;
    }

    int getBezelSize() {
        return this.buttonView.cell().controlSize() == 2L ? 6 : 4;
    }

    NSCalendarDate getCalendarDate() {
        NSDate nSDate = ((NSDatePicker)this.view).dateValue();
        return nSDate.dateWithCalendarFormat(null, null);
    }

    public Control[] getChildren() {
        this.checkWidget();
        return new Control[0];
    }

    public int getDay() {
        this.checkWidget();
        return (int)this.getCalendarDate().dayOfMonth();
    }

    public int getHours() {
        this.checkWidget();
        return (int)this.getCalendarDate().hourOfDay();
    }

    public int getMinutes() {
        this.checkWidget();
        return (int)this.getCalendarDate().minuteOfHour();
    }

    public int getMonth() {
        this.checkWidget();
        return (int)this.getCalendarDate().monthOfYear() - 1;
    }

    String getNameText() {
        return (this.style & 0x80) != 0 ? String.valueOf(this.getHours()) + ":" + this.getMinutes() + ":" + this.getSeconds() : String.valueOf(this.getMonth() + 1) + "/" + this.getDay() + "/" + this.getYear();
    }

    public int getSeconds() {
        this.checkWidget();
        return (int)this.getCalendarDate().secondOfMinute();
    }

    public int getYear() {
        this.checkWidget();
        return (int)this.getCalendarDate().yearOfCommonEra();
    }

    boolean isDropped() {
        return this.popupShell.getVisible();
    }

    boolean isEventView(long l) {
        return true;
    }

    boolean isFlipped(long l, long l2) {
        if ((this.style & 0x400) != 0) {
            return super.isFlipped(l, l2);
        }
        return true;
    }

    void keyDown(long l, long l2, long l3) {
        int n;
        int n2;
        if ((this.style & 4) != 0) {
            NSEvent nSEvent = new NSEvent(l3);
            n2 = Display.translateKey(nSEvent.keyCode());
            int n3 = n = (nSEvent.modifierFlags() & 0x80000L) != 0L ? 1 : 0;
            if (n != 0 && (n2 == 0x1000001 || n2 == 0x1000002)) {
                if (this.isDropped()) {
                    this.hideCalendar();
                } else {
                    this.showCalendar();
                }
                return;
            }
            if (n2 == 27) {
                this.popupCalendar.setDate(this.savedYear, this.savedMonth, this.savedDay);
                this.setDate(this.savedYear, this.savedMonth, this.savedDay);
                this.hideCalendar();
                return;
            }
        }
        super.keyDown(l, l2, l3);
        if ((this.style & 4) != 0 && this.popupCalendar != null) {
            int n4 = this.getMonth();
            n2 = this.getDay();
            n = this.getYear();
            this.popupCalendar.setDate(n, n4, n2);
        }
    }

    void register() {
        super.register();
        if (this.buttonView != null) {
            this.display.addWidget(this.buttonView, this);
            this.display.addWidget(this.buttonView.cell(), this);
        }
    }

    void releaseHandle() {
        super.releaseHandle();
        if (this.buttonView != null) {
            this.buttonView.release();
        }
        this.buttonView = null;
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    void resized() {
        super.resized();
        if (this.buttonView == null) {
            return;
        }
        NSSize nSSize = this.buttonView.cell().cellSize();
        NSRect nSRect = this.view.bounds();
        nSRect.x = nSRect.width - nSSize.width + (double)this.getBezelSize();
        nSRect.y = -this.getBezelInset();
        nSRect.width = nSSize.width;
        nSRect.height = nSSize.height;
        this.buttonView.setFrame(nSRect);
    }

    boolean sendKeyEvent(NSEvent nSEvent, int n) {
        boolean bl = super.sendKeyEvent(nSEvent, n);
        if (!bl) {
            return bl;
        }
        if (n != 1) {
            return bl;
        }
        if ((this.style & 0x400) == 0) {
            short s = nSEvent.keyCode();
            switch (s) {
                case 36: 
                case 76: {
                    this.hideCalendar();
                    this.sendSelectionEvent(14);
                }
            }
        }
        return bl;
    }

    void sendSelection() {
        NSEvent nSEvent = NSApplication.sharedApplication().currentEvent();
        if (nSEvent != null && (this.style & 0x400) != 0) {
            if (nSEvent.clickCount() == 2L) {
                this.sendSelectionEvent(14);
            } else if (nSEvent.type() == 2L) {
                this.sendSelectionEvent(13);
            }
        } else {
            this.sendSelectionEvent(13);
        }
    }

    void sendVerticalSelection() {
        this.setFocus();
        if (this.isDropped()) {
            this.hideCalendar();
        } else {
            this.showCalendar();
        }
    }

    void setBackgroundColor(NSColor nSColor) {
        ((NSDatePicker)this.view).setBackgroundColor(nSColor);
    }

    void setBackgroundImage(NSImage nSImage) {
        ((NSDatePicker)this.view).setDrawsBackground(nSImage == null);
    }

    public void setDate(int n, int n2, int n3) {
        this.checkWidget();
        if (n < 1752 || n > 9999) {
            return;
        }
        NSCalendarDate nSCalendarDate = this.getCalendarDate();
        NSCalendarDate nSCalendarDate2 = NSCalendarDate.dateWithYear(n, n2 + 1, n3, nSCalendarDate.hourOfDay(), nSCalendarDate.minuteOfHour(), nSCalendarDate.secondOfMinute(), nSCalendarDate.timeZone());
        if (nSCalendarDate2.yearOfCommonEra() == (long)n && nSCalendarDate2.monthOfYear() == (long)(n2 + 1) && nSCalendarDate2.dayOfMonth() == (long)n3) {
            ((NSDatePicker)this.view).setDateValue(nSCalendarDate2);
        }
    }

    public void setDay(int n) {
        this.checkWidget();
        NSCalendarDate nSCalendarDate = this.getCalendarDate();
        NSCalendarDate nSCalendarDate2 = NSCalendarDate.dateWithYear(nSCalendarDate.yearOfCommonEra(), nSCalendarDate.monthOfYear(), n, nSCalendarDate.hourOfDay(), nSCalendarDate.minuteOfHour(), nSCalendarDate.secondOfMinute(), nSCalendarDate.timeZone());
        if (nSCalendarDate2.yearOfCommonEra() == nSCalendarDate.yearOfCommonEra() && nSCalendarDate2.monthOfYear() == nSCalendarDate.monthOfYear() && nSCalendarDate2.dayOfMonth() == (long)n) {
            ((NSDatePicker)this.view).setDateValue(nSCalendarDate2);
        }
    }

    void setForeground(double[] dArray) {
        NSColor nSColor = dArray == null ? ((this.style & 0x400) != 0 ? NSColor.controlTextColor() : NSColor.textColor()) : NSColor.colorWithDeviceRed(dArray[0], dArray[1], dArray[2], 1.0);
        ((NSDatePicker)this.view).setTextColor(nSColor);
    }

    public void setHours(int n) {
        this.checkWidget();
        if (n < 0 || n > 23) {
            return;
        }
        NSCalendarDate nSCalendarDate = this.getCalendarDate();
        NSCalendarDate nSCalendarDate2 = NSCalendarDate.dateWithYear(nSCalendarDate.yearOfCommonEra(), nSCalendarDate.monthOfYear(), nSCalendarDate.dayOfMonth(), n, nSCalendarDate.minuteOfHour(), nSCalendarDate.secondOfMinute(), nSCalendarDate.timeZone());
        ((NSDatePicker)this.view).setDateValue(nSCalendarDate2);
    }

    public void setMinutes(int n) {
        this.checkWidget();
        if (n < 0 || n > 59) {
            return;
        }
        NSCalendarDate nSCalendarDate = this.getCalendarDate();
        NSCalendarDate nSCalendarDate2 = NSCalendarDate.dateWithYear(nSCalendarDate.yearOfCommonEra(), nSCalendarDate.monthOfYear(), nSCalendarDate.dayOfMonth(), nSCalendarDate.hourOfDay(), n, nSCalendarDate.secondOfMinute(), nSCalendarDate.timeZone());
        ((NSDatePicker)this.view).setDateValue(nSCalendarDate2);
    }

    public void setMonth(int n) {
        this.checkWidget();
        NSCalendarDate nSCalendarDate = this.getCalendarDate();
        NSCalendarDate nSCalendarDate2 = NSCalendarDate.dateWithYear(nSCalendarDate.yearOfCommonEra(), n + 1, nSCalendarDate.dayOfMonth(), nSCalendarDate.hourOfDay(), nSCalendarDate.minuteOfHour(), nSCalendarDate.secondOfMinute(), nSCalendarDate.timeZone());
        if (nSCalendarDate2.yearOfCommonEra() == nSCalendarDate.yearOfCommonEra() && nSCalendarDate2.monthOfYear() == (long)(n + 1) && nSCalendarDate2.dayOfMonth() == nSCalendarDate.dayOfMonth()) {
            ((NSDatePicker)this.view).setDateValue(nSCalendarDate2);
        }
    }

    public void setSeconds(int n) {
        this.checkWidget();
        if (n < 0 || n > 59) {
            return;
        }
        NSCalendarDate nSCalendarDate = this.getCalendarDate();
        NSCalendarDate nSCalendarDate2 = NSCalendarDate.dateWithYear(nSCalendarDate.yearOfCommonEra(), nSCalendarDate.monthOfYear(), nSCalendarDate.dayOfMonth(), nSCalendarDate.hourOfDay(), nSCalendarDate.minuteOfHour(), n, nSCalendarDate.timeZone());
        ((NSDatePicker)this.view).setDateValue(nSCalendarDate2);
    }

    void setSmallSize() {
        if (this.buttonView != null) {
            this.buttonView.cell().setControlSize(2L);
        }
    }

    public void setTime(int n, int n2, int n3) {
        this.checkWidget();
        if (n < 0 || n > 23 || n2 < 0 || n2 > 59 || n3 < 0 || n3 > 59) {
            return;
        }
        NSCalendarDate nSCalendarDate = this.getCalendarDate();
        NSCalendarDate nSCalendarDate2 = NSCalendarDate.dateWithYear(nSCalendarDate.yearOfCommonEra(), nSCalendarDate.monthOfYear(), nSCalendarDate.dayOfMonth(), n, n2, n3, nSCalendarDate.timeZone());
        ((NSDatePicker)this.view).setDateValue(nSCalendarDate2);
    }

    public void setYear(int n) {
        this.checkWidget();
        if (n < 1752 || n > 9999) {
            return;
        }
        NSCalendarDate nSCalendarDate = this.getCalendarDate();
        NSCalendarDate nSCalendarDate2 = NSCalendarDate.dateWithYear(n, nSCalendarDate.monthOfYear(), nSCalendarDate.dayOfMonth(), nSCalendarDate.hourOfDay(), nSCalendarDate.minuteOfHour(), nSCalendarDate.secondOfMinute(), nSCalendarDate.timeZone());
        if (nSCalendarDate2.yearOfCommonEra() == (long)n && nSCalendarDate2.monthOfYear() == nSCalendarDate.monthOfYear() && nSCalendarDate2.dayOfMonth() == nSCalendarDate.dayOfMonth()) {
            ((NSDatePicker)this.view).setDateValue(nSCalendarDate2);
        }
    }
}

