/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.logicalLayer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.LOCogroup;
import org.apache.pig.impl.logicalLayer.LOCross;
import org.apache.pig.impl.logicalLayer.LODistinct;
import org.apache.pig.impl.logicalLayer.LOFilter;
import org.apache.pig.impl.logicalLayer.LOForEach;
import org.apache.pig.impl.logicalLayer.LOJoin;
import org.apache.pig.impl.logicalLayer.LOLimit;
import org.apache.pig.impl.logicalLayer.LOLoad;
import org.apache.pig.impl.logicalLayer.LOSort;
import org.apache.pig.impl.logicalLayer.LOSplit;
import org.apache.pig.impl.logicalLayer.LOSplitOutput;
import org.apache.pig.impl.logicalLayer.LOStore;
import org.apache.pig.impl.logicalLayer.LOStream;
import org.apache.pig.impl.logicalLayer.LOUnion;
import org.apache.pig.impl.logicalLayer.LOVisitor;
import org.apache.pig.impl.logicalLayer.LogicalOperator;
import org.apache.pig.impl.logicalLayer.LogicalPlan;
import org.apache.pig.impl.logicalLayer.RelationalOperator;
import org.apache.pig.impl.plan.DependencyOrderWalker;
import org.apache.pig.impl.plan.PlanWalker;
import org.apache.pig.impl.plan.RequiredFields;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.impl.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColumnPruner
extends LOVisitor {
    private Map<LogicalOperator, List<Pair<Integer, Integer>>> prunedColumnsMap = new HashMap<LogicalOperator, List<Pair<Integer, Integer>>>();
    LogicalPlan plan;

    public ColumnPruner(LogicalPlan plan) {
        super(plan, (PlanWalker<LogicalOperator, LogicalPlan>)new DependencyOrderWalker<LogicalOperator, LogicalPlan>(plan));
        this.plan = plan;
    }

    public void addPruneMap(LogicalOperator op, List<Pair<Integer, Integer>> prunedColumns) {
        this.prunedColumnsMap.put(op, prunedColumns);
    }

    public boolean isEmpty() {
        return this.prunedColumnsMap.isEmpty();
    }

    protected void prune(RelationalOperator lOp) throws VisitorException {
        int i;
        List<RelationalOperator> predecessors = this.plan.getPredecessors(lOp);
        if (predecessors == null) {
            int errCode = 2187;
            throw new VisitorException("Cannot get predessors", errCode, 4);
        }
        ArrayList<Pair<Integer, Integer>> columnsPruned = new ArrayList<Pair<Integer, Integer>>();
        ArrayList<Pair<Integer, Integer>> columnsToPrune = new ArrayList<Pair<Integer, Integer>>();
        for (i = 0; i < predecessors.size(); ++i) {
            List<Pair<Integer, Integer>> predColumnsToPrune;
            RelationalOperator predecessor = predecessors.get(i);
            if (!this.prunedColumnsMap.containsKey(predecessor) || (predColumnsToPrune = this.prunedColumnsMap.get(predecessor)) == null) continue;
            for (int j = 0; j < predColumnsToPrune.size(); ++j) {
                predColumnsToPrune.get((int)j).first = i;
            }
            columnsPruned.addAll(predColumnsToPrune);
        }
        try {
            if (lOp.getSchema() == null) {
                int errCode = 2189;
                throw new VisitorException("Expect schema", errCode, 4);
            }
            for (i = 0; i < lOp.getSchema().size(); ++i) {
                List<RequiredFields> relevantFieldsList = lOp.getRelevantInputs(0, i);
                boolean needNoInputs = true;
                if (relevantFieldsList == null) {
                    needNoInputs = true;
                } else {
                    for (RequiredFields relevantFields : relevantFieldsList) {
                        if (relevantFields == null || relevantFields.needNoFields()) continue;
                        needNoInputs = false;
                    }
                }
                if (needNoInputs) continue;
                boolean columnPruned = false;
                if (lOp instanceof LOCogroup) {
                    List<RequiredFields> requiredFieldsList = lOp.getRequiredFields();
                    for (Pair pair : columnsPruned) {
                        if ((Integer)pair.first != i - 1 || !requiredFieldsList.get(i - 1).getFields().contains(pair)) continue;
                        columnPruned = true;
                        break;
                    }
                } else {
                    block7: for (RequiredFields relevantFields : relevantFieldsList) {
                        if (relevantFields == null) continue;
                        if (!relevantFields.getNeedAllFields()) {
                            for (Pair<Integer, Integer> relevantField : relevantFields.getFields()) {
                                if (!columnsPruned.contains(relevantField)) continue;
                                columnPruned = true;
                                continue block7;
                            }
                            continue;
                        }
                        break;
                    }
                }
                if (!columnPruned) continue;
                columnsToPrune.add(new Pair<Integer, Integer>(0, i));
            }
            LogicalOperator currentOp = lOp;
            if (columnsPruned.size() != 0 && lOp instanceof LOCogroup) {
                ArrayList<Integer> columnsToProject = new ArrayList<Integer>();
                for (int i2 = 0; i2 <= predecessors.size(); ++i2) {
                    if (columnsToPrune.contains(new Pair<Integer, Integer>(0, i2))) continue;
                    columnsToProject.add(i2);
                }
                currentOp = lOp.insertPlainForEachAfter(columnsToProject);
            }
            if (!columnsPruned.isEmpty() && lOp.pruneColumns(columnsPruned)) {
                this.prunedColumnsMap.put(currentOp, columnsToPrune);
            }
        }
        catch (FrontendException e) {
            int errCode = 2188;
            throw new VisitorException("Cannot prune columns for " + lOp, errCode, 4, e);
        }
    }

    @Override
    protected void visit(LOCogroup cogroup) throws VisitorException {
        this.prune(cogroup);
    }

    @Override
    protected void visit(LOCross cross) throws VisitorException {
        this.prune(cross);
    }

    @Override
    protected void visit(LODistinct distinct) throws VisitorException {
        this.prune(distinct);
    }

    @Override
    protected void visit(LOFilter filter) throws VisitorException {
        this.prune(filter);
    }

    @Override
    protected void visit(LOForEach foreach) throws VisitorException {
        if (!this.prunedColumnsMap.containsKey(foreach)) {
            this.prune(foreach);
        }
    }

    @Override
    protected void visit(LOJoin join) throws VisitorException {
        this.prune(join);
    }

    @Override
    protected void visit(LOLimit limit) throws VisitorException {
        this.prune(limit);
    }

    @Override
    protected void visit(LOSort sort) throws VisitorException {
        this.prune(sort);
    }

    @Override
    protected void visit(LOSplit split) throws VisitorException {
        this.prune(split);
    }

    @Override
    protected void visit(LOSplitOutput splitoutput) throws VisitorException {
        this.prune(splitoutput);
    }

    @Override
    protected void visit(LOStore store) throws VisitorException {
    }

    @Override
    protected void visit(LOStream stream) throws VisitorException {
    }

    @Override
    protected void visit(LOUnion union) throws VisitorException {
        this.prune(union);
    }

    @Override
    protected void visit(LOLoad lOp) throws VisitorException {
    }
}

