/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.logical.relational;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.PlanVisitor;
import org.apache.pig.newplan.logical.expression.LogicalExpression;
import org.apache.pig.newplan.logical.expression.LogicalExpressionPlan;
import org.apache.pig.newplan.logical.relational.LogicalRelationalNodesVisitor;
import org.apache.pig.newplan.logical.relational.LogicalRelationalOperator;
import org.apache.pig.newplan.logical.relational.LogicalSchema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LOGenerate
extends LogicalRelationalOperator {
    private List<LogicalExpressionPlan> outputPlans;
    private boolean[] flattenFlags;
    private List<LogicalSchema> mUserDefinedSchema = null;
    private List<LogicalSchema> outputPlanSchemas = null;
    private List<LogicalSchema> uidOnlySchemas = null;

    public LOGenerate(OperatorPlan plan, List<LogicalExpressionPlan> ps, boolean[] flatten) {
        super("LOGenerate", plan);
        this.outputPlans = ps;
        this.flattenFlags = flatten;
    }

    @Override
    public LogicalSchema getSchema() throws FrontendException {
        int i;
        if (this.schema != null) {
            return this.schema;
        }
        if (this.uidOnlySchemas == null) {
            this.uidOnlySchemas = new ArrayList<LogicalSchema>();
            for (i = 0; i < this.outputPlans.size(); ++i) {
                this.uidOnlySchemas.add(null);
            }
        }
        this.schema = new LogicalSchema();
        this.outputPlanSchemas = new ArrayList<LogicalSchema>();
        for (i = 0; i < this.outputPlans.size(); ++i) {
            LogicalExpression exp = (LogicalExpression)this.outputPlans.get(i).getSources().get(0);
            LogicalSchema mUserDefinedSchemaCopy = null;
            if (this.mUserDefinedSchema != null && this.mUserDefinedSchema.get(i) != null) {
                mUserDefinedSchemaCopy = new LogicalSchema();
                for (LogicalSchema.LogicalFieldSchema fs : this.mUserDefinedSchema.get(i).getFields()) {
                    mUserDefinedSchemaCopy.addField(fs.deepCopy());
                }
            }
            LogicalSchema.LogicalFieldSchema fieldSchema = null;
            LogicalSchema expSchema = null;
            if (exp.getFieldSchema() != null) {
                fieldSchema = exp.getFieldSchema().deepCopy();
                expSchema = new LogicalSchema();
                if (!this.flattenFlags[i] || fieldSchema.type != 110 && fieldSchema.type != 120) {
                    if (fieldSchema != null) {
                        expSchema.addField(fieldSchema);
                    } else {
                        expSchema = null;
                    }
                } else if (fieldSchema.schema == null) {
                    expSchema = null;
                } else {
                    List<Object> innerFieldSchemas = new ArrayList();
                    if (fieldSchema.type == 120) {
                        if (fieldSchema.schema != null) {
                            innerFieldSchemas = fieldSchema.schema.isTwoLevelAccessRequired() ? fieldSchema.schema.getField((int)0).schema.getFields() : fieldSchema.schema.getFields();
                            for (LogicalSchema.LogicalFieldSchema logicalFieldSchema : innerFieldSchemas) {
                                logicalFieldSchema.alias = fieldSchema.alias + "::" + logicalFieldSchema.alias;
                            }
                        }
                    } else {
                        innerFieldSchemas = fieldSchema.schema.getFields();
                        for (LogicalSchema.LogicalFieldSchema logicalFieldSchema : innerFieldSchemas) {
                            logicalFieldSchema.alias = fieldSchema.alias + "::" + logicalFieldSchema.alias;
                        }
                    }
                    for (LogicalSchema.LogicalFieldSchema logicalFieldSchema : innerFieldSchemas) {
                        expSchema.addField(logicalFieldSchema);
                    }
                }
            }
            if (expSchema != null && expSchema.size() == 0) {
                expSchema = null;
            }
            LogicalSchema planSchema = new LogicalSchema();
            if (mUserDefinedSchemaCopy != null) {
                LogicalSchema mergedSchema = new LogicalSchema();
                if (expSchema == null) {
                    for (LogicalSchema.LogicalFieldSchema fs : mUserDefinedSchemaCopy.getFields()) {
                        fs.stampFieldSchema();
                        mergedSchema.addField(fs);
                    }
                } else {
                    mergedSchema = LogicalSchema.merge(mUserDefinedSchemaCopy, expSchema);
                    if (mergedSchema == null) {
                        throw new FrontendException("Cannot merge (" + expSchema.toString(false) + ") with user defined schema (" + mUserDefinedSchemaCopy.toString(false) + ")", 1117);
                    }
                    mergedSchema.mergeUid(expSchema);
                }
                for (LogicalSchema.LogicalFieldSchema fs : mergedSchema.getFields()) {
                    planSchema.addField(fs);
                }
            } else if (expSchema == null) {
                planSchema = null;
            } else {
                for (LogicalSchema.LogicalFieldSchema logicalFieldSchema : expSchema.getFields()) {
                    planSchema.addField(logicalFieldSchema);
                }
            }
            if (planSchema == null) {
                this.schema = null;
                break;
            }
            for (LogicalSchema.LogicalFieldSchema logicalFieldSchema : planSchema.getFields()) {
                this.schema.addField(logicalFieldSchema);
            }
            if (expSchema == null) {
                LogicalSchema uidOnlySchema = planSchema.mergeUid(this.uidOnlySchemas.get(i));
                this.uidOnlySchemas.set(i, uidOnlySchema);
            }
            this.outputPlanSchemas.add(planSchema);
        }
        if (this.schema == null || this.schema.size() == 0) {
            this.schema = null;
            this.outputPlanSchemas = null;
        }
        return this.schema;
    }

    public List<LogicalExpressionPlan> getOutputPlans() {
        return this.outputPlans;
    }

    public boolean[] getFlattenFlags() {
        return this.flattenFlags;
    }

    public void setFlattenFlags(boolean[] flatten) {
        this.flattenFlags = flatten;
    }

    @Override
    public boolean isEqual(Operator other) throws FrontendException {
        if (!(other instanceof LOGenerate)) {
            return false;
        }
        List<LogicalExpressionPlan> otherPlan = ((LOGenerate)other).getOutputPlans();
        boolean[] fs = ((LOGenerate)other).getFlattenFlags();
        if (this.outputPlans.size() != otherPlan.size()) {
            return false;
        }
        for (int i = 0; i < this.outputPlans.size(); ++i) {
            if (this.flattenFlags[i] != fs[i]) {
                return false;
            }
            if (this.outputPlans.get(i).isEqual(otherPlan.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public void accept(PlanVisitor v) throws FrontendException {
        if (!(v instanceof LogicalRelationalNodesVisitor)) {
            throw new FrontendException("Expected LogicalPlanVisitor", 2223);
        }
        ((LogicalRelationalNodesVisitor)v).visit(this);
    }

    @Override
    public String toString() {
        StringBuilder msg = new StringBuilder();
        if (this.alias != null) {
            msg.append(this.alias + ": ");
        }
        msg.append("(Name: " + this.name + "[");
        for (int i = 0; i < this.flattenFlags.length; ++i) {
            msg.append(this.flattenFlags[i]);
            if (i == this.flattenFlags.length - 1) continue;
            msg.append(",");
        }
        msg.append("] Schema: ");
        if (this.schema != null) {
            msg.append(this.schema);
        } else {
            msg.append("null");
        }
        msg.append(")");
        if (this.annotations != null) {
            for (Map.Entry entry : this.annotations.entrySet()) {
                msg.append(entry);
            }
        }
        return msg.toString();
    }

    public List<LogicalSchema> getUserDefinedSchema() {
        return this.mUserDefinedSchema;
    }

    public void setUserDefinedSchema(List<LogicalSchema> userDefinedSchema) {
        this.mUserDefinedSchema = userDefinedSchema;
    }

    public List<LogicalSchema> getOutputPlanSchemas() {
        return this.outputPlanSchemas;
    }

    public void setOutputPlanSchemas(List<LogicalSchema> outputPlanSchemas) {
        this.outputPlanSchemas = outputPlanSchemas;
    }

    public List<LogicalSchema> getUidOnlySchemas() {
        return this.uidOnlySchemas;
    }

    public void setUidOnlySchemas(List<LogicalSchema> uidOnlySchemas) {
        this.uidOnlySchemas = uidOnlySchemas;
    }

    @Override
    public void resetUid() {
        this.uidOnlySchemas = null;
    }
}

