/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.shim;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.vfs.FileObject;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.hadoop.shim.ConfigurationException;
import org.pentaho.hadoop.shim.spi.HadoopShim;
import org.pentaho.hadoop.shim.spi.PentahoHadoopShim;
import org.pentaho.hadoop.shim.spi.PigShim;
import org.pentaho.hadoop.shim.spi.SnappyShim;
import org.pentaho.hadoop.shim.spi.SqoopShim;
import org.pentaho.hbase.shim.spi.HBaseShim;

public class HadoopConfiguration {
    private static final Class<?> PKG = HadoopConfiguration.class;
    private String identifier;
    private String name;
    private FileObject location;
    private HadoopShim hadoopShim;
    private List<PentahoHadoopShim> availableShims;

    public HadoopConfiguration(FileObject location, String identifier, String name, HadoopShim hadoopShim, PentahoHadoopShim ... shims) {
        if (location == null || identifier == null || name == null || hadoopShim == null) {
            throw new NullPointerException();
        }
        this.location = location;
        this.identifier = identifier;
        this.name = name;
        this.hadoopShim = hadoopShim;
        this.availableShims = new ArrayList<PentahoHadoopShim>();
        this.availableShims.add(hadoopShim);
        for (PentahoHadoopShim shim : shims) {
            if (shim == null) continue;
            this.availableShims.add(shim);
        }
    }

    public FileObject getLocation() {
        return this.location;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getName() {
        return this.name;
    }

    public HadoopShim getHadoopShim() {
        return this.hadoopShim;
    }

    public SqoopShim getSqoopShim() throws ConfigurationException {
        return this.getShim(SqoopShim.class);
    }

    public PigShim getPigShim() throws ConfigurationException {
        return this.getShim(PigShim.class);
    }

    public SnappyShim getSnappyShim() throws ConfigurationException {
        return this.getShim(SnappyShim.class);
    }

    public <T extends PentahoHadoopShim> T getShim(Class<T> shimType) throws ConfigurationException {
        for (PentahoHadoopShim shim : this.availableShims) {
            if (!shimType.isAssignableFrom(shim.getClass())) continue;
            PentahoHadoopShim t = shim;
            return (T)t;
        }
        throw new ConfigurationException(BaseMessages.getString(PKG, (String)"Error.UnsupportedShim", (String[])new String[]{this.getName(), shimType.getSimpleName()}));
    }

    public HBaseShim getHBaseShim() throws ConfigurationException {
        return this.getShim(HBaseShim.class);
    }

    public String toString() {
        return this.getIdentifier();
    }
}

