/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.shim;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.impl.DefaultFileSystemManager;
import org.apache.commons.vfs.provider.FileProvider;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.hadoop.shim.ActiveHadoopShimFileProvider;
import org.pentaho.hadoop.shim.ConfigurationException;
import org.pentaho.hadoop.shim.HadoopConfiguration;
import org.pentaho.hadoop.shim.spi.HadoopConfigurationProvider;

public class HadoopConfigurationFileSystemManager {
    private static final Class<?> PKG = HadoopConfigurationFileSystemManager.class;
    private HadoopConfigurationProvider configProvider;
    private DefaultFileSystemManager delegate;
    private Map<String, ActiveHadoopShimFileProvider> providerProxies;
    private Map<HadoopConfiguration, Map<String, FileProvider>> providersByConfiguration;

    public HadoopConfigurationFileSystemManager(HadoopConfigurationProvider configProvider, DefaultFileSystemManager delegate) {
        if (configProvider == null || delegate == null) {
            throw new NullPointerException();
        }
        this.configProvider = configProvider;
        this.delegate = delegate;
        this.providerProxies = new HashMap<String, ActiveHadoopShimFileProvider>();
        this.providersByConfiguration = new HashMap<HadoopConfiguration, Map<String, FileProvider>>();
    }

    public synchronized void addProvider(HadoopConfiguration config, String scheme, String alias, FileProvider p) throws FileSystemException {
        Map<String, FileProvider> providersForConfig;
        ActiveHadoopShimFileProvider provider = this.providerProxies.get(scheme);
        if (provider == null) {
            provider = new ActiveHadoopShimFileProvider(this, scheme);
            this.providerProxies.put(scheme, provider);
            this.delegate.addProvider(scheme, (FileProvider)provider);
        }
        if ((providersForConfig = this.providersByConfiguration.get(config)) == null) {
            providersForConfig = new HashMap<String, FileProvider>();
            this.providersByConfiguration.put(config, providersForConfig);
        }
        if (providersForConfig.containsKey(scheme)) {
            throw new FileSystemException(BaseMessages.getString(PKG, (String)"Error.SchemeAlreadyRegistered", (String[])new String[]{scheme}));
        }
        providersForConfig.put(scheme, p);
        this.delegate.addProvider(scheme + "-" + alias, p);
    }

    public FileProvider getFileProvider(HadoopConfiguration config, String scheme) throws FileSystemException {
        Map<String, FileProvider> providers = this.providersByConfiguration.get(config);
        FileProvider p = null;
        if (providers != null) {
            p = providers.get(scheme);
        }
        if (p == null) {
            throw new FileSystemException(BaseMessages.getString(PKG, (String)"Error.UnsupportedSchemeForConfiguration", (String[])new String[]{config.getName(), scheme}));
        }
        return p;
    }

    public FileProvider getActiveFileProvider(String scheme) throws FileSystemException {
        try {
            return this.getFileProvider(this.configProvider.getActiveConfiguration(), scheme);
        }
        catch (ConfigurationException e) {
            throw new FileSystemException((Throwable)e);
        }
    }

    public boolean hasProvider(String scheme) {
        return this.delegate.hasProvider(scheme);
    }
}

