/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.ui.xul.binding;

import org.pentaho.ui.xul.binding.Binding;
import org.pentaho.ui.xul.binding.BindingConvertor;
import org.pentaho.ui.xul.binding.BindingExceptionHandler;
import org.pentaho.ui.xul.binding.BindingFactory;
import org.pentaho.ui.xul.binding.DefaultBinding;
import org.pentaho.ui.xul.dom.Document;

public class DefaultBindingFactory
implements BindingFactory {
    private Document document;
    private Binding.Type type = Binding.Type.BI_DIRECTIONAL;
    private BindingExceptionHandler exceptionHandler;

    @Override
    public void setDocument(Document document) {
        this.document = document;
    }

    @Override
    public void setBindingType(Binding.Type type) {
        this.type = type;
    }

    private Binding applyBinding(Binding b, BindingConvertor ... converters) {
        b.setBindingType(this.type);
        b.setExceptionHandler(this.exceptionHandler);
        if (converters != null && converters.length > 0) {
            b.setConversion(converters[0]);
        }
        b.initialize();
        this.document.addInitializedBinding(b);
        return b;
    }

    private void constraintsCheck() {
        if (this.document == null) {
            throw new IllegalArgumentException("document is null.  Did you forget to set the document on the DefaultBindingFactory?");
        }
    }

    @Override
    public Binding createBinding(String sourceId, String sourceAttr, String targetId, String targetAttr, BindingConvertor ... converters) {
        this.constraintsCheck();
        DefaultBinding b = new DefaultBinding(this.document.getElementById(sourceId), sourceAttr, this.document.getElementById(targetId), targetAttr);
        return this.applyBinding(b, converters);
    }

    @Override
    public Binding createBinding(Object source, String sourceAttr, String targetId, String targetAttr, BindingConvertor ... converters) {
        this.constraintsCheck();
        DefaultBinding b = new DefaultBinding(source, sourceAttr, this.document.getElementById(targetId), targetAttr);
        return this.applyBinding(b, converters);
    }

    @Override
    public Binding createBinding(String sourceId, String sourceAttr, Object target, String targetAttr, BindingConvertor ... converters) {
        this.constraintsCheck();
        DefaultBinding b = new DefaultBinding(this.document.getElementById(sourceId), sourceAttr, target, targetAttr);
        return this.applyBinding(b, converters);
    }

    @Override
    public Binding createBinding(Object source, String sourceAttr, Object target, String targetAttr, BindingConvertor ... converters) {
        DefaultBinding b = new DefaultBinding(source, sourceAttr, target, targetAttr);
        return this.applyBinding(b, converters);
    }

    @Override
    public void setExceptionHandler(BindingExceptionHandler handler) {
        this.exceptionHandler = handler;
    }
}

