/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.jdbc;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import javax.security.sasl.SaslException;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hive.jdbc.HiveDatabaseMetaData;
import org.apache.hive.jdbc.HivePreparedStatement;
import org.apache.hive.jdbc.HiveStatement;
import org.apache.hive.jdbc.Utils;
import org.apache.hive.service.auth.KerberosSaslHelper;
import org.apache.hive.service.auth.PlainSaslHelper;
import org.apache.hive.service.cli.thrift.EmbeddedThriftCLIService;
import org.apache.hive.service.cli.thrift.TCLIService;
import org.apache.hive.service.cli.thrift.TCloseSessionReq;
import org.apache.hive.service.cli.thrift.TOpenSessionReq;
import org.apache.hive.service.cli.thrift.TOpenSessionResp;
import org.apache.hive.service.cli.thrift.TProtocolVersion;
import org.apache.hive.service.cli.thrift.TSessionHandle;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HiveConnection
implements Connection {
    private static final String HIVE_AUTH_TYPE = "auth";
    private static final String HIVE_AUTH_SIMPLE = "noSasl";
    private static final String HIVE_AUTH_USER = "user";
    private static final String HIVE_AUTH_PRINCIPAL = "principal";
    private static final String HIVE_AUTH_PASSWD = "password";
    private static final String HIVE_ANONYMOUS_USER = "anonymous";
    private static final String HIVE_ANONYMOUS_PASSWD = "anonymous";
    private TTransport transport;
    private TCLIService.Iface client;
    private boolean isClosed = true;
    private SQLWarning warningChain = null;
    private TSessionHandle sessHandle = null;
    private final List<TProtocolVersion> supportedProtocols = new LinkedList<TProtocolVersion>();

    public HiveConnection(String uri, Properties info) throws SQLException {
        Utils.JdbcConnectionParams connParams = Utils.parseURL(uri);
        if (connParams.isEmbeddedMode()) {
            this.client = new EmbeddedThriftCLIService();
        } else {
            if (info.containsKey(HIVE_AUTH_USER)) {
                connParams.getSessionVars().put(HIVE_AUTH_USER, info.getProperty(HIVE_AUTH_USER));
                if (info.containsKey(HIVE_AUTH_PASSWD)) {
                    connParams.getSessionVars().put(HIVE_AUTH_PASSWD, info.getProperty(HIVE_AUTH_PASSWD));
                }
            }
            this.openTransport(uri, connParams.getHost(), connParams.getPort(), connParams.getSessionVars());
        }
        this.supportedProtocols.add(TProtocolVersion.HIVE_CLI_SERVICE_PROTOCOL_V1);
        this.openSession(uri);
        this.configureConnection(connParams);
    }

    private void configureConnection(Utils.JdbcConnectionParams connParams) throws SQLException {
        if (connParams.isEmbeddedMode()) {
            if (!connParams.getHiveVars().isEmpty()) {
                SessionState.get().setHiveVariables(connParams.getHiveVars());
            }
        } else {
            Statement stmt = this.createStatement();
            for (Map.Entry<String, String> hiveConf : connParams.getHiveConfs().entrySet()) {
                stmt.execute("set " + hiveConf.getKey() + "=" + hiveConf.getValue());
                stmt.close();
            }
        }
    }

    private void openTransport(String uri, String host, int port, Map<String, String> sessConf) throws SQLException {
        this.transport = new TSocket(host, port);
        if (!sessConf.containsKey(HIVE_AUTH_TYPE) || !sessConf.get(HIVE_AUTH_TYPE).equals(HIVE_AUTH_SIMPLE)) {
            try {
                if (sessConf.containsKey(HIVE_AUTH_PRINCIPAL)) {
                    this.transport = KerberosSaslHelper.getKerberosTransport((String)sessConf.get(HIVE_AUTH_PRINCIPAL), (String)host, (TTransport)this.transport);
                } else {
                    String passwd;
                    String userName = sessConf.get(HIVE_AUTH_USER);
                    if (userName == null || userName.isEmpty()) {
                        userName = "anonymous";
                    }
                    if ((passwd = sessConf.get(HIVE_AUTH_PASSWD)) == null || passwd.isEmpty()) {
                        passwd = "anonymous";
                    }
                    this.transport = PlainSaslHelper.getPlainTransport((String)userName, (String)passwd, (TTransport)this.transport);
                }
            }
            catch (SaslException e) {
                throw new SQLException("Could not establish secure connection to " + uri + ": " + e.getMessage(), " 08S01");
            }
        }
        TBinaryProtocol protocol = new TBinaryProtocol(this.transport);
        this.client = new TCLIService.Client((TProtocol)protocol);
        try {
            this.transport.open();
        }
        catch (TTransportException e) {
            e.printStackTrace();
            throw new SQLException("Could not establish connection to " + uri + ": " + e.getMessage(), " 08S01");
        }
    }

    private void openSession(String uri) throws SQLException {
        TOpenSessionReq openReq = new TOpenSessionReq();
        try {
            TOpenSessionResp openResp = this.client.OpenSession(openReq);
            Utils.verifySuccess(openResp.getStatus());
            if (!this.supportedProtocols.contains(openResp.getServerProtocolVersion())) {
                throw new TException("Unsupported Hive2 protocol");
            }
            this.sessHandle = openResp.getSessionHandle();
        }
        catch (TException e) {
            throw new SQLException("Could not establish connection to " + uri + ": " + e.getMessage(), " 08S01");
        }
        this.isClosed = false;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.warningChain = null;
    }

    @Override
    public void close() throws SQLException {
        if (!this.isClosed) {
            TCloseSessionReq closeReq = new TCloseSessionReq(this.sessHandle);
            try {
                this.client.CloseSession(closeReq);
            }
            catch (TException e) {
                throw new SQLException("Error while cleaning up the server resources", e);
            }
            finally {
                this.isClosed = true;
                if (this.transport != null) {
                    this.transport.close();
                }
            }
        }
    }

    @Override
    public void commit() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public Array createArrayOf(String arg0, Object[] arg1) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public Clob createClob() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public Statement createStatement() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Can't create Statement, connection is closed");
        }
        return new HiveStatement(this.client, this.sessHandle);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Can't create Statement, connection is closed ");
        }
        if (resultSetType != 1003) {
            throw new SQLException("Invalid parameter to createStatement() only TYPE_FORWARD_ONLY is supported");
        }
        if (resultSetConcurrency != 1007) {
            throw new SQLException("Invalid parameter to createStatement() only CONCUR_READ_ONLY is supported");
        }
        return this.createStatement();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLException("Method not supported - createStatement(int, int, int");
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return true;
    }

    @Override
    public String getCatalog() throws SQLException {
        return "";
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int getHoldability() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return new HiveDatabaseMetaData(this.client, this.sessHandle);
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return 0;
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.warningChain;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return false;
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return new HivePreparedStatement(this.client, this.sessHandle, sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return new HivePreparedStatement(this.client, this.sessHandle, sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return new HivePreparedStatement(this.client, this.sessHandle, sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void rollback() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        if (autoCommit) {
            throw new SQLException("enabling autocommit is not supported");
        }
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        throw new SQLClientInfoException("Method not supported", null);
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        throw new SQLClientInfoException("Method not supported", null);
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        if (!readOnly) {
            throw new SQLException("Method not supported - setReadOnly(false)");
        }
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public String getSchema() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        throw new SQLException("Method not supported");
    }
}

