/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.jdbc;

import java.net.URI;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hive.service.cli.thrift.TStatus;
import org.apache.hive.service.cli.thrift.TStatusCode;

public class Utils {
    public static final String URL_PREFIX = "jdbc:hive2://";
    public static final String DEFAULT_PORT = "10000";
    public static final String DEFAULT_DATABASE = "default";
    private static final String URI_JDBC_PREFIX = "jdbc:";

    public static int hiveTypeToSqlType(String type) throws SQLException {
        if ("string".equalsIgnoreCase(type)) {
            return 12;
        }
        if ("float".equalsIgnoreCase(type)) {
            return 6;
        }
        if ("double".equalsIgnoreCase(type)) {
            return 8;
        }
        if ("bool".equalsIgnoreCase(type) || "boolean".equalsIgnoreCase(type)) {
            return 16;
        }
        if ("byte".equalsIgnoreCase(type) || "tinyint".equalsIgnoreCase(type)) {
            return -6;
        }
        if ("smallint".equalsIgnoreCase(type)) {
            return 5;
        }
        if ("i32".equalsIgnoreCase(type) || "int".equalsIgnoreCase(type)) {
            return 4;
        }
        if ("i64".equalsIgnoreCase(type) || "bigint".equalsIgnoreCase(type)) {
            return -5;
        }
        if ("timestamp".equalsIgnoreCase(type)) {
            return 93;
        }
        if ("decimal".equalsIgnoreCase(type)) {
            return 3;
        }
        if (type.startsWith("map<")) {
            return 12;
        }
        if (type.startsWith("array<")) {
            return 12;
        }
        if (type.startsWith("struct<")) {
            return 12;
        }
        throw new SQLException("Unrecognized column type: " + type);
    }

    public static void verifySuccessWithInfo(TStatus status) throws SQLException {
        Utils.verifySuccess(status, true);
    }

    public static void verifySuccess(TStatus status) throws SQLException {
        Utils.verifySuccess(status, false);
    }

    public static void verifySuccess(TStatus status, boolean withInfo) throws SQLException {
        if (status.getStatusCode() != TStatusCode.SUCCESS_STATUS && withInfo && status.getStatusCode() != TStatusCode.SUCCESS_WITH_INFO_STATUS) {
            throw new SQLException(status.getErrorMessage(), status.getSqlState(), status.getErrorCode());
        }
    }

    public static JdbcConnectionParams parseURL(String uri) throws IllegalArgumentException {
        String varStr;
        JdbcConnectionParams connParams = new JdbcConnectionParams();
        if (!uri.startsWith(URL_PREFIX)) {
            throw new IllegalArgumentException("Bad URL format");
        }
        if (uri.equalsIgnoreCase(URL_PREFIX)) {
            connParams.setEmbeddedMode(true);
            return connParams;
        }
        URI jdbcURI = URI.create(uri.substring(URI_JDBC_PREFIX.length()));
        connParams.setHost(jdbcURI.getHost());
        if (connParams.getHost() == null) {
            connParams.setEmbeddedMode(true);
        } else {
            int port = jdbcURI.getPort();
            if (port == -1) {
                port = Integer.valueOf(DEFAULT_PORT);
            }
            connParams.setPort(port);
        }
        Pattern pattern = Pattern.compile("([^;]*)=([^;]*)[;]?");
        String sessVars = jdbcURI.getPath();
        if (sessVars == null || sessVars.isEmpty()) {
            connParams.setDbName(DEFAULT_DATABASE);
        } else if (!(sessVars = sessVars.substring(1)).contains(";")) {
            connParams.setDbName(sessVars);
        } else {
            connParams.setDbName(sessVars.substring(0, sessVars.indexOf(59)));
            sessVars = sessVars.substring(sessVars.indexOf(59) + 1);
            if (sessVars != null) {
                Matcher sessMatcher = pattern.matcher(sessVars);
                while (sessMatcher.find()) {
                    connParams.getSessionVars().put(sessMatcher.group(1), sessMatcher.group(2));
                }
            }
        }
        String confStr = jdbcURI.getQuery();
        if (confStr != null) {
            Matcher confMatcher = pattern.matcher(confStr);
            while (confMatcher.find()) {
                connParams.getHiveConfs().put(confMatcher.group(1), confMatcher.group(2));
            }
        }
        if ((varStr = jdbcURI.getFragment()) != null) {
            Matcher varMatcher = pattern.matcher(varStr);
            while (varMatcher.find()) {
                connParams.getHiveVars().put(varMatcher.group(1), varMatcher.group(2));
            }
        }
        return connParams;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class JdbcConnectionParams {
        private String host = null;
        private int port;
        private String dbName = "default";
        private Map<String, String> hiveConfs = new HashMap<String, String>();
        private Map<String, String> hiveVars = new HashMap<String, String>();
        private Map<String, String> sessionVars = new HashMap<String, String>();
        private boolean isEmbeddedMode = false;

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }

        public String getDbName() {
            return this.dbName;
        }

        public Map<String, String> getHiveConfs() {
            return this.hiveConfs;
        }

        public Map<String, String> getHiveVars() {
            return this.hiveVars;
        }

        public boolean isEmbeddedMode() {
            return this.isEmbeddedMode;
        }

        public Map<String, String> getSessionVars() {
            return this.sessionVars;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public void setPort(int port) {
            this.port = port;
        }

        public void setDbName(String dbName) {
            this.dbName = dbName;
        }

        public void setHiveConfs(Map<String, String> hiveConfs) {
            this.hiveConfs = hiveConfs;
        }

        public void setHiveVars(Map<String, String> hiveVars) {
            this.hiveVars = hiveVars;
        }

        public void setEmbeddedMode(boolean embeddedMode) {
            this.isEmbeddedMode = embeddedMode;
        }

        public void setSessionVars(Map<String, String> sessionVars) {
            this.sessionVars = sessionVars;
        }
    }
}

