/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.jdbc.KettleDriver;
import org.pentaho.di.jdbc.Support;

public final class CharsetInfo {
    private static Class<?> PKG = KettleDriver.class;
    private static final transient Log log = LogFactory.getLog(CharsetInfo.class);
    private static final String CHARSETS_RESOURCE_NAME = "org/pentaho/di/jdbc/Charsets.properties";
    private static final HashMap<String, CharsetInfo> charsets = new HashMap();
    private static final HashMap<Integer, CharsetInfo> lcidToCharsetMap = new HashMap();
    private static final CharsetInfo[] sortToCharsetMap = new CharsetInfo[256];
    private final String charset;
    private final boolean wideChars;

    public static CharsetInfo getCharset(String serverCharset) {
        return charsets.get(serverCharset.toUpperCase());
    }

    public static CharsetInfo getCharsetForLCID(int lcid) {
        return lcidToCharsetMap.get(new Integer(lcid));
    }

    public static CharsetInfo getCharsetForSortOrder(int sortOrder) {
        return sortToCharsetMap[sortOrder];
    }

    public static CharsetInfo getCharset(byte[] collation) throws SQLException {
        CharsetInfo charset = collation[4] != 0 ? CharsetInfo.getCharsetForSortOrder(collation[4] & 0xFF) : CharsetInfo.getCharsetForLCID((collation[2] & 0xF) << 16 | (collation[1] & 0xFF) << 8 | collation[0] & 0xFF);
        if (charset == null) {
            throw new SQLException(BaseMessages.getString(PKG, (String)"error.charset.nocollation", (String[])new String[]{Support.toHex(collation)}), "2C000");
        }
        return charset;
    }

    public CharsetInfo(String descriptor) {
        this.wideChars = !"1".equals(descriptor.substring(0, 1));
        this.charset = descriptor.substring(2);
    }

    public String getCharset() {
        return this.charset;
    }

    public boolean isWideChars() {
        return this.wideChars;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CharsetInfo)) {
            return false;
        }
        CharsetInfo charsetInfo = (CharsetInfo)o;
        return this.charset.equals(charsetInfo.charset);
    }

    public int hashCode() {
        return this.charset.hashCode();
    }

    public String toString() {
        return this.charset;
    }

    static {
        try {
            InputStream stream = null;
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader != null) {
                stream = classLoader.getResourceAsStream(CHARSETS_RESOURCE_NAME);
            }
            if (stream == null) {
                stream = (InputStream)AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        ClassLoader loader = CharsetInfo.class.getClassLoader();
                        if (loader == null) {
                            loader = ClassLoader.getSystemClassLoader();
                        }
                        return loader.getResourceAsStream(CharsetInfo.CHARSETS_RESOURCE_NAME);
                    }
                });
            }
            if (stream != null) {
                Properties tmp = new Properties();
                tmp.load(stream);
                HashMap instances = new HashMap();
                Enumeration<?> e = tmp.propertyNames();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    CharsetInfo value = new CharsetInfo(tmp.getProperty(key));
                    CharsetInfo prevInstance = (CharsetInfo)instances.get(value.getCharset());
                    if (prevInstance != null) {
                        if (prevInstance.isWideChars() != value.isWideChars()) {
                            throw new IllegalStateException("Inconsistent Charsets.properties");
                        }
                        value = prevInstance;
                    }
                    if (key.startsWith("LCID_")) {
                        Integer lcid = new Integer(key.substring(5));
                        lcidToCharsetMap.put(lcid, value);
                        continue;
                    }
                    if (key.startsWith("SORT_")) {
                        CharsetInfo.sortToCharsetMap[Integer.parseInt((String)key.substring((int)5))] = value;
                        continue;
                    }
                    charsets.put(key, value);
                }
            } else {
                log.error((Object)"Can't load Charsets.properties");
            }
        }
        catch (IOException e) {
            log.error((Object)e.getMessage());
        }
    }
}

