/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.jdbc;

import java.io.File;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.jdbc.ColInfo;
import org.pentaho.di.jdbc.ConnectionJDBC3;
import org.pentaho.di.jdbc.KettleHelper;
import org.pentaho.di.jdbc.KettleJDBCResultSet;
import org.pentaho.di.jdbc.URLParser;

public class JDBCKettleMetaData
implements DatabaseMetaData {
    private final transient Log log = LogFactory.getLog(JDBCKettleMetaData.class);
    ConnectionJDBC3 connectionJDBC3;
    String url;
    Map<String, String[]> stepsMap = null;
    boolean isDir = false;
    KettleHelper helper = null;

    public JDBCKettleMetaData(ConnectionJDBC3 connectionJDBC3, String url) {
        this.connectionJDBC3 = connectionJDBC3;
        this.url = url;
        String kettleurl = url.substring(url.indexOf("jdbc:kettle:") + "jdbc:kettle:".length());
        URLParser p = new URLParser();
        p.parse(kettleurl);
        this.helper = new KettleHelper();
        String fileUrl = p.getKettleUrl();
        if (fileUrl.indexOf("file://") != -1) {
            fileUrl = fileUrl.substring(fileUrl.indexOf("file://") + 7);
        } else if (fileUrl.indexOf("file:///") != -1) {
            fileUrl = fileUrl.substring(fileUrl.indexOf("file://") + 8);
        }
        File f = new File(fileUrl);
        if (f.isDirectory()) {
            this.stepsMap = this.helper.visitDirectory(f);
            this.isDir = true;
        } else {
            this.stepsMap = this.helper.getSteps(f);
        }
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        return false;
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        return false;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return false;
    }

    @Override
    public boolean deletesAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        return null;
    }

    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        this.log.debug((Object)"getBestRowIdentifier.....");
        return null;
    }

    @Override
    public String getCatalogSeparator() throws SQLException {
        return ".";
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        return "database";
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        ArrayList<RowMetaAndData> rowAndDatas = new ArrayList<RowMetaAndData>();
        if (!this.isDir) {
            RowMetaAndData rd = new RowMetaAndData();
            rd.addValue("TABLE_CAT", 2, (Object)"TABLE");
            rowAndDatas.add(rd);
            KettleJDBCResultSet rs = new KettleJDBCResultSet(null, rowAndDatas, "*");
            return rs;
        }
        Set<String> set = this.stepsMap.keySet();
        for (String name : set) {
            RowMetaAndData rd = new RowMetaAndData();
            rd.addValue("TABLE_CAT", 2, (Object)name);
            rowAndDatas.add(rd);
        }
        KettleJDBCResultSet rs = new KettleJDBCResultSet(null, rowAndDatas, "*");
        return rs;
    }

    @Override
    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        return null;
    }

    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        this.log.debug((Object)("catalog:" + catalog + " , schemaPattern:" + schemaPattern + " , tableNamePattern:" + tableNamePattern + " ,columnNamePattern:" + columnNamePattern));
        ArrayList<RowMetaAndData> rowAndDatas = new ArrayList<RowMetaAndData>();
        if (!this.isDir) {
            this.log.debug((Object)this.helper.getRowMeta(tableNamePattern));
            RowMeta rm = this.helper.getRowMeta(tableNamePattern);
            ColInfo[] colInfo = KettleHelper.convert(rm);
            String[] columns = rm.getFieldNames();
            for (int i = 0; columns != null && i < columns.length; ++i) {
                RowMetaAndData rd = new RowMetaAndData();
                rd.addValue("TABLE_CAT", 2, (Object)catalog);
                rd.addValue("TABLE_SCHEM", 2, (Object)schemaPattern);
                rd.addValue("TABLE_NAME", 2, (Object)tableNamePattern);
                rd.addValue("COLUMN_NAME", 2, (Object)columns[i]);
                rd.addValue("DATA_TYPE", 5, (Object)colInfo[i].jdbcType);
                rd.addValue("TYPE_NAME", 2, (Object)"");
                rd.addValue("COLUMN_SIZE", 5, (Object)columns.length);
                rd.addValue("BUFFER_LENGTH", 5, (Object)"20");
                rd.addValue("DECIMAL_DIGITS", 5, (Object)"20");
                rd.addValue("NUM_PREC_RADIX", 5, (Object)"20");
                rd.addValue("NULLABLE", 5, (Object)"20");
                rd.addValue("REMARKS", 2, (Object)"");
                rd.addValue("COLUMN_DEF", 2, (Object)"");
                rd.addValue("SQL_DATA_TYPE", 5, (Object)"20");
                rd.addValue("SQL_DATETIME_SUB", 5, (Object)"20");
                rd.addValue("CHAR_OCTET_LENGTH", 5, (Object)"1");
                rd.addValue("ORDINAL_POSITION", 5, (Object)"20");
                rd.addValue("IS_NULLABLE", 2, (Object)"0");
                rd.addValue("SCOPE_CATALOG", 2, (Object)"0");
                rd.addValue("SCOPE_SCHEMA", 2, (Object)"0");
                rd.addValue("SCOPE_TABLE", 2, (Object)"0");
                rd.addValue("SOURCE_DATA_TYPE", 5, (Object)"1");
                rowAndDatas.add(rd);
            }
            KettleJDBCResultSet rs = new KettleJDBCResultSet(null, rowAndDatas, "*");
            return rs;
        }
        RowMeta rm = this.helper.getRowMeta(tableNamePattern);
        ColInfo[] colInfo = KettleHelper.convert(rm);
        String[] columns = rm.getFieldNames();
        for (int i = 0; columns != null && i < columns.length; ++i) {
            String name = columns[i];
            RowMetaAndData rd = new RowMetaAndData();
            rd.addValue("TABLE_CAT", 2, (Object)catalog);
            rd.addValue("TABLE_SCHEM", 2, (Object)schemaPattern);
            rd.addValue("TABLE_NAME", 2, (Object)tableNamePattern);
            rd.addValue("COLUMN_NAME", 2, (Object)name);
            rd.addValue("DATA_TYPE", 5, (Object)colInfo[i].getJdbcType());
            rd.addValue("TYPE_NAME", 2, (Object)"");
            rd.addValue("COLUMN_SIZE", 5, (Object)columns.length);
            rd.addValue("BUFFER_LENGTH", 5, (Object)name);
            rd.addValue("DECIMAL_DIGITS", 5, (Object)"20");
            rd.addValue("NUM_PREC_RADIX", 5, (Object)"20");
            rd.addValue("NULLABLE", 5, (Object)"20");
            rd.addValue("REMARKS", 2, (Object)name);
            rd.addValue("COLUMN_DEF", 2, (Object)name);
            rd.addValue("SQL_DATA_TYPE", 5, (Object)"20");
            rd.addValue("SQL_DATETIME_SUB", 5, (Object)"20");
            rd.addValue("CHAR_OCTET_LENGTH", 5, (Object)"1");
            rd.addValue("ORDINAL_POSITION", 5, (Object)"20");
            rd.addValue("IS_NULLABLE", 2, (Object)"0");
            rd.addValue("SCOPE_CATALOG", 2, (Object)"0");
            rd.addValue("SCOPE_SCHEMA", 2, (Object)"0");
            rd.addValue("SCOPE_TABLE", 2, (Object)"0");
            rd.addValue("SOURCE_DATA_TYPE", 5, (Object)"1");
            rowAndDatas.add(rd);
        }
        KettleJDBCResultSet rs = new KettleJDBCResultSet(null, rowAndDatas, "*");
        return rs;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connectionJDBC3;
    }

    @Override
    public ResultSet getCrossReference(String primaryCatalog, String primarySchema, String primaryTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        return null;
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        return 0;
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        return 0;
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        return "Pentaho Data Integration";
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        return this.connectionJDBC3.getDatabaseProductVersion();
    }

    @Override
    public int getDefaultTransactionIsolation() throws SQLException {
        return 0;
    }

    @Override
    public int getDriverMajorVersion() {
        return 0;
    }

    @Override
    public int getDriverMinorVersion() {
        return 0;
    }

    @Override
    public String getDriverName() throws SQLException {
        return "jdbc for kettle";
    }

    @Override
    public String getDriverVersion() throws SQLException {
        return null;
    }

    @Override
    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        this.log.debug((Object)"getExportedKeys.........");
        ArrayList<RowMetaAndData> rowAndDatas = new ArrayList<RowMetaAndData>();
        RowMetaAndData rd = new RowMetaAndData();
        rd.addValue("PKTABLE_CAT", 2, (Object)catalog);
        rd.addValue("PKTABLE_SCHEM", 2, (Object)schema);
        rd.addValue("PKTABLE_NAME", 2, (Object)table);
        rd.addValue("PKCOLUMN_NAME", 2, (Object)"");
        rd.addValue("FKTABLE_CAT", 2, (Object)"");
        rd.addValue("FKTABLE_SCHEM", 2, (Object)"");
        rd.addValue("FKTABLE_NAME", 2, (Object)"");
        rd.addValue("FKCOLUMN_NAME", 2, (Object)"");
        rd.addValue("KEY_SEQ", 5, (Object)"1");
        rd.addValue("UPDATE_RULE", 5, (Object)"1");
        rd.addValue("DELETE_RULE", 5, (Object)"1");
        rd.addValue("FK_NAME", 2, (Object)"");
        rd.addValue("PK_NAME", 2, (Object)"");
        rd.addValue("DEFERRABILITY", 2, (Object)"");
        rowAndDatas.add(rd);
        KettleJDBCResultSet rs = new KettleJDBCResultSet(null, rowAndDatas, "*");
        return rs;
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        return null;
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        return "\"";
    }

    @Override
    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        this.log.debug((Object)"getImportedKeys.........");
        ArrayList<RowMetaAndData> rowAndDatas = new ArrayList<RowMetaAndData>();
        RowMetaAndData rd = new RowMetaAndData();
        rd.addValue("PKTABLE_CAT", 2, (Object)catalog);
        rd.addValue("PKTABLE_SCHEM", 2, (Object)schema);
        rd.addValue("PKTABLE_NAME", 2, (Object)table);
        rd.addValue("PKCOLUMN_NAME", 2, (Object)"");
        rd.addValue("FKTABLE_CAT", 2, (Object)"");
        rd.addValue("FKTABLE_SCHEM", 2, (Object)"");
        rd.addValue("FKTABLE_NAME", 2, (Object)"");
        rd.addValue("FKCOLUMN_NAME", 2, (Object)"");
        rd.addValue("KEY_SEQ", 5, (Object)"1");
        rd.addValue("UPDATE_RULE", 5, (Object)"1");
        rd.addValue("DELETE_RULE", 5, (Object)"1");
        rd.addValue("FK_NAME", 2, (Object)"");
        rd.addValue("PK_NAME", 2, (Object)"");
        rd.addValue("DEFERRABILITY", 2, (Object)"");
        rowAndDatas.add(rd);
        KettleJDBCResultSet rs = new KettleJDBCResultSet(null, rowAndDatas, "*");
        return rs;
    }

    @Override
    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        return new KettleJDBCResultSet(null, new ArrayList<RowMetaAndData>(), "*");
    }

    @Override
    public int getJDBCMajorVersion() throws SQLException {
        return 1;
    }

    @Override
    public int getJDBCMinorVersion() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxBinaryLiteralLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCharLiteralLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInGroupBy() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInIndex() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInOrderBy() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInSelect() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInTable() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxConnections() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCursorNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxIndexLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxRowSize() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxStatementLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxStatements() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxTableNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxTablesInSelect() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxUserNameLength() throws SQLException {
        return 0;
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        return null;
    }

    @Override
    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        this.log.debug((Object)"getPrimaryKeys........");
        ArrayList<RowMetaAndData> rowAndDatas = new ArrayList<RowMetaAndData>();
        RowMetaAndData rd = new RowMetaAndData();
        rd.addValue("TABLE_CAT", 2, (Object)catalog);
        rd.addValue("TABLE_SCHEM", 2, (Object)schema);
        rd.addValue("TABLE_NAME", 2, (Object)table);
        rd.addValue("COLUMN_NAME", 2, (Object)"");
        rd.addValue("KEY_SEQ", 5, (Object)"1");
        rd.addValue("PK_NAME", 2, (Object)"");
        rowAndDatas.add(rd);
        KettleJDBCResultSet rs = new KettleJDBCResultSet(null, rowAndDatas, "*");
        return rs;
    }

    @Override
    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        return null;
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        return null;
    }

    @Override
    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        return null;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 0;
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        return "";
    }

    @Override
    public int getSQLStateType() throws SQLException {
        return 0;
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        return "owner";
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        ArrayList<RowMetaAndData> rowAndDatas = new ArrayList<RowMetaAndData>();
        Set<String> set = this.stepsMap.keySet();
        for (String name : set) {
            RowMetaAndData rd = new RowMetaAndData();
            rd.addValue("TABLE_SCHEM", 2, (Object)name);
            rowAndDatas.add(rd);
        }
        KettleJDBCResultSet rs = new KettleJDBCResultSet(null, rowAndDatas, "*");
        return rs;
    }

    @Override
    public String getSearchStringEscape() throws SQLException {
        return null;
    }

    @Override
    public String getStringFunctions() throws SQLException {
        return null;
    }

    @Override
    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        return null;
    }

    @Override
    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        return null;
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        return null;
    }

    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        return null;
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        ArrayList<RowMetaAndData> rowAndDatas = new ArrayList<RowMetaAndData>();
        RowMetaAndData rd = new RowMetaAndData();
        rd.addValue("TABLE_TYPE", 2, (Object)"TABLE");
        rowAndDatas.add(rd);
        KettleJDBCResultSet rs = new KettleJDBCResultSet(null, rowAndDatas, "*");
        return rs;
    }

    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        Set<Map.Entry<String, String[]>> tables;
        ArrayList<RowMetaAndData> rowAndDatas = new ArrayList<RowMetaAndData>();
        this.log.debug((Object)("catalog:" + catalog + " , schemaPattern:" + schemaPattern + " , tableNamePattern:" + tableNamePattern));
        if (!this.isDir) {
            tables = this.stepsMap.entrySet();
            this.log.debug((Object)("tables:" + tables));
            for (Map.Entry<String, String[]> o : tables) {
                String[] values = o.getValue();
                for (int i = 0; i < values.length; ++i) {
                    RowMetaAndData rd = new RowMetaAndData();
                    rd.addValue("TABLE_CAT", 2, (Object)"jdbckettle");
                    rd.addValue("TABLE_SCHEM", 2, (Object)"jdbckettle");
                    rd.addValue("TABLE_NAME", 2, (Object)values[i]);
                    rd.addValue("TABLE_TYPE", 2, (Object)"TABLE");
                    rd.addValue("REMARKS", 2, (Object)"");
                    rd.addValue("TYPE_CAT", 2, (Object)"TABLE");
                    rd.addValue("TYPE_SCHEM", 2, (Object)"TABLE");
                    rd.addValue("TYPE_NAME", 2, (Object)"TABLE");
                    rd.addValue("SELF_REFERENCING_COL_NAME", 2, (Object)"");
                    rd.addValue("REF_GENERATION", 2, (Object)"");
                    rowAndDatas.add(rd);
                }
            }
        } else {
            tables = this.stepsMap.entrySet();
            boolean isBirtSchema = this.stepsMap.keySet().contains(schemaPattern);
            for (Map.Entry<String, String[]> o : tables) {
                String schema = o.getKey();
                if (!schema.equals(schemaPattern) && isBirtSchema) continue;
                String[] values = o.getValue();
                for (int i = 0; i < values.length; ++i) {
                    RowMetaAndData rd = new RowMetaAndData();
                    rd.addValue("TABLE_CAT", 2, (Object)"jdbckettle");
                    rd.addValue("TABLE_SCHEM", 2, (Object)"jdbckettle");
                    rd.addValue("TABLE_NAME", 2, (Object)values[i]);
                    rd.addValue("TABLE_TYPE", 2, (Object)"TABLE");
                    rd.addValue("REMARKS", 2, (Object)"");
                    rd.addValue("TYPE_CAT", 2, (Object)"TABLE");
                    rd.addValue("TYPE_SCHEM", 2, (Object)"TABLE");
                    rd.addValue("TYPE_NAME", 2, (Object)"TABLE");
                    rd.addValue("SELF_REFERENCING_COL_NAME", 2, (Object)"");
                    rd.addValue("REF_GENERATION", 2, (Object)"");
                    rowAndDatas.add(rd);
                }
            }
        }
        KettleJDBCResultSet rs = new KettleJDBCResultSet(null, rowAndDatas, "*");
        return rs;
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        return null;
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        return null;
    }

    @Override
    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        return null;
    }

    @Override
    public String getURL() throws SQLException {
        return this.connectionJDBC3.getURL();
    }

    @Override
    public String getUserName() throws SQLException {
        return null;
    }

    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        return null;
    }

    @Override
    public boolean insertsAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        return false;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return true;
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        return false;
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        return false;
    }

    @Override
    public boolean othersDeletesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean othersInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean ownDeletesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean ownInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsGetGeneratedKeys() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMultipleOpenResults() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsNamedParameters() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOuterJoins() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsResultSetType(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSavepoints() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsStatementPooling() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsUnion() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsUnionAll() throws SQLException {
        return false;
    }

    @Override
    public boolean updatesAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        return false;
    }

    @Override
    public boolean usesLocalFiles() throws SQLException {
        return false;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        return null;
    }

    @Override
    public ResultSet getFunctionColumns(String arg0, String arg1, String arg2, String arg3) throws SQLException {
        return null;
    }

    @Override
    public ResultSet getFunctions(String arg0, String arg1, String arg2) throws SQLException {
        return null;
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        return null;
    }

    @Override
    public ResultSet getSchemas(String arg0, String arg1) throws SQLException {
        return null;
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        throw new SQLException("Pseudo Columns are not supported");
    }

    @Override
    public boolean generatedKeyAlwaysReturned() throws SQLException {
        return false;
    }
}

