/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.jdbc;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.jdbc.ConnectionJDBC3;
import org.pentaho.di.jdbc.DefaultProperties;

public class KettleDriver
implements Driver {
    private static Class<?> PKG = KettleDriver.class;
    public static final String driverPrefix = "jdbc:kettle:";
    public static final boolean JDBC3 = "1.4".compareTo(System.getProperty("java.specification.version")) <= 0;
    private static final transient Log log = LogFactory.getLog(KettleDriver.class);

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        if (url == null) {
            return false;
        }
        return url.toLowerCase().startsWith(driverPrefix);
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        if (url == null || !url.toLowerCase().startsWith(driverPrefix)) {
            return null;
        }
        Properties props = this.setupConnectProperties(url, info);
        if (JDBC3) {
            return new ConnectionJDBC3(url, props);
        }
        return null;
    }

    private Properties setupConnectProperties(String url, Properties info) throws SQLException {
        Properties props = this.parseURL(url, info);
        if (props == null) {
            throw new SQLException(BaseMessages.getString(PKG, (String)"error.driver.badurl", (String[])new String[]{url}), "08001");
        }
        if (props.getProperty("LOGINTIMEOUT") == null) {
            props.setProperty("LOGINTIMEOUT", Integer.toString(DriverManager.getLoginTimeout()));
        }
        props = DefaultProperties.addDefaultProperties(props);
        return props;
    }

    public Properties parseURL(String url, Properties info) {
        if (info == null) {
            return null;
        }
        Properties p = new Properties();
        log.debug((Object)("url=" + url));
        return p;
    }

    @Override
    public int getMajorVersion() {
        return 1;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        log.debug((Object)".............getPropertyInfo is called!................");
        return null;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    public String toString() {
        return "JDBCKettle " + this.getVersion();
    }

    public String getVersion() {
        return this.getMajorVersion() + "." + this.getMinorVersion();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }

    static {
        try {
            DriverManager.registerDriver(new KettleDriver());
            log.debug((Object)"------JDBCKettleDriver is registered!-----");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

