/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.jdbc;

import java.io.File;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.vfs.FileObject;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.jdbc.ColInfo;
import org.pentaho.di.jdbc.Sanitizer;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepMeta;

public class KettleHelper {
    private Map<String, RowMetaInterface> rowMetaMap = new Hashtable<String, RowMetaInterface>();

    public KettleHelper() {
        this.init();
    }

    private void init() {
        try {
            KettleEnvironment.init();
        }
        catch (KettleException e) {
            throw new RuntimeException("Unable to initialize Kettle", e);
        }
    }

    public static ColInfo[] convert(RowMeta rm, String columnStr) {
        StringTokenizer st = new StringTokenizer(columnStr, ",");
        ColInfo[] r = new ColInfo[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            ColInfo c = new ColInfo();
            String tmpStr = st.nextToken();
            int index = tmpStr.indexOf("as");
            if (index != -1) {
                String name = tmpStr.substring(index + 2);
                String realName = tmpStr.substring(0, index);
                int kindex = (realName = realName.trim()).lastIndexOf(".");
                if (kindex != -1) {
                    realName = realName.substring(kindex + 1);
                }
                name = name.trim();
                c.setRealName(Sanitizer.doFilter(name));
                c.setName(Sanitizer.doFilter(name));
                ValueMetaInterface v = rm.searchValueMeta(realName);
                c.setJdbcType(KettleHelper.translateType(v.getType()));
            } else {
                ValueMetaInterface v;
                int kindex = (tmpStr = tmpStr.trim()).lastIndexOf(".");
                if (kindex != -1) {
                    tmpStr = tmpStr.substring(kindex + 1);
                }
                if ((v = rm.searchValueMeta(tmpStr)) != null) {
                    c.setJdbcType(KettleHelper.translateType(v.getType()));
                }
                c.setRealName(Sanitizer.doFilter(tmpStr));
                c.setName(Sanitizer.doFilter(tmpStr));
            }
            r[i] = c;
            ++i;
        }
        return r;
    }

    public static ColInfo[] convert(RowMeta rm) {
        ColInfo[] cols = new ColInfo[rm.size()];
        for (int i = 0; i < cols.length; ++i) {
            cols[i] = new ColInfo();
            ValueMetaInterface v = (ValueMetaInterface)rm.getValueMetaList().get(i);
            cols[i].setRealName(Sanitizer.doFilter(v.getName()));
            cols[i].setJdbcType(KettleHelper.translateType(v.getType()));
        }
        return cols;
    }

    public Map<String, String[]> visitDirectory(File f) {
        HashMap<String, String[]> stepsMap = new HashMap<String, String[]>();
        File[] files = f.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                try {
                    if (files[i].getName().lastIndexOf("ktr") == -1) continue;
                    TransMeta tm = new TransMeta(files[i].getAbsolutePath());
                    String name = files[i].getName();
                    name = name.substring(0, name.length() - 4);
                    stepsMap.put(name, tm.getStepNames());
                    StepMeta[] retval = tm.getStepsArray();
                    for (int j = 0; j < retval.length; ++j) {
                        StepMeta s = retval[j];
                        String sname = s.getName();
                        RowMetaInterface ri = tm.getStepFields(sname);
                        this.rowMetaMap.put(sname, ri);
                    }
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return stepsMap;
    }

    public Map<String, String[]> getSteps(File f) {
        HashMap<String, String[]> stepsMap = new HashMap<String, String[]>();
        try {
            if (f.getName().lastIndexOf("ktr") != -1) {
                TransMeta tm = new TransMeta(f.getAbsolutePath());
                String name = f.getName();
                name = name.substring(0, name.length() - 4);
                stepsMap.put(name, tm.getStepNames());
                StepMeta[] retval = tm.getStepsArray();
                for (int j = 0; j < retval.length; ++j) {
                    StepMeta s = retval[j];
                    String sname = s.getName();
                    RowMetaInterface ri = tm.getStepFields(sname);
                    this.rowMetaMap.put(sname, ri);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return stepsMap;
    }

    RowMeta getRowMeta(String stepName) {
        RowMeta rm = null;
        RowMetaInterface obj = this.rowMetaMap.get(stepName);
        if (obj != null) {
            rm = (RowMeta)obj;
        }
        return rm;
    }

    public static void main(String[] args) throws Exception {
        String s = "examplecsv.Sort rows by Year.Year as Year2,     examplecsv.Sort rows by Year.PresentsRequested,  examplecsv.Sort rows by Year.PresentsNickReceived";
        StringTokenizer st = new StringTokenizer(s, ",");
        System.out.println(st.countTokens());
        KettleHelper.parse();
    }

    private static void parse() throws Exception {
        String vfsFilename = "file://E:\\project\\kettlejdbc-google\\trunk\\samples\\simple.ktr";
        XMLHandler.loadXMLFile((FileObject)KettleVFS.getFileObject((String)vfsFilename));
    }

    private static int translateType(int kettleType) {
        switch (kettleType) {
            case 6: {
                return 2;
            }
            case 8: {
                return -2;
            }
            case 4: {
                return 16;
            }
            case 3: {
                return 93;
            }
            case 5: {
                return 4;
            }
            case 0: {
                return 2000;
            }
            case 1: {
                return 2;
            }
            case 7: {
                return -1;
            }
            case 2: {
                return 12;
            }
        }
        return 1111;
    }
}

