/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.jdbc.ColInfo;
import org.pentaho.di.jdbc.DateTime;
import org.pentaho.di.jdbc.KettleDriver;
import org.pentaho.di.jdbc.KettleJDBCResultSetMetaData;
import org.pentaho.di.jdbc.Support;
import org.pentaho.di.jdbc.UniqueIdentifier;

public class KettleJDBCResultSet
implements ResultSet {
    private static Class<?> PKG = KettleDriver.class;
    private List<RowMetaAndData> rowAndDatas;
    protected int columnCount;
    protected int rowPtr = 0;
    private Object[] currentRow;
    protected ColInfo[] columns;
    String columnStr;
    private HashMap<String, Integer> columnMap;
    private Statement statement;
    private final transient Log log = LogFactory.getLog(KettleJDBCResultSet.class);
    protected static final int POS_BEFORE_FIRST = 0;
    protected static final int POS_AFTER_LAST = -1;

    public KettleJDBCResultSet() {
    }

    public KettleJDBCResultSet(Statement statement, List<RowMetaAndData> rowAndDatas, String columnStr) {
        this.log.debug((Object)("KettleJDBCResultSet:" + rowAndDatas));
        this.statement = statement;
        this.rowAndDatas = rowAndDatas;
        this.columnStr = columnStr;
        if (this.rowAndDatas != null && this.rowAndDatas.size() > 0) {
            this.columnCount = this.rowAndDatas.get(0).getRowMeta().size();
        }
        int counter = 0;
        if (this.rowAndDatas != null) {
            counter = this.rowAndDatas.size();
        }
        this.log.debug((Object)("row counter=" + counter));
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        this.rowPtr = row;
        this.currentRow = this.rowAndDatas.get(this.rowPtr - 1).getData();
        return true;
    }

    @Override
    public void afterLast() throws SQLException {
        this.rowPtr = this.rowAndDatas.size() + 1;
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.rowPtr = 0;
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public void close() throws SQLException {
    }

    @Override
    public void deleteRow() throws SQLException {
    }

    @Override
    public int findColumn(String columnName) throws SQLException {
        KettleJDBCResultSetMetaData rm = (KettleJDBCResultSetMetaData)this.getMetaData();
        this.columns = rm.getColumns();
        if (this.columnMap == null) {
            this.columnMap = new HashMap(this.columnCount);
        } else {
            Integer pos = this.columnMap.get(columnName);
            if (pos != null) {
                return pos;
            }
        }
        for (int i = 0; i < this.columnCount; ++i) {
            if (!this.columns[i].realName.equalsIgnoreCase(columnName)) continue;
            this.columnMap.put(columnName, new Integer(i + 1));
            return i + 1;
        }
        throw new SQLException(BaseMessages.getString(PKG, (String)"error.resultset.colname", (String[])new String[]{columnName}), "07009");
    }

    @Override
    public boolean first() throws SQLException {
        return false;
    }

    @Override
    public Array getArray(int i) throws SQLException {
        return null;
    }

    @Override
    public Array getArray(String colName) throws SQLException {
        return null;
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public InputStream getAsciiStream(String columnName) throws SQLException {
        return null;
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        return (BigDecimal)Support.convert(this, this.getColumn(columnIndex), 3, null);
    }

    @Override
    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName));
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        return null;
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        return null;
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public InputStream getBinaryStream(String columnName) throws SQLException {
        return null;
    }

    @Override
    public Blob getBlob(int i) throws SQLException {
        return (Blob)Support.convert(this, this.getColumn(i), 2004, null);
    }

    @Override
    public Blob getBlob(String colName) throws SQLException {
        return this.getBlob(this.findColumn(colName));
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        return false;
    }

    @Override
    public boolean getBoolean(String columnName) throws SQLException {
        return false;
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        return 0;
    }

    @Override
    public byte getByte(String columnName) throws SQLException {
        return 0;
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public byte[] getBytes(String columnName) throws SQLException {
        return null;
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public Reader getCharacterStream(String columnName) throws SQLException {
        return null;
    }

    @Override
    public Clob getClob(int i) throws SQLException {
        return null;
    }

    @Override
    public Clob getClob(String colName) throws SQLException {
        return null;
    }

    @Override
    public int getConcurrency() throws SQLException {
        return 0;
    }

    @Override
    public String getCursorName() throws SQLException {
        return null;
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public Date getDate(String columnName) throws SQLException {
        return null;
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        return null;
    }

    @Override
    public Date getDate(String columnName, Calendar cal) throws SQLException {
        return null;
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        return (Double)Support.convert(this, this.getColumn(columnIndex), 8, null);
    }

    @Override
    public double getDouble(String columnName) throws SQLException {
        return this.getDouble(this.findColumn(columnName));
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 0;
    }

    @Override
    public int getFetchSize() throws SQLException {
        return 0;
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        return ((Float)Support.convert(this, this.getColumn(columnIndex), 7, null)).floatValue();
    }

    @Override
    public float getFloat(String columnName) throws SQLException {
        return this.getFloat(this.findColumn(columnName));
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        return (Integer)Support.convert(this, this.getColumn(columnIndex), 4, null);
    }

    @Override
    public int getInt(String columnName) throws SQLException {
        return this.getInt(this.findColumn(columnName));
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        return (Long)Support.convert(this, this.getColumn(columnIndex), -5, null);
    }

    @Override
    public long getLong(String columnName) throws SQLException {
        return this.getLong(this.findColumn(columnName));
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.log.debug((Object)"getMetaData");
        KettleJDBCResultSetMetaData rsMeta = new KettleJDBCResultSetMetaData(this.rowAndDatas, this.columnStr);
        return rsMeta;
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        Object value = this.getColumn(columnIndex);
        if (value instanceof UniqueIdentifier) {
            return value.toString();
        }
        if (value instanceof DateTime) {
            return ((DateTime)value).toObject();
        }
        return value;
    }

    protected Object getColumn(int index) throws SQLException {
        if (index < 1 || index > this.columnCount) {
            throw new SQLException(BaseMessages.getString(PKG, (String)"error.resultset.colindex", (String[])new String[]{Integer.toString(index)}), "07009");
        }
        if (this.currentRow == null) {
            throw new SQLException(BaseMessages.getString(PKG, (String)"error.resultset.norow", (String[])new String[0]), "24000");
        }
        Object data = this.currentRow[index - 1];
        return data;
    }

    @Override
    public Object getObject(String columnName) throws SQLException {
        return this.getObject(this.findColumn(columnName));
    }

    @Override
    public Object getObject(int i, Map<String, Class<?>> map) throws SQLException {
        return null;
    }

    @Override
    public Object getObject(String colName, Map<String, Class<?>> map) throws SQLException {
        return null;
    }

    @Override
    public Ref getRef(int i) throws SQLException {
        return null;
    }

    @Override
    public Ref getRef(String colName) throws SQLException {
        return null;
    }

    @Override
    public int getRow() throws SQLException {
        return this.rowPtr > 0 ? this.rowPtr : 0;
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        return ((Integer)Support.convert(this, this.getColumn(columnIndex), 5, null)).shortValue();
    }

    @Override
    public short getShort(String columnName) throws SQLException {
        return this.getShort(this.findColumn(columnName));
    }

    @Override
    public Statement getStatement() throws SQLException {
        return this.statement;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        Object tmp = this.getColumn(columnIndex);
        if (tmp instanceof String) {
            return (String)tmp;
        }
        return (String)Support.convert(this, tmp, 12, "ISO-8859-1");
    }

    @Override
    public String getString(String columnName) throws SQLException {
        return this.getString(this.findColumn(columnName));
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public Time getTime(String columnName) throws SQLException {
        return null;
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        return null;
    }

    @Override
    public Time getTime(String columnName, Calendar cal) throws SQLException {
        return null;
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public Timestamp getTimestamp(String columnName) throws SQLException {
        return null;
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        return null;
    }

    @Override
    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        return null;
    }

    @Override
    public int getType() throws SQLException {
        return 1003;
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public URL getURL(String columnName) throws SQLException {
        return null;
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(String columnName) throws SQLException {
        return null;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void insertRow() throws SQLException {
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return false;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return false;
    }

    @Override
    public boolean isFirst() throws SQLException {
        return this.rowPtr == 1;
    }

    @Override
    public boolean isLast() throws SQLException {
        return false;
    }

    @Override
    public boolean last() throws SQLException {
        this.rowPtr = this.rowAndDatas.size();
        return true;
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
    }

    @Override
    public void moveToInsertRow() throws SQLException {
    }

    @Override
    public boolean next() throws SQLException {
        this.log.debug((Object)"next.....");
        if (this.rowPtr < this.rowAndDatas.size()) {
            this.currentRow = this.rowAndDatas.get(this.rowPtr).getData();
            ++this.rowPtr;
            return true;
        }
        return false;
    }

    @Override
    public boolean previous() throws SQLException {
        return false;
    }

    @Override
    public void refreshRow() throws SQLException {
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        return false;
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        return false;
    }

    @Override
    public boolean rowInserted() throws SQLException {
        return false;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        return false;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
    }

    @Override
    public void updateArray(String columnName, Array x) throws SQLException {
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
    }

    @Override
    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
    }

    @Override
    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
    }

    @Override
    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
    }

    @Override
    public void updateBlob(String columnName, Blob x) throws SQLException {
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
    }

    @Override
    public void updateBoolean(String columnName, boolean x) throws SQLException {
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
    }

    @Override
    public void updateByte(String columnName, byte x) throws SQLException {
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
    }

    @Override
    public void updateBytes(String columnName, byte[] x) throws SQLException {
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
    }

    @Override
    public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
    }

    @Override
    public void updateClob(String columnName, Clob x) throws SQLException {
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
    }

    @Override
    public void updateDate(String columnName, Date x) throws SQLException {
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
    }

    @Override
    public void updateDouble(String columnName, double x) throws SQLException {
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
    }

    @Override
    public void updateFloat(String columnName, float x) throws SQLException {
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
    }

    @Override
    public void updateInt(String columnName, int x) throws SQLException {
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
    }

    @Override
    public void updateLong(String columnName, long x) throws SQLException {
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
    }

    @Override
    public void updateNull(String columnName) throws SQLException {
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
    }

    @Override
    public void updateObject(String columnName, Object x) throws SQLException {
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
    }

    @Override
    public void updateObject(String columnName, Object x, int scale) throws SQLException {
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
    }

    @Override
    public void updateRef(String columnName, Ref x) throws SQLException {
    }

    @Override
    public void updateRow() throws SQLException {
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
    }

    @Override
    public void updateShort(String columnName, short x) throws SQLException {
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
    }

    @Override
    public void updateString(String columnName, String x) throws SQLException {
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
    }

    @Override
    public void updateTime(String columnName, Time x) throws SQLException {
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
    }

    @Override
    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
    }

    @Override
    public boolean wasNull() throws SQLException {
        return false;
    }

    public int getRowCount() throws SQLException {
        int counter = -1;
        if (this.rowAndDatas != null) {
            counter = this.rowAndDatas.size();
        }
        return counter;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int getHoldability() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public Reader getNCharacterStream(int arg0) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public Reader getNCharacterStream(String arg0) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public NClob getNClob(int arg0) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public NClob getNClob(String arg0) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public String getNString(int arg0) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public String getNString(String arg0) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public RowId getRowId(int arg0) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public RowId getRowId(String arg0) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public SQLXML getSQLXML(int arg0) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public SQLXML getSQLXML(String arg0) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean isClosed() throws SQLException {
        return false;
    }

    @Override
    public void updateAsciiStream(int arg0, InputStream arg1) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateAsciiStream(String arg0, InputStream arg1) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateAsciiStream(int arg0, InputStream arg1, long arg2) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateAsciiStream(String arg0, InputStream arg1, long arg2) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateBinaryStream(int arg0, InputStream arg1) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateBinaryStream(String arg0, InputStream arg1) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateBinaryStream(int arg0, InputStream arg1, long arg2) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateBinaryStream(String arg0, InputStream arg1, long arg2) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateBlob(int arg0, InputStream arg1) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateBlob(String arg0, InputStream arg1) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateBlob(int arg0, InputStream arg1, long arg2) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateBlob(String arg0, InputStream arg1, long arg2) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateCharacterStream(int arg0, Reader arg1) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateCharacterStream(String arg0, Reader arg1) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateCharacterStream(int arg0, Reader arg1, long arg2) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateCharacterStream(String arg0, Reader arg1, long arg2) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateClob(int arg0, Reader arg1) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateClob(String arg0, Reader arg1) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateClob(int arg0, Reader arg1, long arg2) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateClob(String arg0, Reader arg1, long arg2) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateNCharacterStream(int arg0, Reader arg1) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateNCharacterStream(String arg0, Reader arg1) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateNCharacterStream(int arg0, Reader arg1, long arg2) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateNCharacterStream(String arg0, Reader arg1, long arg2) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateNClob(int arg0, NClob arg1) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateNClob(String arg0, NClob arg1) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateNClob(int arg0, Reader arg1) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateNClob(String arg0, Reader arg1) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateNClob(int arg0, Reader arg1, long arg2) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateNClob(String arg0, Reader arg1, long arg2) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateNString(int arg0, String arg1) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateNString(String arg0, String arg1) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateRowId(int arg0, RowId arg1) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateRowId(String arg0, RowId arg1) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateSQLXML(int arg0, SQLXML arg1) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateSQLXML(String arg0, SQLXML arg1) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        throw new SQLException("Method not supported");
    }
}

