/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.jdbc;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.jdbc.ColInfo;
import org.pentaho.di.jdbc.KettleDriver;
import org.pentaho.di.jdbc.KettleHelper;
import org.pentaho.di.jdbc.Support;

public class KettleJDBCResultSetMetaData
implements ResultSetMetaData {
    private static Class<?> PKG = KettleDriver.class;
    private ColInfo[] columns;
    private final transient Log log = LogFactory.getLog(KettleJDBCResultSetMetaData.class);
    private int columnCount = 0;
    private boolean useLOBs = false;

    public ColInfo[] getColumns() {
        return this.columns;
    }

    public void setColumns(ColInfo[] columns) {
        this.columns = columns;
    }

    public KettleJDBCResultSetMetaData() {
    }

    public KettleJDBCResultSetMetaData(ColInfo[] columns, int columnCount, boolean useLOBs) {
        this.columns = columns;
        this.columnCount = columnCount;
        this.useLOBs = useLOBs;
    }

    public KettleJDBCResultSetMetaData(List<RowMetaAndData> rowAndDatas, String columnStr) {
        if (rowAndDatas != null && rowAndDatas.size() > 0) {
            RowMetaAndData row = rowAndDatas.get(0);
            RowMeta rm = (RowMeta)row.getRowMeta();
            this.columns = columnStr.indexOf("*") != -1 ? KettleHelper.convert(rm) : KettleHelper.convert(rm, columnStr);
            this.columnCount = this.columns.length;
        }
        this.log.debug((Object)("KettleJDBCResultSetMetaData:" + rowAndDatas));
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        return null;
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        String c = Support.getClassName(this.getColumnType(column));
        if (!this.useLOBs) {
            if ("java.sql.Clob".equals(c)) {
                return "java.lang.String";
            }
            if ("java.sql.Blob".equals(c)) {
                return "[B";
            }
        }
        return c;
    }

    @Override
    public int getColumnCount() throws SQLException {
        this.log.debug((Object)("columnCount=" + this.columnCount));
        return this.columnCount;
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        this.log.debug((Object)"getColumnDisplaySize");
        return 0;
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        this.log.debug((Object)"getColumnLabel");
        return this.getColumn((int)column).name;
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        return this.getColumn((int)column).realName;
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        if (this.useLOBs) {
            return this.getColumn((int)column).jdbcType;
        }
        return Support.convertLOBType(this.getColumn((int)column).jdbcType);
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        return this.getColumn((int)column).sqlType;
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        return 0;
    }

    @Override
    public int getScale(int column) throws SQLException {
        return 0;
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        this.log.debug((Object)"getSchemaName");
        return null;
    }

    @Override
    public String getTableName(int column) throws SQLException {
        ColInfo col = this.getColumn(column);
        return col.tableName == null ? "" : col.tableName;
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        return false;
    }

    ColInfo getColumn(int column) throws SQLException {
        if (column < 1 || column > this.columnCount) {
            throw new SQLException(BaseMessages.getString(PKG, (String)"error.resultset.colindex", (String[])new String[]{Integer.toString(column)}), "07009");
        }
        this.log.debug((Object)"getColumn");
        return this.columns[column - 1];
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        return false;
    }

    @Override
    public int isNullable(int column) throws SQLException {
        return 0;
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }
}

