/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.jdbc;

import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleMissingPluginsException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.util.EnvUtil;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.jdbc.ConnectionJDBC3;
import org.pentaho.di.jdbc.KettleDriver;
import org.pentaho.di.jdbc.KettleJDBCResultSet;
import org.pentaho.di.jdbc.RowStepListener;
import org.pentaho.di.jdbc.SQLParser;
import org.pentaho.di.jdbc.URLParser;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.RowListener;
import org.pentaho.di.trans.step.StepInterface;

public class KettleJDBCStatement
implements Statement {
    private static Class<?> PKG = KettleDriver.class;
    private static final transient Log log = LogFactory.getLog(KettleJDBCStatement.class);
    private String url = null;
    private static Map<String, String[]> stepsMap = new Hashtable<String, String[]>();
    protected List<RowMetaAndData> rowAndDatas;
    protected ConnectionJDBC3 connection;
    RowStepListener listener = null;
    private boolean closed = false;
    protected String columnStr;
    private int queryTimeout = 100000;
    private int maxrows = 50000;
    private int fetchsize;
    private int maxfieldsize = 100;

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setConnection(ConnectionJDBC3 connection) {
        this.connection = connection;
    }

    public KettleJDBCStatement(ConnectionJDBC3 connection, String url) {
        log.debug((Object)"KettleJDBCStatement");
        this.url = url;
        try {
            KettleEnvironment.init();
        }
        catch (KettleException e) {
            throw new RuntimeException("Unable to initialize Kettle", e);
        }
        this.connection = connection;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void cancel() throws SQLException {
    }

    @Override
    public void clearBatch() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clearWarnings() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws SQLException {
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        if (sql == null || sql.length() == 0) {
            throw new SQLException(BaseMessages.getString(PKG, (String)"error.generic.nosql", (String[])new String[0]), "HY000");
        }
        this.initialize();
        TransMeta meta = null;
        Trans trans = null;
        try {
            String[] tmp = SQLParser.parse(sql, null, this.connection, true);
            String table = tmp[3];
            String where = tmp[1];
            String fileName = "";
            String stepName = "";
            int index = table.indexOf(".");
            if (index != -1) {
                stepName = table.substring(index + 1);
                fileName = table.substring(0, index);
            } else {
                stepName = table;
            }
            this.columnStr = tmp[2];
            String kettleurl = this.url.substring(this.url.indexOf("jdbc:kettle:") + "jdbc:kettle:".length());
            URLParser p = new URLParser();
            p.parse(kettleurl);
            String fileUrl = p.getKettleUrl();
            if (fileUrl.indexOf("file://") != -1) {
                fileUrl = fileUrl.substring(fileUrl.indexOf("file://") + 7);
            } else if (fileUrl.indexOf("file:///") != -1) {
                fileUrl = fileUrl.substring(fileUrl.indexOf("file://") + 8);
            }
            File f = new File(fileUrl);
            if (f.isDirectory()) {
                if (KettleJDBCStatement.visitDirectory(f)) {
                    log.debug((Object)("file=" + p.getKettleUrl() + File.separator + fileName + ".ktr"));
                    meta = new TransMeta(p.getKettleUrl() + File.separator + fileName + ".ktr");
                }
            } else {
                meta = new TransMeta(p.getKettleUrl());
            }
            if (meta == null) {
                throw new SQLException("The  transformation or job" + fileUrl + "  is not valid.");
            }
            if (p.getOptions() != null) {
                this.setVariables(meta, p.getOptions());
            }
            if (where != null && where.length() > 1) {
                if (where.indexOf(" and") == -1) {
                    int windex = where.indexOf("=");
                    if (windex != -1) {
                        String variableName = where.substring(0, windex);
                        int kindex = (variableName = variableName.trim()).lastIndexOf(".");
                        if (kindex != -1) {
                            variableName = variableName.substring(kindex + 1);
                        }
                        String variableValue = where.substring(windex + 1);
                        meta.setVariable(variableName, variableValue);
                    }
                } else {
                    int andIndex = where.indexOf("and");
                    while (andIndex != -1) {
                        String tmpStr = where.substring(0, andIndex);
                        where = where.substring(andIndex + 3);
                        andIndex = where.indexOf("and");
                        int windex = (tmpStr = tmpStr.trim()).indexOf("=");
                        if (windex == -1) continue;
                        String variableName = tmpStr.substring(0, windex);
                        int kindex = (variableName = variableName.trim()).lastIndexOf(".");
                        if (kindex != -1) {
                            variableName = variableName.substring(kindex + 1);
                        }
                        String variableValue = tmpStr.substring(windex + 1);
                        meta.setVariable(variableName, variableValue);
                    }
                }
            }
            trans = new Trans(meta);
            trans.prepareExecution(null);
            this.listener = new RowStepListener();
            String[] stepNames = meta.getStepNames();
            if (stepNames == null || stepNames.length == 0) {
                throw new SQLException("The  transformation or job  is not valid.");
            }
            StepInterface si1 = trans.getStepInterface(stepName, 0);
            si1.addRowListener((RowListener)this.listener);
            trans.startThreads();
            trans.waitUntilFinished();
            this.rowAndDatas = this.listener.getRowsWritten();
            if (trans.getErrors() == 0) {
                return true;
            }
        }
        catch (KettleException e) {
            e.printStackTrace();
            log.error((Object)e.getMessage());
            throw new SQLException(e.getMessage());
        }
        return false;
    }

    private void setVariables(TransMeta meta, String[] options) {
        for (int i = 0; i < options.length; ++i) {
            String option = options[i];
            int index = option.indexOf("=");
            String variableName = option.substring(0, index);
            String variableValue = option.substring(index + 1);
            meta.setVariable(variableName, variableValue);
        }
    }

    public static boolean visitDirectory(File f) {
        File[] files = f.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                try {
                    if (files[i].getName().lastIndexOf("ktr") == -1) continue;
                    KettleJDBCStatement.addMetadata(files[i]);
                    continue;
                }
                catch (KettleException e) {
                    e.printStackTrace();
                    return false;
                }
            }
        }
        return true;
    }

    private static void addMetadata(File file) throws KettleXMLException, KettleMissingPluginsException {
        TransMeta tm = new TransMeta(file.getAbsolutePath());
        log.debug((Object)Arrays.toString(tm.getStepNames()));
        stepsMap.put(file.getName(), tm.getStepNames());
    }

    private void initialize() {
        if (!KettleEnvironment.isInitialized()) {
            try {
                KettleEnvironment.init();
            }
            catch (KettleException e) {
                throw new RuntimeException("Unable to initialize Kettle", e);
            }
        }
    }

    protected void checkOpen() throws SQLException {
        if (this.closed || this.connection == null || this.connection.isClosed()) {
            throw new SQLException(BaseMessages.getString(PKG, (String)"error.generic.closed", (String[])new String[]{"Statement"}), "HY010");
        }
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return this.execute(sql);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.execute(sql);
        KettleJDBCResultSet rs = new KettleJDBCResultSet(this, this.rowAndDatas, this.columnStr);
        return rs;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getFetchSize() throws SQLException {
        if (this.fetchsize <= 0) {
            this.fetchsize = 10000;
        }
        log.debug((Object)("getFetchSize():" + this.fetchsize));
        return this.fetchsize;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this.maxfieldsize;
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.maxrows;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.queryTimeout;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        KettleJDBCResultSet rs = new KettleJDBCResultSet(this, this.rowAndDatas, this.columnStr);
        return rs;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getResultSetType() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getUpdateCount() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.fetchsize = rows;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
    }

    public static void main(String[] args) throws Exception {
        KettleEnvironment.init();
        EnvUtil.environmentInit();
        String fileDir = "E:/project/kettlejdbc-google/trunk/samples";
        KettleJDBCStatement.visitDirectory(new File(fileDir));
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean isClosed() throws SQLException {
        return false;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return false;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
    }

    @Override
    public void closeOnCompletion() throws SQLException {
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return false;
    }
}

