/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.jdbc;

import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.jdbc.ConnectionJDBC3;
import org.pentaho.di.jdbc.KettleDriver;
import org.pentaho.di.jdbc.Sanitizer;
import org.pentaho.di.jdbc.StringTools;

public class SQLParser {
    private static Class<?> PKG = KettleDriver.class;
    private String sql;
    private char[] in;
    private int s;
    private int len;
    private char[] out;
    private int d;
    private ArrayList<String> params;
    private char terminator;
    private String procName;
    private String keyWord;
    private String tableName;
    private ConnectionJDBC3 connection;
    private static final transient Log log = LogFactory.getLog(SQLParser.class);
    private static final byte[] timeMask = new byte[]{35, 35, 58, 35, 35, 58, 35, 35};
    private static final byte[] dateMask = new byte[]{35, 35, 35, 35, 45, 35, 35, 45, 35, 35};
    static final byte[] timestampMask = new byte[]{35, 35, 35, 35, 45, 35, 35, 45, 35, 35, 32, 35, 35, 58, 35, 35, 58, 35, 35};
    private static boolean[] identifierChar = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, true, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false};
    public static final String select_token = "select";
    public static final String from_token = "from";
    public static final String where_token = "where";

    public SQLParser(String sqlIn, ArrayList<String> paramList, ConnectionJDBC3 connection) {
        this.sql = sqlIn;
        this.in = this.sql.toCharArray();
        this.len = this.in.length;
        this.out = new char[this.len + 256];
        this.params = paramList;
        this.procName = "";
        this.connection = connection;
    }

    public static String[] parse(String sql, ArrayList<String> paramList, ConnectionJDBC3 connection, boolean extractTable) throws SQLException {
        return SQLParser.parse2(sql);
    }

    public static String[] parse2(String sql) throws SQLException {
        String[] result = new String[4];
        log.debug((Object)("sql=" + sql));
        String tmpStr = StringTools.removeToken(sql, '\"');
        tmpStr = Sanitizer.lowercase2(tmpStr);
        log.debug((Object)("tmpStr=" + tmpStr));
        String columnStr = tmpStr.substring(tmpStr.indexOf(select_token) + select_token.length() + 1);
        String table = "";
        String where = "";
        String str = tmpStr.substring(tmpStr.lastIndexOf(from_token) + from_token.length());
        if (str.indexOf(where_token) == -1) {
            table = str;
        } else {
            table = str.substring(0, str.indexOf(where_token));
            where = str.substring(str.indexOf(where_token) + where_token.length());
        }
        table = table.trim();
        columnStr = columnStr.trim();
        columnStr = columnStr.substring(0, columnStr.lastIndexOf(from_token));
        columnStr = columnStr.trim();
        result[3] = table;
        result[2] = columnStr;
        result[1] = where;
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    String[] parse(boolean extractTable) throws SQLException {
        boolean isSelect = false;
        boolean isModified = false;
        boolean isSlowScan = true;
        try {
            block9: while (this.s < this.len) {
                char c = this.in[this.s];
                switch (c) {
                    case '{': {
                        this.escape();
                        isModified = true;
                        continue block9;
                    }
                    case '\"': 
                    case '\'': 
                    case '[': {
                        this.copyString();
                        continue block9;
                    }
                    case '?': {
                        this.copyParam(null, this.d);
                        continue block9;
                    }
                    case '/': {
                        if (this.s + 1 < this.len && this.in[this.s + 1] == '*') {
                            this.skipMultiComments();
                            continue block9;
                        }
                        this.out[this.d++] = c;
                        ++this.s;
                        continue block9;
                    }
                    case '-': {
                        if (this.s + 1 < this.len && this.in[this.s + 1] == '-') {
                            this.skipSingleComments();
                            continue block9;
                        }
                        this.out[this.d++] = c;
                        ++this.s;
                        continue block9;
                    }
                }
                if (isSlowScan && Character.isLetter(c)) {
                    if (this.keyWord == null) {
                        this.keyWord = this.copyKeyWord();
                        if (select_token.equals(this.keyWord)) {
                            isSelect = true;
                        }
                        isSlowScan = extractTable && isSelect;
                        continue;
                    }
                    if (extractTable && isSelect) {
                        String sqlWord = this.copyKeyWord();
                        if (!from_token.equals(sqlWord)) continue;
                        isSlowScan = false;
                        this.tableName = this.getTableName();
                        continue;
                    }
                }
                this.out[this.d++] = c;
                ++this.s;
            }
            String[] result = new String[]{isModified ? new String(this.out, 0, this.d) : this.sql, this.procName, this.keyWord == null ? "" : this.keyWord, this.tableName};
            return result;
        }
        catch (IndexOutOfBoundsException e) {
            throw new SQLException(BaseMessages.getString(PKG, (String)"error.parsesql.missing", (String[])new String[]{String.valueOf(this.terminator)}), "22025");
        }
    }

    private String getTableName() throws SQLException {
        int c;
        StringBuffer name = new StringBuffer(128);
        this.copyWhiteSpace();
        int n = c = this.s < this.len ? this.in[this.s] : 32;
        if (c == 123) {
            return "";
        }
        while (c == 47 || c == 45 && this.s + 1 < this.len) {
            if (c == 47) {
                if (this.in[this.s + 1] != '*') break;
                this.skipMultiComments();
            } else {
                if (this.in[this.s + 1] != '-') break;
                this.skipSingleComments();
            }
            this.copyWhiteSpace();
            c = this.s < this.len ? this.in[this.s] : 32;
        }
        if (c == 123) {
            return "";
        }
        while (this.s < this.len) {
            int start;
            if (c == 91 || c == 34) {
                start = this.d;
                this.copyString();
                name.append(String.valueOf(this.out, start, this.d - start));
                this.copyWhiteSpace();
                c = this.s < this.len ? this.in[this.s] : 32;
            } else {
                start = this.d;
                int n2 = c = this.s < this.len ? this.in[this.s++] : 32;
                while (SQLParser.isIdentifier(c) && c != 46 && c != 44) {
                    this.out[this.d++] = c;
                    c = this.s < this.len ? this.in[this.s++] : 32;
                }
                name.append(String.valueOf(this.out, start, this.d - start));
                --this.s;
                this.copyWhiteSpace();
                int n3 = c = this.s < this.len ? this.in[this.s] : 32;
            }
            if (c != 46) break;
            name.append((char)c);
            this.out[this.d++] = c;
            ++this.s;
            this.copyWhiteSpace();
            c = this.s < this.len ? this.in[this.s] : 32;
        }
        return name.toString();
    }

    private void copyWhiteSpace() {
        while (this.s < this.in.length && Character.isWhitespace(this.in[this.s])) {
            this.out[this.d++] = this.in[this.s++];
        }
    }

    private void copyParam(String name, int pos) throws SQLException {
    }

    private void skipWhiteSpace() {
        while (Character.isWhitespace(this.in[this.s])) {
            ++this.s;
        }
    }

    private void skipSingleComments() {
        while (this.s < this.len && this.in[this.s] != '\n' && this.in[this.s] != '\r') {
            this.out[this.d++] = this.in[this.s++];
        }
    }

    private void skipMultiComments() throws SQLException {
        int block = 0;
        do {
            if (this.s < this.len - 1) {
                if (this.in[this.s] == '/' && this.in[this.s + 1] == '*') {
                    ++block;
                } else if (this.in[this.s] == '*' && this.in[this.s + 1] == '/') {
                    --block;
                }
            } else {
                throw new SQLException(BaseMessages.getString(PKG, (String)"error.parsesql.missing", (String[])new String[]{"*/"}), "22025");
            }
            this.out[this.d++] = this.in[this.s++];
        } while (block > 0);
        this.out[this.d++] = this.in[this.s++];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void escape() throws SQLException {
        char tc = this.terminator;
        this.terminator = (char)125;
        StringBuffer escBuf = new StringBuffer();
        ++this.s;
        this.skipWhiteSpace();
        if (this.in[this.s] == '?') {
            this.copyParam("@return_status", -1);
            this.skipWhiteSpace();
            this.mustbe('=', false);
            this.skipWhiteSpace();
            while (Character.isLetter(this.in[this.s])) {
                escBuf.append(Character.toLowerCase(this.in[this.s++]));
            }
            this.skipWhiteSpace();
            String esc = escBuf.toString();
            if (!"call".equals(esc)) throw new SQLException(BaseMessages.getString(PKG, (String)"error.parsesql.syntax", (String[])new String[]{"call", String.valueOf(this.s)}), "22019");
            this.callEscape();
        } else {
            while (Character.isLetter(this.in[this.s])) {
                escBuf.append(Character.toLowerCase(this.in[this.s++]));
            }
            this.skipWhiteSpace();
            String esc = escBuf.toString();
            if ("call".equals(esc)) {
                this.callEscape();
            } else if ("t".equals(esc)) {
                if (!this.getDateTimeField(timeMask)) {
                    throw new SQLException(BaseMessages.getString(PKG, (String)"error.parsesql.syntax", (String[])new String[]{"time", String.valueOf(this.s)}), "22019");
                }
            } else if ("d".equals(esc)) {
                if (!this.getDateTimeField(dateMask)) {
                    throw new SQLException(BaseMessages.getString(PKG, (String)"error.parsesql.syntax", (String[])new String[]{"date", String.valueOf(this.s)}), "22019");
                }
            } else {
                if (!"ts".equals(esc)) throw new SQLException(BaseMessages.getString(PKG, (String)"error.parsesql.badesc", (String[])new String[]{esc, String.valueOf(this.s)}), "22019");
                if (!this.getDateTimeField(timestampMask)) {
                    throw new SQLException(BaseMessages.getString(PKG, (String)"error.parsesql.syntax", (String[])new String[]{"timestamp", String.valueOf(this.s)}), "22019");
                }
            }
        }
        this.mustbe('}', false);
        this.terminator = tc;
    }

    private boolean getDateTimeField(byte[] mask) throws SQLException {
        this.skipWhiteSpace();
        if (this.in[this.s] == '?') {
            this.copyParam(null, this.d);
            this.skipWhiteSpace();
            return this.in[this.s] == this.terminator;
        }
        this.out[this.d++] = 39;
        this.terminator = (char)(this.in[this.s] == '\'' || this.in[this.s] == '\"' ? this.in[this.s++] : 125);
        this.skipWhiteSpace();
        int ptr = 0;
        while (ptr < mask.length) {
            char c;
            if ((c = this.in[this.s++]) == ' ' && this.out[this.d - 1] == ' ') continue;
            if (mask[ptr] == 35 ? !Character.isDigit(c) : mask[ptr] != c) {
                return false;
            }
            if (c != '-') {
                this.out[this.d++] = c;
            }
            ++ptr;
        }
        if (mask.length == 19) {
            int digits = 0;
            if (this.in[this.s] == '.') {
                this.out[this.d++] = this.in[this.s++];
                while (Character.isDigit(this.in[this.s])) {
                    if (digits < 3) {
                        this.out[this.d++] = this.in[this.s++];
                        ++digits;
                        continue;
                    }
                    ++this.s;
                }
            } else {
                this.out[this.d++] = 46;
            }
            while (digits < 3) {
                this.out[this.d++] = 48;
                ++digits;
            }
        }
        this.skipWhiteSpace();
        if (this.in[this.s] != this.terminator) {
            return false;
        }
        if (this.terminator != '}') {
            ++this.s;
        }
        this.skipWhiteSpace();
        this.out[this.d++] = 39;
        return true;
    }

    private void mustbe(char c, boolean copy) throws SQLException {
        if (this.in[this.s] != c) {
            throw new SQLException(BaseMessages.getString(PKG, (String)"error.parsesql.mustbe", (String[])new String[]{String.valueOf(this.s), String.valueOf(c)}), "22019");
        }
        if (copy) {
            this.out[this.d++] = this.in[this.s++];
        } else {
            ++this.s;
        }
    }

    private void callEscape() throws SQLException {
        this.copyLiteral("EXECUTE ");
        this.keyWord = "execute";
        this.procName = this.copyProcName();
        this.skipWhiteSpace();
        if (this.in[this.s] == '(') {
            ++this.s;
            this.terminator = (char)41;
            this.skipWhiteSpace();
        } else {
            this.terminator = (char)125;
        }
        this.out[this.d++] = 32;
        while (this.in[this.s] != this.terminator) {
            String name = null;
            if (this.in[this.s] == '@') {
                name = this.copyParamName();
                this.skipWhiteSpace();
                this.mustbe('=', true);
                this.skipWhiteSpace();
                if (this.in[this.s] == '?') {
                    this.copyParam(name, this.d);
                } else {
                    this.procName = "";
                }
            } else if (this.in[this.s] == '?') {
                this.copyParam(name, this.d);
            } else {
                this.procName = "";
            }
            while (this.in[this.s] != this.terminator && this.in[this.s] != ',') {
                if (this.in[this.s] == '{') {
                    this.escape();
                    continue;
                }
                if (this.in[this.s] == '\'' || this.in[this.s] == '[' || this.in[this.s] == '\"') {
                    this.copyString();
                    continue;
                }
                this.out[this.d++] = this.in[this.s++];
            }
            if (this.in[this.s] == ',') {
                this.out[this.d++] = this.in[this.s++];
            }
            this.skipWhiteSpace();
        }
        if (this.terminator == ')') {
            ++this.s;
        }
        this.terminator = (char)125;
        this.skipWhiteSpace();
    }

    private String copyProcName() throws SQLException {
        int start = this.d;
        block0: while (true) {
            if (this.in[this.s] == '\"' || this.in[this.s] == '[') {
                this.copyString();
            } else {
                char c = this.in[this.s++];
                while (SQLParser.isIdentifier(c) || c == ';') {
                    this.out[this.d++] = c;
                    c = this.in[this.s++];
                }
                --this.s;
            }
            if (this.in[this.s] != '.') break;
            while (true) {
                if (this.in[this.s] != '.') continue block0;
                this.out[this.d++] = this.in[this.s++];
            }
            break;
        }
        if (this.d == start) {
            throw new SQLException(BaseMessages.getString(PKG, (String)"error.parsesql.syntax", (String[])new String[]{"call", String.valueOf(this.s)}), "22025");
        }
        return new String(this.out, start, this.d - start);
    }

    private String copyParamName() {
        int start = this.d;
        char c = this.in[this.s++];
        while (SQLParser.isIdentifier(c)) {
            this.out[this.d++] = c;
            c = this.in[this.s++];
        }
        --this.s;
        return new String(this.out, start, this.d - start);
    }

    private void copyLiteral(String txt) throws SQLException {
    }

    private void copyString() {
        char saveTc = this.terminator;
        char tc = this.in[this.s];
        if (tc == '[') {
            tc = ']';
        }
        this.terminator = tc;
        this.out[this.d++] = this.in[this.s++];
        while (this.in[this.s] != tc) {
            this.out[this.d++] = this.in[this.s++];
        }
        this.out[this.d++] = this.in[this.s++];
        this.terminator = saveTc;
    }

    private String copyKeyWord() {
        int start = this.d;
        while (this.s < this.len && SQLParser.isIdentifier(this.in[this.s])) {
            this.out[this.d++] = this.in[this.s++];
        }
        return String.valueOf(this.out, start, this.d - start).toLowerCase();
    }

    private static boolean isIdentifier(int ch) {
        return ch > 127 || identifierChar[ch];
    }

    public ArrayList<String> getParams() {
        return this.params;
    }

    public void setParams(ArrayList<String> params) {
        this.params = params;
    }

    public ConnectionJDBC3 getConnection() {
        return this.connection;
    }

    public void setConnection(ConnectionJDBC3 connection) {
        this.connection = connection;
    }
}

