/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.jdbc;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.jdbc.BlobImpl;
import org.pentaho.di.jdbc.ClobImpl;
import org.pentaho.di.jdbc.ConnectionJDBC3;
import org.pentaho.di.jdbc.DateTime;
import org.pentaho.di.jdbc.KettleDriver;
import org.pentaho.di.jdbc.UniqueIdentifier;

public class Support {
    private static Class<?> PKG = KettleDriver.class;
    private static final Integer INTEGER_ZERO = new Integer(0);
    private static final Integer INTEGER_ONE = new Integer(1);
    private static final Long LONG_ZERO = new Long(0L);
    private static final Long LONG_ONE = new Long(1L);
    private static final Float FLOAT_ZERO = new Float(0.0);
    private static final Float FLOAT_ONE = new Float(1.0);
    private static final Double DOUBLE_ZERO = new Double(0.0);
    private static final Double DOUBLE_ONE = new Double(1.0);
    private static final BigDecimal BIG_DECIMAL_ZERO = new BigDecimal(0.0);
    private static final BigDecimal BIG_DECIMAL_ONE = new BigDecimal(1.0);
    private static final Date DATE_ZERO = new Date(0L);
    private static final Time TIME_ZERO = new Time(0L);
    public static final BigInteger MAX_VALUE_28 = new BigInteger("9999999999999999999999999999");
    public static final BigInteger MAX_VALUE_38 = new BigInteger("99999999999999999999999999999999999999");
    private static final transient Log log = LogFactory.getLog(Support.class);
    private static final HashMap<Class<?>, Integer> typeMap = new HashMap();
    private static final char[] hex;
    private static final GregorianCalendar cal;

    public static String toHex(byte[] bytes) {
        int len = bytes.length;
        if (len > 0) {
            StringBuffer buf = new StringBuffer(len * 2);
            for (int i = 0; i < len; ++i) {
                int b1 = bytes[i] & 0xFF;
                buf.append(hex[b1 >> 4]);
                buf.append(hex[b1 & 0xF]);
            }
            return buf.toString();
        }
        return "";
    }

    static BigDecimal normalizeBigDecimal(BigDecimal value, int maxPrecision) throws SQLException {
        if (value == null) {
            return null;
        }
        if (value.scale() < 0) {
            value = value.setScale(0);
        }
        if (value.scale() > maxPrecision) {
            value = value.setScale(maxPrecision, 4);
        }
        BigInteger max = MAX_VALUE_38;
        while (value.abs().unscaledValue().compareTo(max) > 0) {
            int scale = value.scale() - 1;
            if (scale < 0) {
                throw new SQLException(BaseMessages.getString(PKG, (String)"error.normalize.numtoobig", (String[])new String[]{String.valueOf(maxPrecision)}), "22000");
            }
            value = value.setScale(scale, 4);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object convert(Object callerReference, Object x, int jdbcType, String charSet) throws SQLException {
        try {
            switch (jdbcType) {
                case -6: 
                case 4: 
                case 5: {
                    if (x == null) {
                        return INTEGER_ZERO;
                    }
                    if (x instanceof Integer) {
                        return x;
                    }
                    if (x instanceof Byte) {
                        return new Integer((int)((Byte)x & 0xFF));
                    }
                    if (x instanceof Number) {
                        return new Integer(((Number)x).intValue());
                    }
                    if (x instanceof String) {
                        return new Integer(((String)x).trim());
                    }
                    if (!(x instanceof Boolean)) break;
                    return (Boolean)x != false ? INTEGER_ONE : INTEGER_ZERO;
                }
                case -5: {
                    if (x == null) {
                        return LONG_ZERO;
                    }
                    if (x instanceof Long) {
                        return x;
                    }
                    if (x instanceof Byte) {
                        return new Long((long)((Byte)x & 0xFF));
                    }
                    if (x instanceof Number) {
                        return new Long(((Number)x).longValue());
                    }
                    if (x instanceof String) {
                        return new Long(((String)x).trim());
                    }
                    if (!(x instanceof Boolean)) break;
                    return (Boolean)x != false ? LONG_ONE : LONG_ZERO;
                }
                case 7: {
                    if (x == null) {
                        return FLOAT_ZERO;
                    }
                    if (x instanceof Float) {
                        return x;
                    }
                    if (x instanceof Byte) {
                        return new Float((float)((Byte)x & 0xFF));
                    }
                    if (x instanceof Number) {
                        return new Float(((Number)x).floatValue());
                    }
                    if (x instanceof String) {
                        return new Float(((String)x).trim());
                    }
                    if (!(x instanceof Boolean)) break;
                    return (Boolean)x != false ? FLOAT_ONE : FLOAT_ZERO;
                }
                case 6: 
                case 8: {
                    if (x == null) {
                        return DOUBLE_ZERO;
                    }
                    if (x instanceof Double) {
                        return x;
                    }
                    if (x instanceof Byte) {
                        return new Double((double)((Byte)x & 0xFF));
                    }
                    if (x instanceof Number) {
                        return new Double(((Number)x).doubleValue());
                    }
                    if (x instanceof String) {
                        return new Double(((String)x).trim());
                    }
                    if (!(x instanceof Boolean)) break;
                    return (Boolean)x != false ? DOUBLE_ONE : DOUBLE_ZERO;
                }
                case 2: 
                case 3: {
                    if (x == null) {
                        return null;
                    }
                    if (x instanceof BigDecimal) {
                        return x;
                    }
                    if (x instanceof Number) {
                        return new BigDecimal(x.toString());
                    }
                    if (x instanceof String) {
                        return new BigDecimal((String)x);
                    }
                    if (!(x instanceof Boolean)) break;
                    return (Boolean)x != false ? BIG_DECIMAL_ONE : BIG_DECIMAL_ZERO;
                }
                case 1: 
                case 12: {
                    if (x == null) {
                        return null;
                    }
                    if (x instanceof String) {
                        return x;
                    }
                    if (x instanceof Number) {
                        return x.toString();
                    }
                    if (x instanceof Boolean) {
                        return (Boolean)x != false ? "1" : "0";
                    }
                    if (x instanceof Clob) {
                        Clob clob = (Clob)x;
                        long length = clob.length();
                        if (length > Integer.MAX_VALUE) {
                            throw new SQLException(BaseMessages.getString(PKG, (String)"error.normalize.lobtoobig", (String[])new String[0]), "22000");
                        }
                        return clob.getSubString(1L, (int)length);
                    }
                    if (x instanceof Blob) {
                        Blob blob = (Blob)x;
                        long length = blob.length();
                        if (length > Integer.MAX_VALUE) {
                            throw new SQLException(BaseMessages.getString(PKG, (String)"error.normalize.lobtoobig", (String[])new String[0]), "22000");
                        }
                        x = blob.getBytes(1L, (int)length);
                    }
                    if (x instanceof byte[]) {
                        return Support.toHex((byte[])x);
                    }
                    return x.toString();
                }
                case -7: 
                case 16: {
                    if (x == null) {
                        return Boolean.FALSE;
                    }
                    if (x instanceof Boolean) {
                        return x;
                    }
                    if (x instanceof Number) {
                        return ((Number)x).intValue() == 0 ? Boolean.FALSE : Boolean.TRUE;
                    }
                    if (!(x instanceof String)) break;
                    String tmp = ((String)x).trim();
                    return "1".equals(tmp) || "true".equalsIgnoreCase(tmp) ? Boolean.TRUE : Boolean.FALSE;
                }
                case -3: 
                case -2: {
                    if (x == null) {
                        return null;
                    }
                    if (x instanceof byte[]) {
                        return x;
                    }
                    if (x instanceof Blob) {
                        Blob blob = (Blob)x;
                        return blob.getBytes(1L, (int)blob.length());
                    }
                    if (x instanceof Clob) {
                        Clob clob = (Clob)x;
                        long length = clob.length();
                        if (length > Integer.MAX_VALUE) {
                            throw new SQLException(BaseMessages.getString(PKG, (String)"error.normalize.lobtoobig", (String[])new String[0]), "22000");
                        }
                        x = clob.getSubString(1L, (int)length);
                    }
                    if (x instanceof String) {
                        if (charSet == null) {
                            charSet = "ISO-8859-1";
                        }
                        try {
                            return ((String)x).getBytes(charSet);
                        }
                        catch (UnsupportedEncodingException e) {
                            return ((String)x).getBytes();
                        }
                    }
                    if (!(x instanceof UniqueIdentifier)) break;
                    return ((UniqueIdentifier)x).getBytes();
                }
                case 93: {
                    if (x == null) {
                        return null;
                    }
                    if (x instanceof DateTime) {
                        return ((DateTime)x).toTimestamp();
                    }
                    if (x instanceof Timestamp) {
                        return x;
                    }
                    if (x instanceof Date) {
                        return new Timestamp(((Date)x).getTime());
                    }
                    if (x instanceof Time) {
                        return new Timestamp(((Time)x).getTime());
                    }
                    if (!(x instanceof String)) break;
                    return Timestamp.valueOf(((String)x).trim());
                }
                case 91: {
                    if (x == null) {
                        return null;
                    }
                    if (x instanceof DateTime) {
                        return ((DateTime)x).toDate();
                    }
                    if (x instanceof Date) {
                        return x;
                    }
                    if (x instanceof Time) {
                        return DATE_ZERO;
                    }
                    if (x instanceof Timestamp) {
                        GregorianCalendar e = cal;
                        synchronized (e) {
                            cal.setTime((java.util.Date)x);
                            cal.set(11, 0);
                            cal.set(12, 0);
                            cal.set(13, 0);
                            cal.set(14, 0);
                            return new Date(cal.getTime().getTime());
                        }
                    }
                    if (!(x instanceof String)) break;
                    return Date.valueOf(((String)x).trim());
                }
                case 92: {
                    if (x == null) {
                        return null;
                    }
                    if (x instanceof DateTime) {
                        return ((DateTime)x).toTime();
                    }
                    if (x instanceof Time) {
                        return x;
                    }
                    if (x instanceof Date) {
                        return TIME_ZERO;
                    }
                    if (x instanceof Timestamp) {
                        GregorianCalendar e = cal;
                        synchronized (e) {
                            cal.setTime((java.util.Date)x);
                            cal.set(1, 1970);
                            cal.set(2, 0);
                            cal.set(5, 1);
                            return new Time(cal.getTime().getTime());
                        }
                    }
                    if (!(x instanceof String)) break;
                    return Time.valueOf(((String)x).trim());
                }
                case 1111: {
                    return x;
                }
                case 2000: {
                    throw new SQLException(BaseMessages.getString(PKG, (String)"error.convert.badtypes", (String[])new String[]{x.getClass().getName(), Support.getJdbcTypeName(jdbcType)}), "22005");
                }
                case -4: 
                case 2004: {
                    if (x == null) {
                        return null;
                    }
                    if (x instanceof Blob) {
                        return x;
                    }
                    if (x instanceof byte[]) {
                        return new BlobImpl(Support.getConnection(callerReference), (byte[])x);
                    }
                    if (x instanceof Clob) {
                        Clob clob = (Clob)x;
                        try {
                            int c;
                            if (charSet == null) {
                                charSet = "ISO-8859-1";
                            }
                            Reader rdr = clob.getCharacterStream();
                            BlobImpl blob = new BlobImpl(Support.getConnection(callerReference));
                            BufferedWriter out = new BufferedWriter(new OutputStreamWriter(blob.setBinaryStream(1L), charSet));
                            while ((c = rdr.read()) >= 0) {
                                out.write(c);
                            }
                            out.close();
                            rdr.close();
                            return blob;
                        }
                        catch (UnsupportedEncodingException e) {
                            x = clob.getSubString(1L, (int)clob.length());
                        }
                        catch (IOException e) {
                            throw new SQLException(BaseMessages.getString(PKG, (String)"error.generic.ioerror", (String[])new String[]{e.getMessage()}), "HY000");
                        }
                    }
                    if (!(x instanceof String)) break;
                    BlobImpl blob = new BlobImpl(Support.getConnection(callerReference));
                    String data = (String)x;
                    if (charSet == null) {
                        charSet = "ISO-8859-1";
                    }
                    try {
                        blob.setBytes(1L, data.getBytes(charSet));
                    }
                    catch (UnsupportedEncodingException e) {
                        blob.setBytes(1L, data.getBytes());
                    }
                    return blob;
                }
                case -1: 
                case 2005: {
                    if (x == null) {
                        return null;
                    }
                    if (x instanceof Clob) {
                        return x;
                    }
                    if (x instanceof Blob) {
                        Blob blob = (Blob)x;
                        try {
                            int b;
                            InputStream is = blob.getBinaryStream();
                            ClobImpl clob = new ClobImpl(Support.getConnection(callerReference));
                            Writer out = clob.setCharacterStream(1L);
                            while ((b = is.read()) >= 0) {
                                out.write(hex[b >> 4]);
                                out.write(hex[b & 0xF]);
                            }
                            out.close();
                            is.close();
                            return clob;
                        }
                        catch (IOException e) {
                            throw new SQLException(BaseMessages.getString(PKG, (String)"error.generic.ioerror", (String[])new String[]{e.getMessage()}), "HY000");
                        }
                    }
                    if (x instanceof Boolean) {
                        x = (Boolean)x != false ? "1" : "0";
                    } else if (!(x instanceof byte[])) {
                        x = x.toString();
                    }
                    if (x instanceof byte[]) {
                        ClobImpl clob = new ClobImpl(Support.getConnection(callerReference));
                        clob.setString(1L, Support.toHex((byte[])x));
                        return clob;
                    }
                    if (!(x instanceof String)) break;
                    return new ClobImpl(Support.getConnection(callerReference), (String)x);
                }
                default: {
                    throw new SQLException(BaseMessages.getString(PKG, (String)"error.convert.badtypeconst", (String[])new String[]{Support.getJdbcTypeName(jdbcType)}), "HY004");
                }
            }
            throw new SQLException(BaseMessages.getString(PKG, (String)"error.convert.badtypes", (String[])new String[]{x.getClass().getName(), Support.getJdbcTypeName(jdbcType)}), "22005");
        }
        catch (NumberFormatException nfe) {
            throw new SQLException(BaseMessages.getString(PKG, (String)"error.convert.badnumber", (String[])new String[]{Support.getJdbcTypeName(jdbcType)}), "22000");
        }
    }

    static int getJdbcType(Object value) {
        if (value == null) {
            return 0;
        }
        return Support.getJdbcType(value.getClass());
    }

    static int getJdbcType(Class<?> typeClass) {
        if (typeClass == null) {
            return 2000;
        }
        Integer type = typeMap.get(typeClass);
        if (type == null) {
            return Support.getJdbcType(typeClass.getSuperclass());
        }
        return type;
    }

    static String getJdbcTypeName(int jdbcType) {
        switch (jdbcType) {
            case 2003: {
                return "ARRAY";
            }
            case -5: {
                return "BIGINT";
            }
            case -2: {
                return "BINARY";
            }
            case -7: {
                return "BIT";
            }
            case 2004: {
                return "BLOB";
            }
            case 16: {
                return "BOOLEAN";
            }
            case 1: {
                return "CHAR";
            }
            case 2005: {
                return "CLOB";
            }
            case 91: {
                return "DATE";
            }
            case 3: {
                return "DECIMAL";
            }
            case 2001: {
                return "DISTINCT";
            }
            case 8: {
                return "DOUBLE";
            }
            case 6: {
                return "FLOAT";
            }
            case 4: {
                return "INTEGER";
            }
            case 2000: {
                return "JAVA_OBJECT";
            }
            case -4: {
                return "LONGVARBINARY";
            }
            case -1: {
                return "LONGVARCHAR";
            }
            case 0: {
                return "NULL";
            }
            case 2: {
                return "NUMERIC";
            }
            case 1111: {
                return "OTHER";
            }
            case 7: {
                return "REAL";
            }
            case 2006: {
                return "REF";
            }
            case 5: {
                return "SMALLINT";
            }
            case 2002: {
                return "STRUCT";
            }
            case 92: {
                return "TIME";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case -6: {
                return "TINYINT";
            }
            case -3: {
                return "VARBINARY";
            }
            case 12: {
                return "VARCHAR";
            }
        }
        return "ERROR";
    }

    static String getClassName(int jdbcType) {
        switch (jdbcType) {
            case -7: 
            case 16: {
                return "java.lang.Boolean";
            }
            case -6: 
            case 4: 
            case 5: {
                return "java.lang.Integer";
            }
            case -5: {
                return "java.lang.Long";
            }
            case 2: 
            case 3: {
                return "java.math.BigDecimal";
            }
            case 7: {
                return "java.lang.Float";
            }
            case 6: 
            case 8: {
                return "java.lang.Double";
            }
            case 1: 
            case 12: {
                return "java.lang.String";
            }
            case -3: 
            case -2: {
                return "[B";
            }
            case -4: 
            case 2004: {
                return "java.sql.Blob";
            }
            case -1: 
            case 2005: {
                return "java.sql.Clob";
            }
            case 91: {
                return "java.sql.Date";
            }
            case 92: {
                return "java.sql.Time";
            }
            case 93: {
                return "java.sql.Timestamp";
            }
        }
        return "java.lang.Object";
    }

    static void embedData(StringBuffer buf, Object value, boolean isUnicode, ConnectionJDBC3 connection) throws SQLException {
        DateTime dt;
        String tmp;
        buf.append(' ');
        if (value == null) {
            buf.append("NULL ");
            return;
        }
        if (value instanceof Blob) {
            Blob blob = (Blob)value;
            value = blob.getBytes(1L, (int)blob.length());
        } else if (value instanceof Clob) {
            Clob clob = (Clob)value;
            value = clob.getSubString(1L, (int)clob.length());
        }
        if (value instanceof DateTime) {
            buf.append('\'');
            buf.append(value);
            buf.append('\'');
        } else if (value instanceof byte[]) {
            byte[] bytes = (byte[])value;
            int len = bytes.length;
            if (len >= 0) {
                buf.append('0').append('x');
                if (len == 0) {
                    buf.append('0').append('0');
                } else {
                    for (int i = 0; i < len; ++i) {
                        int b1 = bytes[i] & 0xFF;
                        buf.append(hex[b1 >> 4]);
                        buf.append(hex[b1 & 0xF]);
                    }
                }
            }
        } else if (value instanceof String) {
            tmp = (String)value;
            int len = tmp.length();
            if (isUnicode) {
                buf.append('N');
            }
            buf.append('\'');
            for (int i = 0; i < len; ++i) {
                char c = tmp.charAt(i);
                if (c == '\'') {
                    buf.append('\'');
                }
                buf.append(c);
            }
            buf.append('\'');
        } else if (value instanceof Date) {
            dt = new DateTime((Date)value);
            buf.append('\'');
            buf.append(dt);
            buf.append('\'');
        } else if (value instanceof Time) {
            dt = new DateTime((Time)value);
            buf.append('\'');
            buf.append(dt);
            buf.append('\'');
        } else if (value instanceof Timestamp) {
            dt = new DateTime((Timestamp)value);
            buf.append('\'');
            buf.append(dt);
            buf.append('\'');
        } else if (value instanceof Boolean) {
            buf.append((Boolean)value != false ? (char)'1' : '0');
        } else if (value instanceof BigDecimal) {
            tmp = value.toString();
            int maxlen = connection.getMaxPrecision();
            if (tmp.charAt(0) == '-') {
                ++maxlen;
            }
            if (tmp.indexOf(46) >= 0) {
                ++maxlen;
            }
            if (tmp.length() > maxlen) {
                buf.append(tmp.substring(0, maxlen));
            } else {
                buf.append(tmp);
            }
        } else {
            buf.append(value.toString());
        }
        buf.append(' ');
    }

    static byte[] encodeString(String cs, String value) {
        try {
            return value.getBytes(cs);
        }
        catch (UnsupportedEncodingException e) {
            return value.getBytes();
        }
    }

    public static SQLWarning linkException(SQLWarning sqle, Throwable cause) {
        return (SQLWarning)Support.linkException((Exception)sqle, cause);
    }

    public static SQLException linkException(SQLException sqle, Throwable cause) {
        return (SQLException)Support.linkException((Exception)sqle, cause);
    }

    public static Throwable linkException(Exception exception, Throwable cause) {
        Class<?> exceptionClass = exception.getClass();
        Class[] parameterTypes = new Class[]{Throwable.class};
        Object[] arguments = new Object[]{cause};
        try {
            Method initCauseMethod = exceptionClass.getMethod("initCause", parameterTypes);
            initCauseMethod.invoke((Object)exception, arguments);
        }
        catch (NoSuchMethodException e) {
            log.error((Object)e);
        }
        catch (Exception e) {
            // empty catch block
        }
        return exception;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long timeToZone(java.util.Date value, Calendar target) {
        GregorianCalendar gregorianCalendar = cal;
        synchronized (gregorianCalendar) {
            long l;
            java.util.Date tmp = target.getTime();
            try {
                cal.setTime(value);
                target.set(11, cal.get(11));
                target.set(12, cal.get(12));
                target.set(13, cal.get(13));
                target.set(14, cal.get(14));
                target.set(1, cal.get(1));
                target.set(2, cal.get(2));
                target.set(5, cal.get(5));
                l = target.getTime().getTime();
                target.setTime(tmp);
            }
            catch (Throwable throwable) {
                target.setTime(tmp);
                throw throwable;
            }
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long timeFromZone(java.util.Date value, Calendar target) {
        GregorianCalendar gregorianCalendar = cal;
        synchronized (gregorianCalendar) {
            long l;
            java.util.Date tmp = target.getTime();
            try {
                target.setTime(value);
                cal.set(11, target.get(11));
                cal.set(12, target.get(12));
                cal.set(13, target.get(13));
                cal.set(14, target.get(14));
                cal.set(1, target.get(1));
                cal.set(2, target.get(2));
                cal.set(5, target.get(5));
                l = cal.getTime().getTime();
                target.setTime(tmp);
            }
            catch (Throwable throwable) {
                target.setTime(tmp);
                throw throwable;
            }
            return l;
        }
    }

    public static Object convertLOB(Object value) throws SQLException {
        if (value instanceof Clob) {
            Clob c = (Clob)value;
            return c.getSubString(1L, (int)c.length());
        }
        if (value instanceof Blob) {
            Blob b = (Blob)value;
            return b.getBytes(1L, (int)b.length());
        }
        return value;
    }

    public static int convertLOBType(int type) {
        switch (type) {
            case 2004: {
                return -4;
            }
            case 2005: {
                return -1;
            }
        }
        return type;
    }

    public static boolean isWindowsOS() {
        return System.getProperty("os.name").toLowerCase().startsWith("windows");
    }

    private static ConnectionJDBC3 getConnection(Object callerReference) {
        Connection connection;
        block6: {
            if (callerReference == null) {
                throw new IllegalArgumentException("callerReference cannot be null.");
            }
            try {
                if (callerReference instanceof Connection) {
                    connection = (Connection)callerReference;
                    break block6;
                }
                if (callerReference instanceof Statement) {
                    connection = ((Statement)callerReference).getConnection();
                    break block6;
                }
                if (callerReference instanceof ResultSet) {
                    connection = ((ResultSet)callerReference).getStatement().getConnection();
                    break block6;
                }
                throw new IllegalArgumentException("callerReference is invalid.");
            }
            catch (SQLException e) {
                throw new IllegalStateException(e.getMessage());
            }
        }
        return (ConnectionJDBC3)connection;
    }

    private Support() {
    }

    static {
        typeMap.put(Byte.class, new Integer(-6));
        typeMap.put(Short.class, new Integer(5));
        typeMap.put(Integer.class, new Integer(4));
        typeMap.put(Long.class, new Integer(-5));
        typeMap.put(Float.class, new Integer(7));
        typeMap.put(Double.class, new Integer(8));
        typeMap.put(BigDecimal.class, new Integer(3));
        typeMap.put(Boolean.class, new Integer(16));
        typeMap.put(byte[].class, new Integer(-3));
        typeMap.put(Date.class, new Integer(91));
        typeMap.put(Time.class, new Integer(92));
        typeMap.put(Timestamp.class, new Integer(93));
        typeMap.put(BlobImpl.class, new Integer(-4));
        typeMap.put(ClobImpl.class, new Integer(-1));
        typeMap.put(String.class, new Integer(12));
        typeMap.put(Blob.class, new Integer(-4));
        typeMap.put(Clob.class, new Integer(-1));
        hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        cal = new GregorianCalendar();
    }
}

