/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.jdbc;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class URLParser {
    public static final String TOKEN1 = "|";
    public static final String TOKEN2 = "&";
    public static final String TOKEN3 = "=";
    private String kettleUrl;
    private String[] options;

    public String getKettleUrl() {
        return this.kettleUrl;
    }

    public void setKettleUrl(String kettleUrl) {
        this.kettleUrl = kettleUrl;
    }

    public String[] getOptions() {
        return this.options;
    }

    public void setOptions(String[] options) {
        this.options = options;
    }

    public void parse(String url) {
        int index = url.indexOf(TOKEN1);
        if (index != -1) {
            this.kettleUrl = url.substring(0, index);
            if (url.length() > index + 1) {
                String tmp = url.substring(index + 1);
                StringTokenizer st = new StringTokenizer(tmp, TOKEN2);
                this.options = new String[st.countTokens()];
                int i = 0;
                while (st.hasMoreTokens()) {
                    String tmpStr = st.nextToken();
                    try {
                        tmpStr = URLDecoder.decode(tmpStr, "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new RuntimeException(e);
                    }
                    this.options[i] = tmpStr;
                    ++i;
                }
            }
        } else {
            this.kettleUrl = url;
        }
    }

    public static void main(String[] args) {
        String url = "a=1&b=2&c=3&d=4&e=5&f=6&g=7";
        long start = System.currentTimeMillis();
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(url, TOKEN2);
        System.out.println(st.countTokens());
        while (st.hasMoreTokens()) {
            list.add(st.nextToken());
        }
        long end = System.currentTimeMillis();
        System.out.println(end - start);
        start = System.currentTimeMillis();
        String tmp = url;
        list = new ArrayList();
        int index = tmp.indexOf(TOKEN2);
        while (index != -1) {
            list.add(tmp.substring(0, index));
            tmp = tmp.substring(index + 1);
            index = tmp.indexOf(TOKEN2);
        }
        end = System.currentTimeMillis();
        System.out.println(end - start);
    }
}

