/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core;

import java.util.Locale;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.DataFactoryContext;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.ResourceBundleFactory;
import org.pentaho.reporting.engine.classic.core.metadata.DataFactoryMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.DataFactoryRegistry;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public abstract class AbstractDataFactory
implements DataFactory,
Cloneable {
    private transient Configuration configuration;
    private transient ResourceManager resourceManager;
    private transient ResourceKey contextKey;
    private transient ResourceBundleFactory resourceBundleFactory;
    private transient DataFactoryContext dataFactoryContext;
    private transient Locale locale = Locale.getDefault();

    @Override
    public void cancelRunningQuery() {
    }

    protected int calculateQueryLimit(DataRow parameters) {
        Object queryLimit = parameters.get("::org.pentaho.reporting::query-limit");
        if (queryLimit instanceof Number) {
            Number i = (Number)queryLimit;
            return i.intValue();
        }
        return -1;
    }

    protected int calculateQueryTimeOut(DataRow parameters) {
        Object queryTimeOut = parameters.get("::org.pentaho.reporting::query-timeout");
        if (queryTimeOut instanceof Number) {
            Number i = (Number)queryTimeOut;
            return i.intValue();
        }
        return -1;
    }

    @Override
    public void initialize(DataFactoryContext dataFactoryContext) throws ReportDataFactoryException {
        if (dataFactoryContext == null) {
            throw new NullPointerException();
        }
        this.dataFactoryContext = dataFactoryContext;
        this.configuration = dataFactoryContext.getConfiguration();
        this.resourceBundleFactory = dataFactoryContext.getResourceBundleFactory();
        this.resourceManager = dataFactoryContext.getResourceManager();
        this.contextKey = dataFactoryContext.getContextKey();
        this.locale = this.resourceBundleFactory.getLocale();
        if (this.locale == null) {
            this.locale = Locale.getDefault();
        }
    }

    public Locale getLocale() {
        return this.locale;
    }

    public DataFactoryContext getDataFactoryContext() {
        return this.dataFactoryContext;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public ResourceManager getResourceManager() {
        if (this.resourceManager == null) {
            this.resourceManager = new ResourceManager();
        }
        return this.resourceManager;
    }

    public ResourceKey getContextKey() {
        return this.contextKey;
    }

    public ResourceBundleFactory getResourceBundleFactory() {
        return this.resourceBundleFactory;
    }

    @Override
    public DataFactory clone() {
        try {
            return (DataFactory)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public DataFactory derive() {
        return this.clone();
    }

    @Override
    public DataFactoryMetaData getMetaData() {
        return DataFactoryRegistry.getInstance().getMetaData(this.getClass().getName());
    }
}

