/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core;

import java.util.Enumeration;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.ClassicEngineCoreModule;
import org.pentaho.reporting.engine.classic.core.ClassicEngineInfo;
import org.pentaho.reporting.engine.classic.core.style.StyleKey;
import org.pentaho.reporting.libraries.base.boot.AbstractBoot;
import org.pentaho.reporting.libraries.base.boot.DefaultModuleInfo;
import org.pentaho.reporting.libraries.base.boot.ModuleInfo;
import org.pentaho.reporting.libraries.base.boot.PackageManager;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.config.HierarchicalConfiguration;
import org.pentaho.reporting.libraries.base.config.ModifiableConfiguration;
import org.pentaho.reporting.libraries.base.config.SystemPropertyConfiguration;
import org.pentaho.reporting.libraries.base.util.CSVTokenizer;
import org.pentaho.reporting.libraries.base.versioning.ProjectInformation;
import org.pentaho.reporting.libraries.xmlns.common.ParserUtil;

public class ClassicEngineBoot
extends AbstractBoot {
    public static final int VERSION_TRUNK = ClassicEngineBoot.computeVersionId(999, 999, 999);
    public static final int VERSION_3_8 = ClassicEngineBoot.computeVersionId(3, 8, 0);
    public static final int VERSION_3_9 = ClassicEngineBoot.computeVersionId(3, 9, 0);
    public static final int VERSION_4_0 = ClassicEngineBoot.computeVersionId(4, 0, 0);
    public static final String INDEX_COLUMN_PREFIX = "::column::";
    public static final String METADATA_NAMESPACE = "http://reporting.pentaho.org/namespaces/engine/classic/metadata/1.0";
    public static final String DATASCHEMA_NAMESPACE = "http://reporting.pentaho.org/namespaces/engine/classic/dataschema/1.0";
    public static final String BUNDLE_TYPE = "application/vnd.pentaho.reporting.classic";
    private static final Log logger = LogFactory.getLog(ClassicEngineBoot.class);
    private static ClassicEngineBoot instance;
    private ProjectInformation projectInfo = ClassicEngineInfo.getInstance();
    private static final UserConfigWrapper configWrapper;

    private ClassicEngineBoot() {
    }

    public static synchronized ClassicEngineBoot getInstance() {
        if (instance == null) {
            instance = new ClassicEngineBoot();
        }
        return instance;
    }

    public ModifiableConfiguration getEditableConfig() {
        return (ModifiableConfiguration)this.getGlobalConfig();
    }

    protected ProjectInformation getProjectInfo() {
        return this.projectInfo;
    }

    protected Configuration loadConfiguration() {
        HierarchicalConfiguration globalConfig = this.createDefaultHierarchicalConfiguration("/org/pentaho/reporting/engine/classic/core/classic-engine.properties", "/classic-engine.properties", false, ClassicEngineBoot.class);
        globalConfig.insertConfiguration((HierarchicalConfiguration)configWrapper);
        SystemPropertyConfiguration systemConfig = new SystemPropertyConfiguration();
        globalConfig.insertConfiguration((HierarchicalConfiguration)systemConfig);
        return globalConfig;
    }

    protected void performBoot() {
        if (!ClassicEngineBoot.isStrictFP()) {
            logger.warn((Object)"The used VM seems to use a non-strict floating point arithmetics");
            logger.warn((Object)"Layouts computed with this Java Virtual Maschine may be invalid.");
            logger.warn((Object)"JFreeReport and the library 'iText' depend on the strict floating point rules");
            logger.warn((Object)"of Java1.1 as implemented by the Sun Virtual Maschines.");
            logger.warn((Object)"If you are using the BEA JRockit VM, start the Java VM with the option");
            logger.warn((Object)"'-Xstrictfp' to restore the default behaviour.");
        }
        PackageManager mgr = this.getPackageManager();
        mgr.addModule(ClassicEngineCoreModule.class.getName());
        mgr.load("org.pentaho.reporting.engine.classic.core.modules.");
        mgr.load("org.pentaho.reporting.engine.classic.extensions.modules.");
        mgr.load("org.pentaho.reporting.engine.classic.extensions.datasources.");
        mgr.load("org.pentaho.reporting.engine.classic.core.userdefined.modules.");
        this.bootAdditionalModules();
        mgr.initializeModules();
        if (!mgr.isModuleAvailable(ClassicEngineCoreModule.class.getName())) {
            throw new IllegalStateException("Booting the report-engine failed.");
        }
        StyleKey.lock();
    }

    private void bootAdditionalModules() {
        try {
            String bootModules = this.getGlobalConfig().getConfigProperty("org.pentaho.reporting.engine.classic.core.boot.Modules");
            if (bootModules != null) {
                CSVTokenizer csvToken = new CSVTokenizer(bootModules, ",");
                while (csvToken.hasMoreTokens()) {
                    String token = csvToken.nextToken();
                    this.getPackageManager().load(token);
                }
            }
        }
        catch (SecurityException se) {
            logger.info((Object)"Security settings forbid to check the system properties for extension modules.");
        }
        catch (Exception se) {
            logger.error((Object)"An error occured while checking the system properties for extension modules.", (Throwable)se);
        }
    }

    private static boolean isStrictFP() {
        double d = 8.0E307;
        double result1 = Double.POSITIVE_INFINITY;
        double result2 = 1.6E308;
        return true;
    }

    public static Configuration getUserConfig() {
        return configWrapper.getWrappedConfiguration();
    }

    public static void setUserConfig(Configuration config) {
        configWrapper.setWrappedConfiguration(config);
    }

    public boolean isModuleAvailable(String moduleClass) {
        return this.getPackageManager().isModuleAvailable((ModuleInfo)new DefaultModuleInfo(moduleClass, null, null, null));
    }

    public static int parseVersionId(String text) {
        StringTokenizer strtok = new StringTokenizer(text, ".");
        if (strtok.countTokens() == 3) {
            int major = ParserUtil.parseInt((String)strtok.nextToken(), (int)-1);
            int minor = ParserUtil.parseInt((String)strtok.nextToken(), (int)-1);
            int patch = ParserUtil.parseInt((String)strtok.nextToken(), (int)-1);
            if (major == -1 || minor == -1 || patch == -1) {
                return -1;
            }
            return ClassicEngineBoot.computeVersionId(major, minor, patch);
        }
        return -1;
    }

    public static String printVersion(int versionId) {
        if (versionId <= 0 || versionId > 999000000) {
            return "TRUNK";
        }
        int patch = versionId % 1000;
        int minor = versionId / 1000 % 1000;
        int major = versionId / 1000000;
        return String.format("%d.%d.%d", major, minor, patch);
    }

    public static int computeCurrentVersionId() {
        int releasePatch;
        int releaseMinor;
        int releaseMajor = ParserUtil.parseInt((String)ClassicEngineInfo.getInstance().getReleaseMajor(), (int)999);
        int version = ClassicEngineBoot.computeVersionId(releaseMajor, releaseMinor = ParserUtil.parseInt((String)ClassicEngineInfo.getInstance().getReleaseMinor(), (int)999), releasePatch = ParserUtil.parseInt((String)ClassicEngineInfo.getInstance().getReleaseMilestone(), (int)999));
        if (version == 0) {
            return VERSION_TRUNK;
        }
        return version;
    }

    public static int computeVersionId(int prptVersionMajorRaw, int prptVersionMinorRaw, int prptVersionPatchRaw) {
        return prptVersionMajorRaw * 1000000 + prptVersionMinorRaw * 1000 + prptVersionPatchRaw;
    }

    public static VersionValidity isValidVersion(int prptVersionMajorRaw, int prptVersionMinorRaw, int prptVersionPatchRaw) {
        int releaseMajor = ParserUtil.parseInt((String)ClassicEngineInfo.getInstance().getReleaseMajor(), (int)-1);
        int releaseMinor = ParserUtil.parseInt((String)ClassicEngineInfo.getInstance().getReleaseMinor(), (int)-1);
        int releasePatch = ParserUtil.parseInt((String)ClassicEngineInfo.getInstance().getReleaseMilestone(), (int)-1);
        if (releaseMajor <= 0 || releaseMinor <= 0 || releasePatch <= 0) {
            return VersionValidity.VALID;
        }
        if (prptVersionMajorRaw * 1000 + prptVersionMinorRaw > releaseMajor * 1000 + releaseMinor) {
            return VersionValidity.INVALID_RELEASE;
        }
        if (prptVersionMajorRaw * 1000 + prptVersionMinorRaw == releaseMajor * 1000 + releaseMinor && prptVersionPatchRaw > releasePatch) {
            return VersionValidity.INVALID_PATCH;
        }
        return VersionValidity.VALID;
    }

    public static boolean isEnforceCompatibilityFor(int level, int prptVersionMajorRaw, int prptVersionMinorRaw) {
        return ClassicEngineBoot.isEnforceCompatibilityFor(level, prptVersionMajorRaw, prptVersionMinorRaw, 999);
    }

    public static boolean isEnforceCompatibilityFor(int level, int prptVersionMajorRaw, int prptVersionMinorRaw, int prptVersionPatchRaw) {
        if (level == -1) {
            return false;
        }
        return level <= ClassicEngineBoot.computeVersionId(prptVersionMajorRaw, prptVersionMinorRaw, prptVersionPatchRaw);
    }

    static {
        configWrapper = new UserConfigWrapper();
    }

    public static enum VersionValidity {
        VALID,
        INVALID_RELEASE,
        INVALID_PATCH;

    }

    private static class UserConfigWrapper
    extends HierarchicalConfiguration {
        private Configuration wrappedConfiguration;

        protected UserConfigWrapper() {
            this(null);
        }

        protected UserConfigWrapper(Configuration config) {
            this.wrappedConfiguration = config;
        }

        public void setWrappedConfiguration(Configuration wrappedConfiguration) {
            this.wrappedConfiguration = wrappedConfiguration;
        }

        public Configuration getWrappedConfiguration() {
            return this.wrappedConfiguration;
        }

        public String getConfigProperty(String key) {
            if (this.wrappedConfiguration == null) {
                return this.getParentConfig().getConfigProperty(key);
            }
            String retval = this.wrappedConfiguration.getConfigProperty(key);
            if (retval != null) {
                return retval;
            }
            return this.getParentConfig().getConfigProperty(key);
        }

        public String getConfigProperty(String key, String defaultValue) {
            if (this.wrappedConfiguration == null) {
                return this.getParentConfig().getConfigProperty(key, defaultValue);
            }
            String retval = this.wrappedConfiguration.getConfigProperty(key, null);
            if (retval != null) {
                return retval;
            }
            return this.getParentConfig().getConfigProperty(key, defaultValue);
        }

        public void setConfigProperty(String key, String value) {
            if (this.wrappedConfiguration instanceof ModifiableConfiguration) {
                ModifiableConfiguration modConfiguration = (ModifiableConfiguration)this.wrappedConfiguration;
                modConfiguration.setConfigProperty(key, value);
            }
        }

        public Enumeration<String> getConfigProperties() {
            if (this.wrappedConfiguration instanceof ModifiableConfiguration) {
                ModifiableConfiguration modConfiguration = (ModifiableConfiguration)this.wrappedConfiguration;
                return modConfiguration.getConfigProperties();
            }
            return super.getConfigProperties();
        }
    }
}

