/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.pentaho.reporting.engine.classic.core.CrosstabDetailMode;
import org.pentaho.reporting.engine.classic.core.CrosstabOtherGroupBody;
import org.pentaho.reporting.engine.classic.core.CrosstabRowGroupBody;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.Group;
import org.pentaho.reporting.engine.classic.core.GroupBody;
import org.pentaho.reporting.engine.classic.core.GroupFooter;
import org.pentaho.reporting.engine.classic.core.GroupHeader;
import org.pentaho.reporting.engine.classic.core.NoDataBand;
import org.pentaho.reporting.engine.classic.core.filter.types.bands.CrosstabGroupType;

public class CrosstabGroup
extends Group {
    private static final String[] EMPTY_FIELDS = new String[0];
    private GroupHeader header;
    private GroupFooter footer;
    private NoDataBand noDataBand;

    public CrosstabGroup() {
        this.init();
    }

    public CrosstabGroup(GroupBody body) {
        super(body);
        this.validateBody(body);
        this.init();
    }

    public CrosstabGroup(CrosstabRowGroupBody body) {
        super(body);
        this.init();
    }

    public CrosstabGroup(CrosstabOtherGroupBody body) {
        super(body);
        this.init();
    }

    private void init() {
        this.setElementType(new CrosstabGroupType());
        this.footer = new GroupFooter();
        this.header = new GroupHeader();
        this.noDataBand = new NoDataBand();
        this.registerAsChild(this.footer);
        this.registerAsChild(this.header);
        this.registerAsChild(this.noDataBand);
    }

    public GroupHeader getHeader() {
        return this.header;
    }

    public void setHeader(GroupHeader header) {
        if (header == null) {
            throw new NullPointerException("Header must not be null");
        }
        this.validateLooping(header);
        if (this.unregisterParent(header)) {
            return;
        }
        GroupHeader element = this.header;
        this.header.setParent(null);
        this.header = header;
        this.header.setParent(this);
        this.notifyNodeChildRemoved(element);
        this.notifyNodeChildAdded(this.header);
    }

    public GroupFooter getFooter() {
        return this.footer;
    }

    public void setFooter(GroupFooter footer) {
        if (footer == null) {
            throw new NullPointerException("The footer must not be null");
        }
        this.validateLooping(footer);
        if (this.unregisterParent(footer)) {
            return;
        }
        GroupFooter element = this.footer;
        this.footer.setParent(null);
        this.footer = footer;
        this.footer.setParent(this);
        this.notifyNodeChildRemoved(element);
        this.notifyNodeChildAdded(this.footer);
    }

    public NoDataBand getNoDataBand() {
        return this.noDataBand;
    }

    public void setNoDataBand(NoDataBand noDataBand) {
        if (noDataBand == null) {
            throw new NullPointerException("The noDataBand must not be null");
        }
        this.validateLooping(noDataBand);
        if (this.unregisterParent(noDataBand)) {
            return;
        }
        NoDataBand oldElement = this.noDataBand;
        this.noDataBand.setParent(null);
        this.noDataBand = noDataBand;
        this.noDataBand.setParent(this);
        this.notifyNodeChildRemoved(oldElement);
        this.notifyNodeChildAdded(this.noDataBand);
    }

    @Override
    protected GroupBody createDefaultBody() {
        return new CrosstabRowGroupBody();
    }

    @Override
    public boolean isGroupChange(DataRow dataRow) {
        return false;
    }

    @Override
    public void setBody(GroupBody body) {
        this.validateBody(body);
        super.setBody(body);
    }

    private void validateBody(GroupBody body) {
        if (!(body instanceof CrosstabRowGroupBody) && !(body instanceof CrosstabOtherGroupBody)) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public CrosstabGroup clone() {
        CrosstabGroup g = (CrosstabGroup)super.clone();
        g.footer = (GroupFooter)this.footer.clone();
        g.header = (GroupHeader)this.header.clone();
        g.registerAsChild(g.footer);
        g.registerAsChild(g.header);
        return g;
    }

    @Override
    public CrosstabGroup derive(boolean preserveElementInstanceIds) {
        CrosstabGroup g = (CrosstabGroup)super.derive(preserveElementInstanceIds);
        g.footer = (GroupFooter)this.footer.derive(preserveElementInstanceIds);
        g.header = (GroupHeader)this.header.derive(preserveElementInstanceIds);
        g.registerAsChild(g.footer);
        g.registerAsChild(g.header);
        return g;
    }

    @Override
    protected void removeElement(Element element) {
        if (element == null) {
            throw new NullPointerException();
        }
        if (this.footer == element) {
            this.footer.setParent(null);
            this.footer = new GroupFooter();
            this.footer.setParent(this);
            this.notifyNodeChildRemoved(element);
            this.notifyNodeChildAdded(this.footer);
        } else if (this.header == element) {
            this.header.setParent(null);
            this.header = new GroupHeader();
            this.header.setParent(this);
            this.notifyNodeChildRemoved(element);
            this.notifyNodeChildAdded(this.header);
        } else if (this.noDataBand == element) {
            this.noDataBand.setParent(null);
            this.noDataBand = new NoDataBand();
            this.noDataBand.setParent(this);
            this.notifyNodeChildRemoved(element);
            this.notifyNodeChildAdded(this.noDataBand);
        } else {
            super.removeElement(element);
        }
    }

    @Override
    public int getElementCount() {
        return 4;
    }

    @Override
    public Element getElement(int index) {
        switch (index) {
            case 0: {
                return this.header;
            }
            case 1: {
                return this.noDataBand;
            }
            case 2: {
                return this.getBody();
            }
            case 3: {
                return this.footer;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public void setElementAt(int index, Element element) {
        switch (index) {
            case 0: {
                this.setHeader((GroupHeader)element);
                break;
            }
            case 1: {
                this.setNoDataBand((NoDataBand)element);
                break;
            }
            case 2: {
                this.setBody((GroupBody)element);
                break;
            }
            case 3: {
                this.setFooter((GroupFooter)element);
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
    }

    public void setDetailsMode(CrosstabDetailMode mode) {
        this.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/crosstab", "detail-mode", (Object)mode);
    }

    public CrosstabDetailMode getDetailsMode() {
        return (CrosstabDetailMode)((Object)this.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/crosstab", "detail-mode"));
    }

    public Boolean getPrintDetailsHeader() {
        return (Boolean)this.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/crosstab", "print-detail-header");
    }

    public void setPrintDetailsHeader(Boolean printDetailsHeader) {
        this.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/crosstab", "print-detail-header", printDetailsHeader);
    }

    public Boolean getPrintColumnTitleHeader() {
        return (Boolean)this.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/crosstab", "print-column-title-header");
    }

    public void setPrintColumnTitleHeader(Boolean printColumnTitleHeader) {
        this.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/crosstab", "print-column-title-header", printColumnTitleHeader);
    }

    public void setPaddingFields(List<String> c) {
        if (c == null) {
            throw new NullPointerException();
        }
        String[] fields = c.toArray(new String[c.size()]);
        this.setPaddingFieldsArray(fields);
    }

    public void clearPaddingFields() {
        this.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/crosstab", "padding-fields", EMPTY_FIELDS);
    }

    public void addPaddingField(String name) {
        if (name == null) {
            throw new NullPointerException("Group.addField(...): name is null.");
        }
        ArrayList<String> fieldsList = new ArrayList<String>(this.getPaddingFields());
        fieldsList.add(name);
        Collections.sort(fieldsList);
        this.setPaddingFieldsArray(fieldsList.toArray(new String[fieldsList.size()]));
    }

    public List<String> getPaddingFields() {
        return Collections.unmodifiableList(Arrays.asList(this.getPaddingFieldsArray()));
    }

    public void setPaddingFieldsArray(String[] fields) {
        if (fields == null) {
            throw new NullPointerException();
        }
        this.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/crosstab", "padding-fields", fields.clone());
    }

    public String[] getPaddingFieldsArray() {
        Object o = this.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/crosstab", "padding-fields");
        if (o instanceof String[]) {
            String[] fields = (String[])o;
            return (String[])fields.clone();
        }
        return EMPTY_FIELDS;
    }
}

