/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.xmlns.common.AttributeMap;

public class ReportAttributeMap<T>
extends AttributeMap<T> {
    public static final ReportAttributeMap EMPTY_MAP = new ReportAttributeMap().createUnmodifiableMap();
    private static final Log logger = LogFactory.getLog(ReportAttributeMap.class);
    private long changeTracker;
    private boolean readOnly;

    public static <T> ReportAttributeMap<T> emptyMap() {
        return EMPTY_MAP;
    }

    public ReportAttributeMap() {
        this.changeTracker = 0L;
    }

    public ReportAttributeMap(long changeTracker) {
        this.changeTracker = changeTracker;
    }

    public ReportAttributeMap(ReportAttributeMap copy) {
        super((AttributeMap)copy);
        this.changeTracker = copy.changeTracker;
    }

    public ReportAttributeMap<T> createUnmodifiableMap() {
        try {
            ReportAttributeMap o = (ReportAttributeMap)super.clone();
            o.readOnly = true;
            return o;
        }
        catch (Exception e) {
            logger.error((Object)"Clone failed for ReportAttributeMap.createUnmodifiableMap", (Throwable)e);
            throw new IllegalStateException("Clone failed for ReportAttributeMap.createUnmodifiableMap");
        }
    }

    public ReportAttributeMap<T> clone() {
        return (ReportAttributeMap)super.clone();
    }

    public long getChangeTracker() {
        return this.changeTracker;
    }

    public T setAttribute(String namespace, String attribute, T value) {
        if (this.readOnly) {
            throw new UnsupportedOperationException("This collection is marked as read-only");
        }
        Object oldValue = super.setAttribute(namespace, attribute, value);
        if (oldValue == value) {
            return (T)oldValue;
        }
        if (!ObjectUtilities.equal((Object)oldValue, value)) {
            ++this.changeTracker;
        }
        return (T)oldValue;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void putAll(AttributeMap<T> attributeMap) {
        if (this.isReadOnly()) {
            throw new UnsupportedOperationException("This collection is marked as read-only");
        }
        super.putAll(attributeMap);
        ++this.changeTracker;
    }
}

