/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core;

import org.pentaho.reporting.engine.classic.core.CrosstabGroup;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.Group;
import org.pentaho.reporting.engine.classic.core.GroupBody;
import org.pentaho.reporting.engine.classic.core.RelationalGroup;
import org.pentaho.reporting.engine.classic.core.filter.types.bands.SubGroupBodyType;

public class SubGroupBody
extends GroupBody {
    private Group group;

    public SubGroupBody() {
        this.setElementType(new SubGroupBodyType());
        this.group = new RelationalGroup();
        this.registerAsChild(this.group);
    }

    public SubGroupBody(Group group) {
        this();
        this.setGroup(group);
    }

    public Group getGroup() {
        return this.group;
    }

    public void setGroup(Group group) {
        if (group == null) {
            throw new NullPointerException("The group must not be null");
        }
        if (!(group instanceof RelationalGroup) && !(group instanceof CrosstabGroup)) {
            throw new NullPointerException("The group must be one of relational-group or crosstab.");
        }
        this.validateLooping(group);
        if (this.unregisterParent(group)) {
            return;
        }
        Group oldGroup = this.group;
        this.group.setParent(null);
        this.group = group;
        this.group.setParent(this);
        this.notifyNodeChildRemoved(oldGroup);
        this.notifyNodeChildAdded(this.group);
    }

    @Override
    protected void removeElement(Element element) {
        if (element == null) {
            throw new NullPointerException();
        }
        if (element == this.group) {
            this.group.setParent(null);
            this.group = new RelationalGroup();
            this.group.setParent(this);
            this.notifyNodeChildRemoved(element);
            this.notifyNodeChildAdded(this.group);
        }
    }

    @Override
    public void setElementAt(int position, Element element) {
        if (position != 0) {
            throw new IndexOutOfBoundsException();
        }
        this.setGroup((Group)element);
    }

    @Override
    public int getElementCount() {
        return 1;
    }

    @Override
    public Element getElement(int index) {
        if (index == 0) {
            return this.group;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public SubGroupBody clone() {
        SubGroupBody o = (SubGroupBody)super.clone();
        o.group = this.group.clone();
        o.registerAsChild(o.group);
        return o;
    }

    @Override
    public SubGroupBody derive(boolean preserveElementInstanceIds) {
        SubGroupBody o = (SubGroupBody)super.derive(preserveElementInstanceIds);
        o.group = this.group.derive(preserveElementInstanceIds);
        o.registerAsChild(o.group);
        return o;
    }
}

