/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.cache;

import java.util.HashMap;
import javax.swing.table.TableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.AbstractDataFactory;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.CompoundDataFactory;
import org.pentaho.reporting.engine.classic.core.CompoundDataFactorySupport;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.DataFactoryContext;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.MetaTableModel;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.StaticDataRow;
import org.pentaho.reporting.engine.classic.core.cache.DataCache;
import org.pentaho.reporting.engine.classic.core.cache.DataCacheFactory;
import org.pentaho.reporting.engine.classic.core.cache.DataCacheKey;
import org.pentaho.reporting.engine.classic.core.cache.IndexedMetaTableModel;
import org.pentaho.reporting.engine.classic.core.cache.IndexedTableModel;
import org.pentaho.reporting.engine.classic.core.metadata.DataFactoryMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.MetaDataLookupException;
import org.pentaho.reporting.engine.classic.core.util.CloseableTableModel;
import org.pentaho.reporting.libraries.base.config.Configuration;

public class CachingDataFactory
extends AbstractDataFactory
implements CompoundDataFactorySupport {
    private static final Log logger = LogFactory.getLog(CachingDataFactory.class);
    private static final Object NULL_INDICATOR = new Object();
    private DataCache dataCache;
    private HashMap<DataCacheKey, TableModel> sessionCache;
    private CompoundDataFactory backend;
    private boolean closed;
    private boolean debugDataSources;
    private boolean profileDataSources;
    private boolean noClose;
    private static final String[] EMPTY_NAMES = new String[0];
    private Object lastKey;

    public CachingDataFactory(DataFactory backend, boolean dataCacheEnabled) {
        this(backend, false, dataCacheEnabled);
    }

    public CachingDataFactory(DataFactory backend, boolean noClose, boolean dataCacheEnabled) {
        if (backend == null) {
            throw new NullPointerException();
        }
        this.noClose = noClose;
        this.backend = noClose ? CompoundDataFactory.normalize(backend, false) : CompoundDataFactory.normalize(backend, true);
        Configuration configuration = ClassicEngineBoot.getInstance().getGlobalConfig();
        this.sessionCache = new HashMap();
        this.dataCache = dataCacheEnabled ? DataCacheFactory.getCache() : null;
        this.debugDataSources = "true".equals(configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.DebugDataSources"));
        this.profileDataSources = "true".equals(configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.ProfileDataSources"));
    }

    @Override
    public void initialize(DataFactoryContext dataFactoryContext) throws ReportDataFactoryException {
        super.initialize(dataFactoryContext);
        this.backend.initialize(dataFactoryContext);
    }

    @Override
    public boolean isQueryExecutable(String query, DataRow parameters) {
        if (query == null) {
            throw new NullPointerException();
        }
        if (parameters == null) {
            throw new NullPointerException();
        }
        return this.backend.isQueryExecutable(query, parameters);
    }

    @Override
    public boolean isFreeFormQueryExecutable(String query, DataRow parameter) {
        if (query == null) {
            throw new NullPointerException();
        }
        if (parameter == null) {
            throw new NullPointerException();
        }
        return this.backend.isFreeFormQueryExecutable(query, parameter);
    }

    @Override
    public TableModel queryStatic(String query, DataRow parameters) throws ReportDataFactoryException {
        if (query == null) {
            throw new NullPointerException();
        }
        if (parameters == null) {
            throw new NullPointerException();
        }
        DataCacheKey key = this.createCacheKey(query, parameters);
        if (key != null) {
            TableModel model = this.sessionCache.get(key);
            if (model == null) {
                model = this.dataCache.get(key);
            }
            if (model != null) {
                if (model instanceof MetaTableModel) {
                    return new IndexedMetaTableModel((MetaTableModel)model);
                }
                return new IndexedTableModel(model);
            }
        }
        if (!this.backend.isStaticQueryExecutable(query, parameters)) {
            throw new ReportDataFactoryException("The specified query '" + query + "' is not executable here.");
        }
        TableModel data = this.queryInternal(query, parameters, QueryStyle.Static);
        if (data == null) {
            return null;
        }
        if (key != null) {
            TableModel newData = this.dataCache.put(key, data);
            if (newData != data && data instanceof CloseableTableModel) {
                CloseableTableModel closeableTableModel = (CloseableTableModel)data;
                closeableTableModel.close();
            }
            this.sessionCache.put(key, newData);
            data = newData;
        }
        if (data instanceof MetaTableModel) {
            return new IndexedMetaTableModel((MetaTableModel)data);
        }
        return new IndexedTableModel(data);
    }

    @Override
    public TableModel queryFreeForm(String query, DataRow parameters) throws ReportDataFactoryException {
        if (query == null) {
            throw new NullPointerException();
        }
        if (parameters == null) {
            throw new NullPointerException();
        }
        DataCacheKey key = this.createCacheKey(query, parameters);
        if (key != null) {
            TableModel model = this.sessionCache.get(key);
            if (model == null) {
                model = this.dataCache.get(key);
            }
            if (model != null) {
                if (model instanceof MetaTableModel) {
                    return new IndexedMetaTableModel((MetaTableModel)model);
                }
                return new IndexedTableModel(model);
            }
        }
        if (!this.backend.isFreeFormQueryExecutable(query, parameters)) {
            throw new ReportDataFactoryException("The specified query '" + query + "' is not executable here.");
        }
        TableModel data = this.queryInternal(query, parameters, QueryStyle.FreeForm);
        if (data == null) {
            return null;
        }
        if (key != null) {
            TableModel newData = this.dataCache.put(key, data);
            if (newData != data && data instanceof CloseableTableModel) {
                CloseableTableModel closeableTableModel = (CloseableTableModel)data;
                closeableTableModel.close();
            }
            this.sessionCache.put(key, newData);
            data = newData;
        }
        if (data instanceof MetaTableModel) {
            return new IndexedMetaTableModel((MetaTableModel)data);
        }
        return new IndexedTableModel(data);
    }

    @Override
    public boolean isStaticQueryExecutable(String query, DataRow parameters) {
        if (query == null) {
            throw new NullPointerException();
        }
        if (parameters == null) {
            throw new NullPointerException();
        }
        return this.backend.isStaticQueryExecutable(query, parameters);
    }

    @Override
    public TableModel queryData(String query, DataRow parameters) throws ReportDataFactoryException {
        TableModel data;
        TableModel model;
        if (query == null) {
            throw new NullPointerException();
        }
        if (parameters == null) {
            throw new NullPointerException();
        }
        DataCacheKey key = this.createCacheKey(query, parameters);
        if (key != null && (model = this.dataCache.get(key)) != null) {
            if (model instanceof MetaTableModel) {
                return new IndexedMetaTableModel((MetaTableModel)model);
            }
            return new IndexedTableModel(model);
        }
        if (this.backend.isQueryExecutable(query, parameters) && (data = this.queryInternal(query, parameters, QueryStyle.General)) != null) {
            if (key != null) {
                TableModel newData = this.dataCache.put(key, data);
                if (newData != data && data instanceof CloseableTableModel) {
                    CloseableTableModel closeableTableModel = (CloseableTableModel)data;
                    closeableTableModel.close();
                }
                data = newData;
            }
            if (data instanceof MetaTableModel) {
                return new IndexedMetaTableModel((MetaTableModel)data);
            }
            return new IndexedTableModel(data);
        }
        throw new ReportDataFactoryException("The specified query '" + query + "' is not executable here.");
    }

    private DataCacheKey createCacheKey(String query, DataRow parameters) {
        try {
            DataCacheKey key;
            DataFactory dataFactoryForQuery = this.backend.getDataFactoryForQuery(query);
            if (dataFactoryForQuery != null && this.dataCache != null) {
                DataFactoryMetaData metaData = dataFactoryForQuery.getMetaData();
                String[] referencedFields = metaData.getReferencedFields(dataFactoryForQuery, query, parameters);
                if (referencedFields != null) {
                    Object queryHash = metaData.getQueryHash(dataFactoryForQuery, query, parameters);
                    if (queryHash == null) {
                        key = null;
                    } else {
                        key = new DataCacheKey();
                        for (int i = 0; i < referencedFields.length; ++i) {
                            String field = referencedFields[i];
                            key.addParameter(field, parameters.get(field));
                        }
                        key.addAttribute("QueryCache", queryHash);
                        key.makeReadOnly();
                    }
                } else {
                    key = null;
                }
            } else {
                key = null;
            }
            return key;
        }
        catch (MetaDataLookupException mle) {
            logger.error((Object)("Data-source used for query '" + query + "' does not provide metadata. Caching will be disabled."), (Throwable)mle);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TableModel queryInternal(String query, DataRow parameters, QueryStyle queryStyle) throws ReportDataFactoryException {
        if (this.profileDataSources && logger.isDebugEnabled()) {
            logger.debug((Object)(System.identityHashCode(Thread.currentThread()) + ": Query processing time: Starting"));
        }
        long startTime = System.currentTimeMillis();
        try {
            TableModel dataFromQuery;
            StaticDataRow params = new StaticDataRow(parameters);
            switch (queryStyle) {
                case FreeForm: {
                    dataFromQuery = this.backend.queryFreeForm(query, params);
                    break;
                }
                case Static: {
                    dataFromQuery = this.backend.queryStatic(query, params);
                    break;
                }
                case General: {
                    dataFromQuery = this.backend.queryData(query, params);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            if (dataFromQuery == null) {
                if (this.debugDataSources && logger.isDebugEnabled()) {
                    logger.debug((Object)("Query failed for query '" + query + '\''));
                }
                TableModel tableModel = null;
                return tableModel;
            }
            if (this.debugDataSources && logger.isDebugEnabled()) {
                CachingDataFactory.printTableModelContents(dataFromQuery);
            }
            TableModel tableModel = dataFromQuery;
            return tableModel;
        }
        finally {
            long queryTime = System.currentTimeMillis();
            if (this.profileDataSources && logger.isDebugEnabled()) {
                logger.debug((Object)(System.identityHashCode(Thread.currentThread()) + ": Query processing time: " + (double)(queryTime - startTime) / 1000.0));
            }
        }
    }

    @Override
    public void close() {
        if (!this.closed) {
            for (TableModel map : this.sessionCache.values()) {
                if (!(map instanceof CloseableTableModel)) continue;
                CloseableTableModel ct = (CloseableTableModel)map;
                ct.close();
            }
            this.sessionCache.clear();
            if (!this.noClose) {
                this.backend.close();
            }
            this.closed = true;
        }
    }

    @Override
    public DataFactory derive() {
        throw new UnsupportedOperationException("The CachingReportDataFactory cannot be derived.");
    }

    public static void printTableModelContents(TableModel mod) {
        if (mod == null) {
            throw new NullPointerException();
        }
        logger.debug((Object)("Tablemodel contains " + mod.getRowCount() + " rows."));
        for (int i = 0; i < mod.getColumnCount(); ++i) {
            logger.debug((Object)("Column: " + i + " Name = " + mod.getColumnName(i) + "; DataType = " + mod.getColumnClass(i)));
        }
        logger.debug((Object)"Checking the data inside");
        for (int rows = 0; rows < mod.getRowCount(); ++rows) {
            for (int i = 0; i < mod.getColumnCount(); ++i) {
                Object value = mod.getValueAt(rows, i);
                logger.debug((Object)("ValueAt (" + rows + ", " + i + ") is " + value));
            }
        }
    }

    @Override
    public String[] getQueryNames() {
        return EMPTY_NAMES;
    }

    @Override
    public void cancelRunningQuery() {
    }

    @Override
    public CachingDataFactory clone() {
        CachingDataFactory cdf = (CachingDataFactory)super.clone();
        cdf.backend = (CompoundDataFactory)this.backend.clone();
        cdf.sessionCache = (HashMap)this.sessionCache.clone();
        return cdf;
    }

    @Override
    public DataFactory getDataFactoryForQuery(String queryName, boolean freeform) {
        return this.backend.getDataFactoryForQuery(queryName, freeform);
    }

    private static enum QueryStyle {
        General,
        Static,
        FreeForm;

    }
}

