/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.designtime;

import java.io.File;
import java.util.Date;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ReportDefinition;
import org.pentaho.reporting.engine.classic.core.ResourceBundleFactory;
import org.pentaho.reporting.engine.classic.core.Section;
import org.pentaho.reporting.libraries.docbundle.DocumentMetaData;
import org.pentaho.reporting.libraries.docbundle.WriteableDocumentMetaData;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;

public class DesignTimeUtil {
    private DesignTimeUtil() {
    }

    public static File getContextAsFile(AbstractReportDefinition reportDefinition) {
        ResourceKey key = DesignTimeUtil.getContextKey(reportDefinition);
        return DesignTimeUtil.getContextAsFile(key);
    }

    public static File getContextAsFile(ResourceKey key) {
        while (key != null) {
            Object identifier = key.getIdentifier();
            if (identifier instanceof File) {
                return (File)identifier;
            }
            key = key.getParent();
        }
        return null;
    }

    public static ResourceKey getContextKey(AbstractReportDefinition reportDefinition) {
        AbstractReportDefinition e = reportDefinition;
        while (e != null) {
            ResourceKey base = e.getContentBase();
            if (base != null) {
                return base;
            }
            Section parentSection = e.getParentSection();
            if (parentSection != null) {
                ReportDefinition reportDefinition1 = parentSection.getReportDefinition();
                if (reportDefinition1 instanceof AbstractReportDefinition) {
                    e = (AbstractReportDefinition)reportDefinition1;
                    continue;
                }
                e = null;
                continue;
            }
            e = null;
        }
        return null;
    }

    public static ResourceBundleFactory getResourceBundleFactory(AbstractReportDefinition reportDefinition) {
        AbstractReportDefinition e = reportDefinition;
        while (e != null) {
            ResourceBundleFactory base = e.getResourceBundleFactory();
            if (base != null) {
                return base;
            }
            Section parentSection = e.getParentSection();
            if (parentSection != null) {
                ReportDefinition reportDefinition1 = parentSection.getReportDefinition();
                if (reportDefinition1 instanceof AbstractReportDefinition) {
                    e = (AbstractReportDefinition)reportDefinition1;
                    continue;
                }
                e = null;
                continue;
            }
            e = null;
        }
        return null;
    }

    public static MasterReport getMasterReport(Element element) {
        AbstractReportDefinition e = (AbstractReportDefinition)element.getReportDefinition();
        if (e instanceof MasterReport) {
            return (MasterReport)e;
        }
        while (e != null) {
            Section parentSection = e.getParentSection();
            if (parentSection != null) {
                ReportDefinition reportDefinition1 = parentSection.getReportDefinition();
                if (reportDefinition1 instanceof MasterReport) {
                    return (MasterReport)reportDefinition1;
                }
                if (reportDefinition1 instanceof AbstractReportDefinition) {
                    e = (AbstractReportDefinition)reportDefinition1;
                    continue;
                }
                e = null;
                continue;
            }
            e = null;
        }
        return null;
    }

    public static void resetTemplate(MasterReport report) {
        DesignTimeUtil.resetDocumentMetaData(report);
        report.setContentBase(null);
    }

    public static void resetDocumentMetaData(MasterReport report) {
        DocumentMetaData metaData = report.getBundle().getMetaData();
        if (metaData instanceof WriteableDocumentMetaData) {
            WriteableDocumentMetaData wmd = (WriteableDocumentMetaData)metaData;
            wmd.setBundleAttribute("urn:oasis:names:tc:opendocument:xmlns:meta:1.0", "initial-creator", wmd.getBundleAttribute("http://purl.org/dc/elements/1.1/", "creator"));
            try {
                wmd.setBundleAttribute("http://purl.org/dc/elements/1.1/", "creator", (Object)System.getProperty("user.name"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            wmd.setBundleAttribute("http://purl.org/dc/elements/1.1/", "description", null);
            wmd.setBundleAttribute("http://purl.org/dc/elements/1.1/", "subject", null);
            wmd.setBundleAttribute("http://purl.org/dc/elements/1.1/", "title", null);
            wmd.setBundleAttribute("urn:oasis:names:tc:opendocument:xmlns:meta:1.0", "creation-date", (Object)new Date());
            wmd.setBundleAttribute("urn:oasis:names:tc:opendocument:xmlns:meta:1.0", "keywords", null);
        }
    }
}

