/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.designtime.compat;

import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.CrosstabGroup;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.RootLevelBand;
import org.pentaho.reporting.engine.classic.core.Section;
import org.pentaho.reporting.engine.classic.core.SubReport;
import org.pentaho.reporting.engine.classic.core.designtime.compat.AbstractCompatibilityConverter;
import org.pentaho.reporting.engine.classic.core.metadata.ElementMetaData;
import org.pentaho.reporting.engine.classic.core.style.BandStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.ResolverStyleSheet;
import org.pentaho.reporting.engine.classic.core.style.resolver.SimpleStyleResolver;

public class LayoutCompatibility_5_0_Converter
extends AbstractCompatibilityConverter {
    private SimpleStyleResolver styleResolver = new SimpleStyleResolver(true);
    private ResolverStyleSheet resolverStyleSheet = new ResolverStyleSheet();

    @Override
    public int getTargetVersion() {
        return ClassicEngineBoot.computeVersionId(5, 0, 0);
    }

    private boolean isBlockLevelBox(Section s) {
        if (s == null) {
            return true;
        }
        this.styleResolver.resolve(s, this.resolverStyleSheet);
        Object layout = this.resolverStyleSheet.getStyleProperty(BandStyleKeys.LAYOUT);
        if ("block".equals(layout)) {
            return true;
        }
        if (layout == null || "auto".equals(layout)) {
            return this.isBlockLevelBox(s.getParent());
        }
        return false;
    }

    @Override
    public void inspectElement(ReportElement element) {
        Section parentSection;
        if (element.getMetaData().getReportElementType() == ElementMetaData.TypeClassification.CONTROL) {
            element.getStyle().setStyleProperty(BandStyleKeys.LAYOUT, null);
            element.setStyleExpression(BandStyleKeys.LAYOUT, null);
        }
        if (element instanceof CrosstabGroup) {
            CrosstabGroup g = (CrosstabGroup)element;
            g.setPrintDetailsHeader(false);
        }
        if (this.isBlockLevelBox(parentSection = element.getParentSection()) && element instanceof SubReport && parentSection instanceof RootLevelBand) {
            SubReport subReport = (SubReport)element;
            RootLevelBand rootLevelBand = (RootLevelBand)((Object)parentSection);
            for (SubReport r : rootLevelBand.getSubReports()) {
                if (r != subReport) continue;
                subReport.getStyle().setStyleProperty(ElementStyleKeys.MIN_WIDTH, null);
                subReport.getStyle().setStyleProperty(ElementStyleKeys.MIN_HEIGHT, null);
                subReport.getStyle().setStyleProperty(ElementStyleKeys.MAX_WIDTH, null);
                subReport.getStyle().setStyleProperty(ElementStyleKeys.MAX_HEIGHT, null);
                subReport.getStyle().setStyleProperty(ElementStyleKeys.WIDTH, null);
                subReport.getStyle().setStyleProperty(ElementStyleKeys.HEIGHT, null);
                subReport.getStyle().setStyleProperty(ElementStyleKeys.AVOID_PAGEBREAK_INSIDE, null);
            }
        }
    }
}

