/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.designtime.datafactory;

import javax.swing.JList;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.pentaho.reporting.engine.classic.core.designtime.datafactory.DataSetQuery;
import org.pentaho.reporting.engine.classic.core.designtime.datafactory.NamedQueryModel;

public class QuerySelectedHandler<T>
implements ListSelectionListener,
ListDataListener {
    private NamedQueryModel<T> queries;
    private JList queryNameList;

    public QuerySelectedHandler(NamedQueryModel<T> queries, JList queryNameList) {
        if (queryNameList == null) {
            throw new NullPointerException();
        }
        if (queries == null) {
            throw new NullPointerException();
        }
        this.queries = queries;
        this.queryNameList = queryNameList;
        this.queryNameList.addListSelectionListener(this);
        this.queries.getQueries().addListDataListener(this);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        DataSetQuery selectedValue = (DataSetQuery)this.queryNameList.getSelectedValue();
        this.queries.setSelectedDataSetQuery(selectedValue);
    }

    @Override
    public void intervalAdded(ListDataEvent e) {
    }

    @Override
    public void intervalRemoved(ListDataEvent e) {
    }

    @Override
    public void contentsChanged(ListDataEvent e) {
        Object selectedValueInList = this.queryNameList.getSelectedValue();
        Object selectedItem = this.queries.getQueries().getSelectedItem();
        if (selectedItem == selectedValueInList) {
            return;
        }
        if (selectedItem == null) {
            this.queryNameList.clearSelection();
        } else {
            this.queryNameList.setSelectedValue(selectedItem, true);
        }
    }
}

