/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.elementfactory;

import java.util.ArrayList;
import java.util.Locale;
import org.pentaho.reporting.engine.classic.core.CrosstabCell;
import org.pentaho.reporting.engine.classic.core.CrosstabCellBody;
import org.pentaho.reporting.engine.classic.core.CrosstabColumnGroup;
import org.pentaho.reporting.engine.classic.core.CrosstabColumnGroupBody;
import org.pentaho.reporting.engine.classic.core.CrosstabGroup;
import org.pentaho.reporting.engine.classic.core.CrosstabOtherGroup;
import org.pentaho.reporting.engine.classic.core.CrosstabOtherGroupBody;
import org.pentaho.reporting.engine.classic.core.CrosstabRowGroup;
import org.pentaho.reporting.engine.classic.core.CrosstabRowGroupBody;
import org.pentaho.reporting.engine.classic.core.DetailsHeader;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.GroupBody;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.designtime.DesignTimeDataSchemaModel;
import org.pentaho.reporting.engine.classic.core.elementfactory.CrosstabDetail;
import org.pentaho.reporting.engine.classic.core.elementfactory.CrosstabDimension;
import org.pentaho.reporting.engine.classic.core.filter.types.LabelType;
import org.pentaho.reporting.engine.classic.core.filter.types.NumberFieldType;
import org.pentaho.reporting.engine.classic.core.filter.types.TextFieldType;
import org.pentaho.reporting.engine.classic.core.metadata.ElementType;
import org.pentaho.reporting.engine.classic.core.style.BandStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.wizard.AutoGeneratorUtility;
import org.pentaho.reporting.engine.classic.core.wizard.DataAttributeContext;
import org.pentaho.reporting.engine.classic.core.wizard.DataAttributes;
import org.pentaho.reporting.libraries.base.util.StringUtils;

public class CrosstabBuilder {
    private ArrayList<CrosstabDimension> rows = new ArrayList();
    private ArrayList<CrosstabDimension> columns = new ArrayList();
    private ArrayList<String> others = new ArrayList();
    private ArrayList<CrosstabDetail> details = new ArrayList();
    private DesignTimeDataSchemaModel dataSchemaModel;
    private String groupNamePrefix;
    private Float minimumWidth;
    private Float minimumHeight;
    private Float maximumWidth;
    private Float maximumHeight;
    private Float prefWidth;
    private Float prefHeight;
    private Boolean allowMetaDataStyling;
    private Boolean allowMetaDataAttributes;

    public CrosstabBuilder(DesignTimeDataSchemaModel dataSchemaModel) {
        this.dataSchemaModel = dataSchemaModel;
        this.groupNamePrefix = "";
        this.minimumHeight = Float.valueOf(20.0f);
        this.maximumHeight = Float.valueOf(20.0f);
        this.maximumWidth = Float.valueOf(80.0f);
        this.minimumWidth = Float.valueOf(80.0f);
    }

    public Float getMinimumWidth() {
        return this.minimumWidth;
    }

    public void setMinimumWidth(Float minimumWidth) {
        this.minimumWidth = minimumWidth;
    }

    public Float getMinimumHeight() {
        return this.minimumHeight;
    }

    public void setMinimumHeight(Float minimumHeight) {
        this.minimumHeight = minimumHeight;
    }

    public Float getMaximumWidth() {
        return this.maximumWidth;
    }

    public void setMaximumWidth(Float maximumWidth) {
        this.maximumWidth = maximumWidth;
    }

    public Float getMaximumHeight() {
        return this.maximumHeight;
    }

    public void setMaximumHeight(Float maximumHeight) {
        this.maximumHeight = maximumHeight;
    }

    public Float getPrefWidth() {
        return this.prefWidth;
    }

    public void setPrefWidth(Float prefWidth) {
        this.prefWidth = prefWidth;
    }

    public Float getPrefHeight() {
        return this.prefHeight;
    }

    public void setPrefHeight(Float prefHeight) {
        this.prefHeight = prefHeight;
    }

    public Boolean getAllowMetaDataStyling() {
        return this.allowMetaDataStyling;
    }

    public void setAllowMetaDataStyling(Boolean allowMetaDataStyling) {
        this.allowMetaDataStyling = allowMetaDataStyling;
    }

    public Boolean getAllowMetaDataAttributes() {
        return this.allowMetaDataAttributes;
    }

    public void setAllowMetaDataAttributes(Boolean allowMetaDataAttributes) {
        this.allowMetaDataAttributes = allowMetaDataAttributes;
    }

    public String getGroupNamePrefix() {
        return this.groupNamePrefix;
    }

    public void setGroupNamePrefix(String groupNamePrefix) {
        this.groupNamePrefix = groupNamePrefix;
    }

    public void addOtherDimension(String field) {
        this.others.add(field);
    }

    public void addRowDimension(CrosstabDimension dimension) {
        this.rows.add(dimension);
    }

    public void addRowDimension(String field) {
        this.addRowDimension(new CrosstabDimension(field, field, false, "Summary"));
    }

    public void addRowDimension(String field, boolean addSummary) {
        this.addRowDimension(new CrosstabDimension(field, field, addSummary, "Summary"));
    }

    public void addColumnDimension(CrosstabDimension dimension) {
        this.columns.add(dimension);
    }

    public void addColumnDimension(String field) {
        this.addColumnDimension(new CrosstabDimension(field, field, false, "Summary"));
    }

    public void addColumnDimension(String field, boolean addSummary) {
        this.addColumnDimension(new CrosstabDimension(field, field, addSummary, "Summary"));
    }

    public void addDetails(CrosstabDetail detail) {
        this.details.add(detail);
    }

    public void addDetails(String field, Class aggregation) {
        this.details.add(new CrosstabDetail(field, field, aggregation));
    }

    public MasterReport createReport() {
        MasterReport report = new MasterReport();
        report.setRootGroup(this.create());
        return report;
    }

    public CrosstabGroup create() {
        if (this.columns.size() == 0) {
            throw new IllegalStateException();
        }
        if (this.rows.size() == 0) {
            throw new IllegalStateException();
        }
        CrosstabCellBody cellBody = new CrosstabCellBody();
        cellBody.addElement(this.createDetailsCell());
        this.setupDetailsHeader(cellBody.getHeader());
        GroupBody body = this.createColumnGroups(cellBody);
        body = this.createRowGroups(cellBody, body);
        body = this.createOtherGroups(body);
        return new CrosstabGroup(body);
    }

    private GroupBody createOtherGroups(GroupBody body) {
        for (int other = this.others.size() - 1; other >= 0; --other) {
            String column = this.others.get(other);
            CrosstabOtherGroup columnGroup = new CrosstabOtherGroup(body);
            columnGroup.setField(column);
            columnGroup.getHeader().addElement(this.createFieldItem(column));
            body = new CrosstabOtherGroupBody(columnGroup);
        }
        return body;
    }

    private GroupBody createRowGroups(CrosstabCellBody cellBody, GroupBody body) {
        for (int row = this.rows.size() - 1; row >= 0; --row) {
            CrosstabDimension rowDimension = this.rows.get(row);
            CrosstabRowGroup rowGroup = new CrosstabRowGroup(body);
            rowGroup.setName(this.groupNamePrefix + rowDimension.getField());
            rowGroup.setField(rowDimension.getField());
            rowGroup.getTitleHeader().getStyle().setStyleProperty(ElementStyleKeys.MIN_HEIGHT, Float.valueOf(-100.0f));
            rowGroup.getTitleHeader().addElement(this.createLabel(rowDimension.getTitle(), rowDimension.getField()));
            rowGroup.getHeader().getStyle().setStyleProperty(ElementStyleKeys.MIN_HEIGHT, Float.valueOf(-100.0f));
            rowGroup.getHeader().addElement(this.createFieldItem(rowDimension.getField()));
            rowGroup.getSummaryHeader().getStyle().setStyleProperty(ElementStyleKeys.MIN_HEIGHT, Float.valueOf(-100.0f));
            rowGroup.getSummaryHeader().addElement(this.createLabel(rowDimension.getSummaryTitle(), null));
            rowGroup.setPrintSummary(rowDimension.isPrintSummary());
            if (rowDimension.isPrintSummary()) {
                CrosstabCell cell = this.createDetailsCell();
                cell.setRowField(rowDimension.getField());
                cell.setName(rowDimension.getField());
                cellBody.addElement(cell);
                for (int col = this.columns.size() - 1; col >= 0; --col) {
                    CrosstabDimension column = this.columns.get(col);
                    if (!column.isPrintSummary()) continue;
                    CrosstabCell crosstabCell = this.createDetailsCell();
                    crosstabCell.setColumnField(column.getField());
                    crosstabCell.setRowField(rowDimension.getField());
                    crosstabCell.setName(column.getField() + "," + rowGroup.getField());
                    cellBody.addElement(crosstabCell);
                }
            }
            body = new CrosstabRowGroupBody(rowGroup);
        }
        return body;
    }

    private GroupBody createColumnGroups(CrosstabCellBody cellBody) {
        GroupBody body = cellBody;
        for (int col = this.columns.size() - 1; col >= 0; --col) {
            CrosstabDimension column = this.columns.get(col);
            CrosstabColumnGroup columnGroup = new CrosstabColumnGroup(body);
            columnGroup.setName(this.groupNamePrefix + column.getField());
            columnGroup.setField(column.getField());
            columnGroup.getTitleHeader().getStyle().setStyleProperty(ElementStyleKeys.MIN_HEIGHT, Float.valueOf(-100.0f));
            columnGroup.getTitleHeader().addElement(this.createLabel(column.getTitle(), column.getField()));
            columnGroup.getHeader().getStyle().setStyleProperty(ElementStyleKeys.MIN_HEIGHT, Float.valueOf(-100.0f));
            columnGroup.getHeader().addElement(this.createFieldItem(column.getField()));
            columnGroup.getSummaryHeader().getStyle().setStyleProperty(ElementStyleKeys.MIN_HEIGHT, Float.valueOf(-100.0f));
            columnGroup.getSummaryHeader().addElement(this.createLabel(column.getSummaryTitle(), null));
            columnGroup.setPrintSummary(column.isPrintSummary());
            if (column.isPrintSummary()) {
                CrosstabCell cell = this.createDetailsCell();
                cell.setColumnField(column.getField());
                cell.setName(column.getField());
                cellBody.addElement(cell);
            }
            body = new CrosstabColumnGroupBody(columnGroup);
        }
        return body;
    }

    private CrosstabCell createDetailsCell() {
        CrosstabCell cell = new CrosstabCell();
        cell.getStyle().setStyleProperty(ElementStyleKeys.MIN_HEIGHT, Float.valueOf(-100.0f));
        cell.getStyle().setStyleProperty(BandStyleKeys.LAYOUT, "row");
        for (int i = 0; i < this.details.size(); ++i) {
            CrosstabDetail crosstabDetail = this.details.get(i);
            cell.addElement(this.createFieldItem(crosstabDetail.getField(), crosstabDetail.getAggregation(), true));
        }
        return cell;
    }

    private void setupDetailsHeader(DetailsHeader cell) {
        cell.getStyle().setStyleProperty(ElementStyleKeys.MIN_HEIGHT, Float.valueOf(-100.0f));
        cell.getStyle().setStyleProperty(BandStyleKeys.LAYOUT, "row");
        for (int i = 0; i < this.details.size(); ++i) {
            CrosstabDetail crosstabDetail = this.details.get(i);
            String title = crosstabDetail.getTitle();
            if (StringUtils.isEmpty((String)title)) {
                title = crosstabDetail.getField();
            }
            cell.addElement(this.createLabel(title, crosstabDetail.getField(), true));
        }
    }

    private Element createFieldItem(String text) {
        return this.createFieldItem(text, null, false);
    }

    private Element createFieldItem(String fieldName, Class aggregationType, boolean split) {
        ElementType targetType;
        if (this.dataSchemaModel != null) {
            DataAttributeContext context = this.dataSchemaModel.getDataAttributeContext();
            DataAttributes attributes = this.dataSchemaModel.getDataSchema().getAttributes(fieldName);
            targetType = AutoGeneratorUtility.createFieldType(attributes, context);
        } else {
            targetType = TextFieldType.INSTANCE;
        }
        Element element = new Element();
        element.setElementType(targetType);
        element.getElementType().configureDesignTimeDefaults(element, Locale.getDefault());
        if (targetType instanceof NumberFieldType) {
            element.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "format-string", "0.00;-0.00");
        }
        element.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "field", fieldName);
        element.getStyle().setStyleProperty(ElementStyleKeys.MIN_WIDTH, this.split(split, this.minimumWidth));
        element.getStyle().setStyleProperty(ElementStyleKeys.MIN_HEIGHT, this.minimumHeight);
        element.getStyle().setStyleProperty(ElementStyleKeys.WIDTH, this.split(split, this.prefWidth));
        element.getStyle().setStyleProperty(ElementStyleKeys.HEIGHT, this.prefHeight);
        element.getStyle().setStyleProperty(ElementStyleKeys.MAX_WIDTH, this.split(split, this.maximumWidth));
        element.getStyle().setStyleProperty(ElementStyleKeys.MAX_HEIGHT, this.maximumHeight);
        element.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "aggregation-type", aggregationType);
        element.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "allow-metadata-styling", this.allowMetaDataStyling);
        return element;
    }

    private Element createLabel(String text, String labelFor) {
        return this.createLabel(text, labelFor, false);
    }

    private Element createLabel(String text, String labelFor, boolean splitArea) {
        Element element = new Element();
        element.setElementType(LabelType.INSTANCE);
        element.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "value", text);
        element.getStyle().setStyleProperty(ElementStyleKeys.MIN_WIDTH, this.split(splitArea, this.minimumWidth));
        element.getStyle().setStyleProperty(ElementStyleKeys.MIN_HEIGHT, this.minimumHeight);
        element.getStyle().setStyleProperty(ElementStyleKeys.WIDTH, this.split(splitArea, this.prefWidth));
        element.getStyle().setStyleProperty(ElementStyleKeys.HEIGHT, this.prefHeight);
        element.getStyle().setStyleProperty(ElementStyleKeys.MAX_WIDTH, this.split(splitArea, this.maximumWidth));
        element.getStyle().setStyleProperty(ElementStyleKeys.MAX_HEIGHT, this.maximumHeight);
        element.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "allow-metadata-styling", this.allowMetaDataStyling);
        if (StringUtils.isEmpty((String)labelFor)) {
            element.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "allow-metadata-attributes", this.allowMetaDataAttributes);
        } else {
            element.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "allow-metadata-attributes", true);
        }
        element.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "label-for", labelFor);
        return element;
    }

    private Float split(boolean split, Float value) {
        if (!split) {
            return value;
        }
        if (value == null) {
            return null;
        }
        float f = value.floatValue();
        return Float.valueOf(f / (float)Math.max(1, this.details.size()));
    }
}

