/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.filter;

import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.ResourceBundleFactory;
import org.pentaho.reporting.engine.classic.core.filter.DataSource;
import org.pentaho.reporting.engine.classic.core.filter.MessageFormatSupport;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class ResourceMessageFormatFilter
implements DataSource {
    private static final Log logger = LogFactory.getLog(ResourceMessageFormatFilter.class);
    private transient String appliedFormatKey;
    private String formatKey;
    private String resourceIdentifier;
    private MessageFormatSupport messageFormatSupport = new MessageFormatSupport();

    @Override
    public Object getValue(ExpressionRuntime runtime, ReportElement element) {
        if (runtime == null) {
            return null;
        }
        String resourceId = this.resourceIdentifier != null ? this.resourceIdentifier : runtime.getConfiguration().getConfigProperty("org.pentaho.reporting.engine.classic.core.ResourceBundle");
        if (resourceId == null) {
            return null;
        }
        try {
            ResourceBundleFactory resourceBundleFactory = runtime.getResourceBundleFactory();
            ResourceBundle bundle = resourceBundleFactory.getResourceBundle(resourceId);
            if (!ObjectUtilities.equal((Object)this.formatKey, (Object)this.appliedFormatKey)) {
                String newFormatString = bundle.getString(this.formatKey);
                this.messageFormatSupport.setFormatString(newFormatString);
                this.appliedFormatKey = this.formatKey;
            }
            this.messageFormatSupport.setLocale(resourceBundleFactory.getLocale());
            return this.messageFormatSupport.performFormat(runtime.getDataRow());
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Failed to format the value for resource-id " + resourceId), (Throwable)e);
            }
            return null;
        }
    }

    public String getResourceIdentifier() {
        return this.resourceIdentifier;
    }

    public void setResourceIdentifier(String resourceIdentifier) {
        this.resourceIdentifier = resourceIdentifier;
    }

    public void setFormatKey(String format) {
        this.formatKey = format;
    }

    public String getFormatKey() {
        return this.formatKey;
    }

    @Override
    public ResourceMessageFormatFilter clone() throws CloneNotSupportedException {
        ResourceMessageFormatFilter mf = (ResourceMessageFormatFilter)super.clone();
        mf.messageFormatSupport = (MessageFormatSupport)this.messageFormatSupport.clone();
        return mf;
    }

    public String getNullString() {
        return this.messageFormatSupport.getNullString();
    }

    public void setNullString(String nullString) {
        this.messageFormatSupport.setNullString(nullString);
    }
}

