/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.filter.types;

import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.filter.types.ContentType;
import org.pentaho.reporting.engine.classic.core.filter.types.ElementTypeUtils;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;

public class ContentFieldType
extends ContentType {
    public ContentFieldType() {
        super("content-field");
    }

    protected ContentFieldType(String id) {
        super(id);
    }

    @Override
    public Object getDesignValue(ExpressionRuntime runtime, ReportElement element) {
        Object staticValue = ElementTypeUtils.queryStaticValue(element);
        if (staticValue != null) {
            return staticValue;
        }
        return ElementTypeUtils.queryFieldName(element);
    }

    @Override
    public Object getValue(ExpressionRuntime runtime, ReportElement element) {
        Object filteredValue;
        if (runtime == null) {
            throw new NullPointerException("Runtime must never be null.");
        }
        if (element == null) {
            throw new NullPointerException("Element must never be null.");
        }
        Object value = ElementTypeUtils.queryFieldOrValue(runtime, element);
        if (value != null && (filteredValue = this.filter(runtime, element, value)) != null) {
            return filteredValue;
        }
        Object nullValue = element.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "null-value");
        return this.filter(runtime, element, nullValue);
    }
}

