/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.function;

import java.math.BigDecimal;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.event.ReportEvent;
import org.pentaho.reporting.engine.classic.core.function.AbstractFunction;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.function.ExpressionUtilities;
import org.pentaho.reporting.engine.classic.core.function.FieldAggregationFunction;
import org.pentaho.reporting.engine.classic.core.function.FunctionUtilities;
import org.pentaho.reporting.engine.classic.core.util.Sequence;

public class ItemAvgFunction
extends AbstractFunction
implements FieldAggregationFunction {
    private static final Log logger = LogFactory.getLog(ItemAvgFunction.class);
    private static final BigDecimal ONE = new BigDecimal(1.0);
    private Sequence<BigDecimal> sum = new Sequence();
    private Sequence<BigDecimal> itemCount = new Sequence();
    private transient int lastGroupSequenceNumber;
    private String group;
    private String field;
    private int scale = 14;
    private int roundingMode = 4;
    private String crosstabFilterGroup;

    public ItemAvgFunction() {
    }

    public ItemAvgFunction(String name) {
        this();
        this.setName(name);
    }

    @Override
    public void reportInitialized(ReportEvent event) {
        this.clear();
    }

    private void clear() {
        this.sum.clear();
        this.itemCount.clear();
        this.lastGroupSequenceNumber = 0;
    }

    @Override
    public void groupStarted(ReportEvent event) {
        if (FunctionUtilities.isDefinedGroup(this.getGroup(), event)) {
            this.clear();
        }
        if (FunctionUtilities.isDefinedGroup(this.getCrosstabFilterGroup(), event)) {
            int groupIndex = event.getState().getCurrentGroupIndex();
            this.lastGroupSequenceNumber = (int)event.getState().getCrosstabColumnSequenceCounter(groupIndex);
        }
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public void setGroup(String name) {
        this.group = name;
    }

    @Override
    public String getField() {
        return this.field;
    }

    @Override
    public void setField(String field) {
        this.field = field;
    }

    public int getRoundingMode() {
        return this.roundingMode;
    }

    public void setRoundingMode(int roundingMode) {
        this.roundingMode = roundingMode;
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    @Override
    public void itemsAdvanced(ReportEvent event) {
        Object fieldValue = event.getDataRow().get(this.getField());
        if (!(fieldValue instanceof Number)) {
            return;
        }
        try {
            Number n = (Number)fieldValue;
            BigDecimal number = ExpressionUtilities.convertToBigDecimal(n);
            BigDecimal oldSum = this.sum.get(this.lastGroupSequenceNumber);
            if (oldSum == null) {
                this.sum.set(this.lastGroupSequenceNumber, number);
            } else {
                this.sum.set(this.lastGroupSequenceNumber, oldSum.add(number));
            }
            BigDecimal oldValue = this.itemCount.get(this.lastGroupSequenceNumber);
            if (oldValue == null) {
                this.itemCount.set(this.lastGroupSequenceNumber, ONE);
            } else {
                this.itemCount.set(this.lastGroupSequenceNumber, oldValue.add(ONE));
            }
        }
        catch (Exception e) {
            logger.error((Object)"ItemAvgFunction.advanceItems(): problem adding number.");
        }
    }

    @Override
    public void summaryRowSelection(ReportEvent event) {
        if (FunctionUtilities.isDefinedGroup(this.getCrosstabFilterGroup(), event)) {
            int groupIndex = event.getState().getCurrentGroupIndex();
            this.lastGroupSequenceNumber = (int)event.getState().getCrosstabColumnSequenceCounter(groupIndex);
        }
    }

    @Override
    public Object getValue() {
        BigDecimal count = this.itemCount.get(this.lastGroupSequenceNumber);
        if (count == null) {
            return null;
        }
        BigDecimal sum = this.sum.get(this.lastGroupSequenceNumber);
        if (sum == null) {
            return null;
        }
        if (count.longValue() == 0L) {
            return null;
        }
        return sum.divide(count, this.scale, this.roundingMode);
    }

    @Override
    public Expression getInstance() {
        ItemAvgFunction function = (ItemAvgFunction)super.getInstance();
        function.sum.clone();
        function.itemCount.clone();
        function.lastGroupSequenceNumber = 0;
        return function;
    }

    @Override
    public Object clone() {
        try {
            ItemAvgFunction clone = (ItemAvgFunction)super.clone();
            clone.sum.clone();
            clone.itemCount.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException();
        }
    }

    @Override
    public String getCrosstabFilterGroup() {
        return this.crosstabFilterGroup;
    }

    @Override
    public void setCrosstabFilterGroup(String crosstabFilterGroup) {
        this.crosstabFilterGroup = crosstabFilterGroup;
    }
}

