/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.function;

import java.io.IOException;
import java.io.ObjectInputStream;
import org.pentaho.reporting.engine.classic.core.event.PageEventListener;
import org.pentaho.reporting.engine.classic.core.event.ReportEvent;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.function.FunctionUtilities;
import org.pentaho.reporting.engine.classic.core.function.PageGroupValues;
import org.pentaho.reporting.engine.classic.core.function.TotalGroupSumFunction;

public class TotalPageSumFunction
extends TotalGroupSumFunction
implements PageEventListener {
    private transient PageGroupValues values = new PageGroupValues();
    private int pageIndex = 0;

    @Override
    protected boolean isPrepareRunLevel(ReportEvent event) {
        return event.getState().isPrepareRun() && event.getState().getLevel() == -2;
    }

    @Override
    public void groupFinished(ReportEvent event) {
        if (FunctionUtilities.isDefinedGroup(this.getGroup(), event)) {
            this.storeValue(event);
        }
    }

    @Override
    public void pageStarted(ReportEvent event) {
        ++this.pageIndex;
        this.clear();
    }

    @Override
    public void pageFinished(ReportEvent event) {
        this.storeValue(event);
    }

    @Override
    public Object getValue() {
        return this.values.get(this.pageIndex, this.currentGroupKey);
    }

    private void storeValue(ReportEvent event) {
        if (this.isPrepareRunLevel(event)) {
            this.values.put(this.pageIndex, this.currentGroupKey, super.getValue());
        }
    }

    @Override
    public Expression getInstance() {
        TotalPageSumFunction function = (TotalPageSumFunction)super.getInstance();
        function.values = new PageGroupValues();
        return function;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.values = new PageGroupValues();
    }
}

