/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.build;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.Band;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.Section;
import org.pentaho.reporting.engine.classic.core.SubReport;
import org.pentaho.reporting.engine.classic.core.filter.RawDataSource;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;
import org.pentaho.reporting.engine.classic.core.layout.InlineSubreportMarker;
import org.pentaho.reporting.engine.classic.core.layout.build.DefaultLayoutModelBuilder;
import org.pentaho.reporting.engine.classic.core.layout.build.LayoutBuilderStrategy;
import org.pentaho.reporting.engine.classic.core.layout.build.LayoutModelBuilder;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorFeature;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.layout.richtext.RichTextConverter;
import org.pentaho.reporting.engine.classic.core.layout.richtext.RichTextConverterRegistry;
import org.pentaho.reporting.engine.classic.core.layout.style.SimpleStyleSheet;
import org.pentaho.reporting.engine.classic.core.metadata.ElementType;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.ResolverStyleSheet;
import org.pentaho.reporting.engine.classic.core.style.StyleSheet;
import org.pentaho.reporting.engine.classic.core.style.resolver.SimpleStyleResolver;
import org.pentaho.reporting.engine.classic.core.util.AbstractStructureVisitor;

public class DefaultLayoutBuilderStrategy
implements LayoutBuilderStrategy {
    private static final Log logger = LogFactory.getLog(DefaultLayoutBuilderStrategy.class);
    private ExpressionRuntime runtime;
    private ArrayList<InlineSubreportMarker> collectedReports = new ArrayList();
    private boolean designtime;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(ExpressionRuntime runtime, LayoutModelBuilder builder, Band band, List<InlineSubreportMarker> collectedSubReports) throws ReportProcessingException {
        if (runtime == null) {
            throw new NullPointerException();
        }
        if (builder == null) {
            throw new NullPointerException();
        }
        if (band == null) {
            throw new NullPointerException();
        }
        try {
            this.runtime = runtime;
            OutputProcessorMetaData outputProcessorMetaData = runtime.getProcessingContext().getOutputProcessorMetaData();
            this.designtime = outputProcessorMetaData.isFeatureSupported(OutputProcessorFeature.DESIGNTIME);
            this.collectedReports.clear();
            SimpleStyleSheet styleSheet = band.getComputedStyle();
            boolean invConsSpace = builder.isEmptyElementsHaveSignificance();
            if (invConsSpace || this.isElementProcessable(band, styleSheet)) {
                if (this.addBandInternal(band, builder, true)) {
                    builder.addProgressMarkerBox();
                }
            } else {
                builder.addProgressMarkerBox();
            }
        }
        finally {
            this.runtime = null;
        }
        collectedSubReports.addAll(this.collectedReports);
    }

    private boolean addBandInternal(Section band, LayoutModelBuilder builder, boolean root) {
        OutputProcessorMetaData metaData;
        builder.startBox(band);
        boolean invConsSpace = builder.isEmptyElementsHaveSignificance();
        for (ReportElement element : band) {
            SimpleStyleSheet styleSheet = element.getComputedStyle();
            if (!invConsSpace && !this.isElementProcessable(element, styleSheet)) continue;
            if (element instanceof SubReport) {
                this.processSubReport((SubReport)element, builder);
                continue;
            }
            if (element instanceof Section) {
                this.addBandInternal((Section)element, builder, false);
                continue;
            }
            this.processContent(element, builder);
        }
        if (!root && builder.isEmpty() && (metaData = this.runtime.getProcessingContext().getOutputProcessorMetaData()).isFeatureSupported(OutputProcessorFeature.STRICT_COMPATIBILITY)) {
            SimpleStyleSheet computedStyle = band.getComputedStyle();
            if (!invConsSpace && !DefaultLayoutModelBuilder.isControlBand(computedStyle)) {
                if (band.getElementCount() > 0) {
                    builder.legacyFlagNotEmpty();
                }
                builder.finishBox();
                builder.legacyAddPlaceholder(band);
                return false;
            }
            builder.legacyFlagNotEmpty();
        }
        return builder.finishBox();
    }

    protected void processSubReport(SubReport subReport, LayoutModelBuilder builder) {
        InlineSubreportMarker marker = builder.processSubReport(subReport);
        if (marker != null) {
            logger.debug((Object)("Process Subreport: " + marker.getInsertationPointId()));
            this.collectedReports.add(marker);
        } else {
            logger.debug((Object)"Process Subreport: NOT returning anything.");
        }
    }

    protected Object filterRichText(ReportElement element, Object initialValue) {
        RichTextConverterRegistry registry;
        RichTextConverter converter;
        Object richTextType = element.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "rich-text-type");
        if (richTextType != null && (converter = (registry = RichTextConverterRegistry.getRegistry()).getConverter(String.valueOf(richTextType))) != null) {
            return converter.convert(element, initialValue);
        }
        return initialValue;
    }

    protected void processContent(ReportElement element, LayoutModelBuilder builder) {
        Object rawValue;
        Object value = this.filterRichText(element, this.computeValue(this.runtime, element));
        if (value == null) {
            builder.processContent(element, null, null);
            return;
        }
        if (value instanceof Section) {
            Section section = (Section)value;
            this.resolveStyle(section);
            this.addBandInternal(section, builder, false);
            return;
        }
        ElementType dataSource = element.getElementType();
        if (dataSource instanceof RawDataSource) {
            RawDataSource rds = (RawDataSource)((Object)dataSource);
            rawValue = rds.getRawValue(this.runtime, element);
        } else {
            rawValue = null;
        }
        builder.processContent(element, value, rawValue);
    }

    private void resolveStyle(Section section) {
        RichTextStyleResolver richTextStyleResolver = new RichTextStyleResolver();
        richTextStyleResolver.resolve(section);
    }

    protected boolean isElementProcessable(ReportElement element, StyleSheet style) {
        if (this.designtime) {
            Object attribute = element.getAttribute("http://reporting.pentaho.org/namespaces/report-designer/2.0", "hideInLayoutGUI");
            return !Boolean.TRUE.equals(attribute);
        }
        return style.getBooleanStyleProperty(ElementStyleKeys.VISIBLE);
    }

    protected Object computeValue(ExpressionRuntime runtime, ReportElement element) {
        if (this.designtime) {
            Object value = element.getElementType().getDesignValue(runtime, element);
            if (value != null) {
                return value;
            }
            return element.getElementType().getMetaData().getName();
        }
        return element.getElementType().getValue(runtime, element);
    }

    private static class RichTextStyleResolver
    extends AbstractStructureVisitor {
        private SimpleStyleResolver simpleStyleResolver = new SimpleStyleResolver();
        private ResolverStyleSheet resolveStyleSheet = new ResolverStyleSheet();

        private RichTextStyleResolver() {
        }

        public void resolve(Section section) {
            this.inspectElement(section);
            this.traverseSection(section);
        }

        @Override
        protected void inspectElement(ReportElement element) {
            this.simpleStyleResolver.resolve(element, this.resolveStyleSheet);
            element.setComputedStyle(new SimpleStyleSheet(this.resolveStyleSheet));
        }
    }
}

