/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.build;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.SubReport;
import org.pentaho.reporting.engine.classic.core.function.ProcessingContext;
import org.pentaho.reporting.engine.classic.core.layout.InlineSubreportMarker;
import org.pentaho.reporting.engine.classic.core.layout.build.LayoutModelBuilder;
import org.pentaho.reporting.engine.classic.core.layout.build.LayoutModelBuilderWrapper;
import org.pentaho.reporting.engine.classic.core.layout.build.RenderNodeFactory;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorFeature;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.states.ReportStateKey;
import org.pentaho.reporting.engine.classic.core.style.BandStyleKeys;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;

public class FooterLayoutModelBuilder
extends LayoutModelBuilderWrapper {
    private static final Log logger = LogFactory.getLog(FooterLayoutModelBuilder.class);
    private ArrayList<RenderNode> slots;
    private int slotCounter;
    private RenderBox parentBox;
    private int inBoxDepth;
    private ReportStateKey stateKey;
    private boolean empty;
    private OutputProcessorMetaData metaData;

    public FooterLayoutModelBuilder(LayoutModelBuilder backend) {
        super(backend);
        backend.setLimitedSubReports(true);
        backend.setCollapseProgressMarker(false);
        this.slots = new ArrayList();
    }

    @Override
    public void initialize(ProcessingContext metaData, RenderBox parentBox, RenderNodeFactory renderNodeFactory) {
        this.parentBox = parentBox;
        this.getParent().initialize(metaData, parentBox, renderNodeFactory);
        this.metaData = metaData.getOutputProcessorMetaData();
    }

    @Override
    public void setLimitedSubReports(boolean limitedSubReports) {
    }

    @Override
    public void updateState(ReportStateKey stateKey) {
        this.stateKey = stateKey;
        this.getParent().updateState(stateKey);
    }

    @Override
    public void startBox(ReportElement element) {
        this.getParent().startBox(element);
        if (this.inBoxDepth == 0 && logger.isDebugEnabled()) {
            logger.debug((Object)("Started a Box: " + this.slotCounter + " " + element));
        }
        ++this.inBoxDepth;
    }

    @Override
    public void startSection(ReportElement element, int sectionSize) {
        throw new UnsupportedOperationException("Global sections cannot be started for page headers");
    }

    @Override
    public InlineSubreportMarker processSubReport(SubReport element) {
        throw new UnsupportedOperationException("SubReports cannot be started for page headers");
    }

    @Override
    public boolean finishBox() {
        if (this.inBoxDepth == 1) {
            this.empty &= super.isEmpty();
        }
        super.finishBox();
        --this.inBoxDepth;
        if (this.inBoxDepth == 0) {
            ++this.slotCounter;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Finshed a Box: " + this.slotCounter + " - empty: " + super.isEmpty()));
            }
            return super.isEmpty();
        }
        return this.empty;
    }

    @Override
    public boolean isEmpty() {
        if (this.inBoxDepth == 0) {
            return this.empty;
        }
        return super.isEmpty();
    }

    @Override
    public void endSubFlow() {
        throw new UnsupportedOperationException("SubReport sections cannot be started for page headers");
    }

    @Override
    public void addProgressMarkerBox() {
        super.addProgressMarkerBox();
        ++this.slotCounter;
    }

    @Override
    public void addManualPageBreakBox(long range) {
        throw new UnsupportedOperationException("PageBreak sections cannot be started for page headers");
    }

    @Override
    public LayoutModelBuilder deriveForStorage(RenderBox clonedContent) {
        FooterLayoutModelBuilder clone = (FooterLayoutModelBuilder)super.deriveForStorage(clonedContent);
        clone.slots = (ArrayList)this.slots.clone();
        clone.slots.clear();
        clone.parentBox = clonedContent;
        return clone;
    }

    @Override
    public LayoutModelBuilder deriveForPageBreak() {
        FooterLayoutModelBuilder clone = (FooterLayoutModelBuilder)super.deriveForPageBreak();
        clone.slots = (ArrayList)this.slots.clone();
        clone.slots.clear();
        return clone;
    }

    @Override
    public void startSection() {
        this.empty = true;
        this.slots.clear();
        this.slotCounter = 0;
        RenderNode firstChild = this.parentBox.getFirstChild();
        if (firstChild instanceof RenderBox) {
            RenderBox slottedContent = (RenderBox)firstChild;
            RenderNode box = slottedContent.getFirstChild();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Start Section: " + this.parentBox));
                logger.debug((Object)("      Section: " + slottedContent));
                logger.debug((Object)("      Section: " + box));
                logger.debug((Object)("      Key    : " + this.stateKey));
            }
            boolean sticky = false;
            while (box != null) {
                if (box.getStyleSheet().getBooleanStyleProperty(BandStyleKeys.STICKY)) {
                    sticky = true;
                }
                if (sticky) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Added Slot[]: " + box));
                        logger.debug((Object)("      Slot[]: " + box.getElementType()));
                        logger.debug((Object)("      Slot[]: " + box.getStateKey()));
                    }
                    this.slots.add(box);
                }
                box = box.getNext();
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("Added Reverse Section: " + this.slotCounter + " " + this.slots.size() + " " + firstChild));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Clear Footer for new print.");
        }
        this.parentBox.clear();
        super.startSection();
    }

    @Override
    public void endSection() {
        if (this.metaData.isFeatureSupported(OutputProcessorFeature.STRICT_COMPATIBILITY)) {
            super.legacyFlagNotEmpty();
        }
        super.endSection();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Slot counter: " + this.slotCounter + " " + this.slots.size()));
            for (int i = 0; i < this.slots.size(); ++i) {
                RenderNode renderNode = this.slots.get(i);
                logger.debug((Object)("Slots[" + i + "]: " + renderNode));
                logger.debug((Object)("     [" + i + "]: " + renderNode.getStateKey()));
            }
        }
        RenderNode firstChild = this.parentBox.getFirstChild();
        if (this.slotCounter < this.slots.size() && (firstChild.getLayoutNodeType() & 2) == 2) {
            RenderNode node;
            int i;
            ArrayList<RenderNode> childsAdded = new ArrayList<RenderNode>();
            RenderBox sectionBox = (RenderBox)firstChild;
            RenderNode child = sectionBox.getFirstChild();
            while (child != null) {
                RenderNode next = child.getNext();
                sectionBox.remove(child);
                childsAdded.add(child);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("New[]: " + child));
                }
                child = next;
            }
            sectionBox.clear();
            for (i = this.slots.size() - this.slotCounter - 1; i >= 0; --i) {
                node = this.slots.get(i);
                RenderNode derived = node.derive(true);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Rescued[" + i + "]: " + this.slots.get(i)));
                }
                sectionBox.addGeneratedChild(derived);
            }
            for (i = 0; i < childsAdded.size(); ++i) {
                node = (RenderNode)childsAdded.get(i);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("New[]: " + node));
                }
                sectionBox.addGeneratedChild(node);
            }
        }
    }

    @Override
    public InstanceID createSubflowPlaceholder(ReportElement element) {
        throw new UnsupportedOperationException("SubReport sections cannot be started for page headers");
    }

    @Override
    public void startSubFlow(InstanceID insertationPoint) {
        throw new UnsupportedOperationException("SubReport sections cannot be started for page headers");
    }

    @Override
    public void startSubFlow(ReportElement element) {
        throw new UnsupportedOperationException("SubReport sections cannot be started for page headers");
    }

    @Override
    public void suspendSubFlow() {
        throw new UnsupportedOperationException("SubReport sections cannot be started for page headers");
    }
}

