/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.build;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.SubReport;
import org.pentaho.reporting.engine.classic.core.function.ProcessingContext;
import org.pentaho.reporting.engine.classic.core.layout.InlineSubreportMarker;
import org.pentaho.reporting.engine.classic.core.layout.build.LayoutModelBuilder;
import org.pentaho.reporting.engine.classic.core.layout.build.LayoutModelBuilderWrapper;
import org.pentaho.reporting.engine.classic.core.layout.build.RenderNodeFactory;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorFeature;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;

public class HeaderLayoutModelBuilder
extends LayoutModelBuilderWrapper
implements Cloneable {
    private static final Log logger = LogFactory.getLog(HeaderLayoutModelBuilder.class);
    private RenderBox parentBox;
    private int inBoxDepth;
    private OutputProcessorMetaData metaData;

    public HeaderLayoutModelBuilder(LayoutModelBuilder backend) {
        super(backend);
        backend.setLimitedSubReports(true);
        backend.setCollapseProgressMarker(false);
    }

    @Override
    public void initialize(ProcessingContext metaData, RenderBox parentBox, RenderNodeFactory renderNodeFactory) {
        this.parentBox = parentBox;
        this.getParent().initialize(metaData, parentBox, renderNodeFactory);
        this.metaData = metaData.getOutputProcessorMetaData();
    }

    @Override
    public void setLimitedSubReports(boolean limitedSubReports) {
    }

    @Override
    public void startBox(ReportElement element) {
        super.startBox(element);
        ++this.inBoxDepth;
    }

    @Override
    public void startSection(ReportElement element, int sectionSize) {
        throw new UnsupportedOperationException("Global sections cannot be started for page headers");
    }

    @Override
    public InlineSubreportMarker processSubReport(SubReport element) {
        return null;
    }

    @Override
    public boolean finishBox() {
        --this.inBoxDepth;
        return super.finishBox();
    }

    @Override
    public void endSubFlow() {
        throw new UnsupportedOperationException("SubReport sections cannot be started for page headers");
    }

    @Override
    public void addProgressMarkerBox() {
        if (this.inBoxDepth != 0) {
            throw new IllegalStateException();
        }
        super.addProgressMarkerBox();
    }

    @Override
    public void addManualPageBreakBox(long range) {
        throw new UnsupportedOperationException("PageBreak sections cannot be started for page headers");
    }

    @Override
    public LayoutModelBuilder deriveForStorage(RenderBox clonedContent) {
        HeaderLayoutModelBuilder clone = (HeaderLayoutModelBuilder)super.deriveForStorage(clonedContent);
        clone.parentBox = clonedContent;
        return clone;
    }

    @Override
    public void startSection() {
        if (this.inBoxDepth != 0) {
            throw new IllegalStateException();
        }
        this.parentBox.clear();
        super.startSection();
    }

    @Override
    public void endSection() {
        if (this.inBoxDepth != 0) {
            throw new IllegalStateException();
        }
        if (this.metaData.isFeatureSupported(OutputProcessorFeature.STRICT_COMPATIBILITY)) {
            super.legacyFlagNotEmpty();
        }
        super.endSection();
    }

    @Override
    public InstanceID createSubflowPlaceholder(ReportElement element) {
        throw new UnsupportedOperationException("SubReport sections cannot be started for page headers");
    }

    @Override
    public void startSubFlow(InstanceID insertationPoint) {
        throw new UnsupportedOperationException("SubReport sections cannot be started for page headers");
    }

    @Override
    public void startSubFlow(ReportElement element) {
        throw new UnsupportedOperationException("SubReport sections cannot be started for page headers");
    }

    @Override
    public void suspendSubFlow() {
        throw new UnsupportedOperationException("SubReport sections cannot be started for page headers");
    }
}

