/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.build;

import java.util.ArrayList;
import org.pentaho.reporting.engine.classic.core.Band;
import org.pentaho.reporting.engine.classic.core.Group;
import org.pentaho.reporting.engine.classic.core.GroupBody;
import org.pentaho.reporting.engine.classic.core.ReportDefinition;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;
import org.pentaho.reporting.engine.classic.core.function.ProcessingContext;
import org.pentaho.reporting.engine.classic.core.layout.InlineSubreportMarker;
import org.pentaho.reporting.engine.classic.core.layout.RenderComponentFactory;
import org.pentaho.reporting.engine.classic.core.layout.Renderer;
import org.pentaho.reporting.engine.classic.core.layout.build.FooterLayoutModelBuilder;
import org.pentaho.reporting.engine.classic.core.layout.build.HeaderLayoutModelBuilder;
import org.pentaho.reporting.engine.classic.core.layout.build.LayoutBuilderStrategy;
import org.pentaho.reporting.engine.classic.core.layout.build.LayoutModelBuilder;
import org.pentaho.reporting.engine.classic.core.layout.build.RenderModelBuilder;
import org.pentaho.reporting.engine.classic.core.layout.build.RenderNodeFactory;
import org.pentaho.reporting.engine.classic.core.layout.build.RepeatedFooterLayoutModelBuilder;
import org.pentaho.reporting.engine.classic.core.layout.build.WatermarkLayoutModelBuilder;
import org.pentaho.reporting.engine.classic.core.layout.model.LogicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.layout.style.SimpleStyleSheet;
import org.pentaho.reporting.engine.classic.core.states.ReportStateKey;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;

public class ReportRenderModelBuilder
implements RenderModelBuilder,
Cloneable {
    private LayoutModelBuilder normalFlow;
    private LayoutModelBuilder header;
    private LayoutModelBuilder footer;
    private LayoutModelBuilder repeatedFooter;
    private LayoutModelBuilder watermark;
    private Renderer.SectionType activeSection;
    private LogicalPageBox pageBox;
    private ArrayList<InlineSubreportMarker> collectedSubReportMarker;
    private ProcessingContext processingContext;
    private RenderNodeFactory renderNodeFactory;
    private ReportStateKey stateKey;
    private LayoutBuilderStrategy layoutBuilderStrategy;
    private RenderComponentFactory componentFactory;

    public ReportRenderModelBuilder(RenderComponentFactory componentFactory) {
        this.componentFactory = componentFactory;
        this.layoutBuilderStrategy = componentFactory.createLayoutBuilderStrategy();
        this.collectedSubReportMarker = new ArrayList();
    }

    @Override
    public void startReport(ReportDefinition report, ProcessingContext processingContext) {
        OutputProcessorMetaData outputProcessorMetaData = processingContext.getOutputProcessorMetaData();
        this.renderNodeFactory = this.componentFactory.createRenderNodeFactory();
        this.renderNodeFactory.initialize(outputProcessorMetaData);
        this.processingContext = processingContext;
        SimpleStyleSheet resolverStyle = report.getComputedStyle();
        this.pageBox = this.renderNodeFactory.createPage(report, resolverStyle);
        this.normalFlow = this.componentFactory.createLayoutModelBuilder("Section-0");
        this.normalFlow.initialize(processingContext, this.pageBox.getContentArea(), this.renderNodeFactory);
        this.normalFlow.updateState(this.stateKey);
        this.header = new HeaderLayoutModelBuilder(this.componentFactory.createLayoutModelBuilder("Header-1"));
        this.header.initialize(processingContext, this.pageBox.getHeaderArea(), this.renderNodeFactory);
        this.header.updateState(this.stateKey);
        this.footer = new FooterLayoutModelBuilder(this.componentFactory.createLayoutModelBuilder("Footer-2"));
        this.footer.initialize(processingContext, this.pageBox.getFooterArea(), this.renderNodeFactory);
        this.footer.updateState(this.stateKey);
        this.repeatedFooter = new RepeatedFooterLayoutModelBuilder(this.componentFactory.createLayoutModelBuilder("Repeat-Footer-3"));
        this.repeatedFooter.initialize(processingContext, this.pageBox.getRepeatFooterArea(), this.renderNodeFactory);
        this.repeatedFooter.updateState(this.stateKey);
        this.watermark = new WatermarkLayoutModelBuilder(this.componentFactory.createLayoutModelBuilder("Watermark-Section"));
        this.watermark.initialize(processingContext, this.pageBox.getWatermarkArea(), this.renderNodeFactory);
        this.watermark.updateState(this.stateKey);
    }

    @Override
    public void updateStateKey(ReportStateKey stateKey) {
        this.stateKey = stateKey;
        if (this.normalFlow != null) {
            this.normalFlow.updateState(stateKey);
        }
        if (this.header != null) {
            this.header.updateState(stateKey);
        }
        if (this.footer != null) {
            this.footer.updateState(stateKey);
        }
        if (this.repeatedFooter != null) {
            this.repeatedFooter.updateState(stateKey);
        }
        if (this.watermark != null) {
            this.watermark.updateState(stateKey);
        }
    }

    @Override
    public void startSubReport(ReportDefinition report, InstanceID insertationPoint) {
        if (insertationPoint == null) {
            this.normalFlow.startSubFlow(report);
        } else {
            this.normalFlow.startSubFlow(insertationPoint);
        }
    }

    @Override
    public void startGroup(Group group, Integer predictedStateCount) {
        int count = predictedStateCount == null ? 0 : predictedStateCount;
        this.normalFlow.startSection(group, count);
    }

    @Override
    public void startGroupBody(GroupBody groupBody, Integer predictedStateCount) {
        int count = predictedStateCount == null ? 0 : predictedStateCount;
        this.normalFlow.startSection(groupBody, count);
    }

    @Override
    public void startSection(Renderer.SectionType type) {
        this.activeSection = type;
        this.collectedSubReportMarker.clear();
        this.getLayoutModelBuilder().startSection();
    }

    @Override
    public void addProgressBox() throws ReportProcessingException {
        this.normalFlow.addProgressMarkerBox();
    }

    @Override
    public void addEmptyRootLevelBand() throws ReportProcessingException {
        this.getLayoutModelBuilder().addProgressMarkerBox();
    }

    @Override
    public void addPageBreak() {
        if (this.getPageBox() == null) {
            throw new IllegalStateException();
        }
        this.normalFlow.addManualPageBreakBox(this.getPageBox().getPageOffset());
    }

    @Override
    public void add(ExpressionRuntime runtime, Band band) throws ReportProcessingException {
        LayoutBuilderStrategy builderStrategy = this.getLayoutBuilderStrategy();
        builderStrategy.add(runtime, this.getLayoutModelBuilder(), band, this.collectedSubReportMarker);
    }

    @Override
    public void addToNormalFlow(ExpressionRuntime runtime, Band band) throws ReportProcessingException {
        LayoutBuilderStrategy builderStrategy = this.getLayoutBuilderStrategy();
        builderStrategy.add(runtime, this.normalFlow, band, this.collectedSubReportMarker);
    }

    protected LayoutBuilderStrategy getLayoutBuilderStrategy() {
        return this.layoutBuilderStrategy;
    }

    @Override
    public RenderModelBuilder.SectionResult endSection() {
        boolean empty = this.getLayoutModelBuilder().isEmpty();
        this.getLayoutModelBuilder().endSection();
        InlineSubreportMarker[] markers = this.collectedSubReportMarker.toArray(new InlineSubreportMarker[this.collectedSubReportMarker.size()]);
        this.activeSection = Renderer.SectionType.NORMALFLOW;
        return new RenderModelBuilder.SectionResult(markers, empty);
    }

    @Override
    public void endGroupBody() {
        this.normalFlow.endSection();
    }

    @Override
    public void endGroup() {
        this.normalFlow.endSection();
    }

    @Override
    public void endSubReport() {
        this.normalFlow.endSubFlow();
    }

    @Override
    public void endReport() {
        this.getPageBox().getContentArea().close();
        this.getPageBox().close();
        this.normalFlow.close();
        this.header.close();
        this.footer.close();
        this.repeatedFooter.close();
        this.watermark.close();
        this.renderNodeFactory.close();
    }

    @Override
    public LayoutModelBuilder getNormalFlowLayoutModelBuilder() {
        return this.normalFlow;
    }

    private LayoutModelBuilder getLayoutModelBuilder() {
        switch (this.activeSection) {
            case NORMALFLOW: {
                return this.normalFlow;
            }
            case HEADER: {
                return this.header;
            }
            case FOOTER: {
                return this.footer;
            }
            case REPEAT_FOOTER: {
                return this.repeatedFooter;
            }
            case WATERMARK: {
                return this.watermark;
            }
        }
        throw new IllegalStateException();
    }

    public ReportRenderModelBuilder clone() {
        try {
            ReportRenderModelBuilder builder = (ReportRenderModelBuilder)super.clone();
            builder.collectedSubReportMarker = (ArrayList)this.collectedSubReportMarker.clone();
            return builder;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public LogicalPageBox getPageBox() {
        return this.pageBox;
    }

    @Override
    public RenderModelBuilder deriveForStorage() {
        ReportRenderModelBuilder clone = this.clone();
        if (this.pageBox != null) {
            clone.pageBox = clone.pageBox.derive(true);
            clone.normalFlow = clone.normalFlow.deriveForStorage(clone.pageBox.getContentArea());
            clone.header = clone.header.deriveForStorage(clone.pageBox.getHeaderArea());
            clone.footer = clone.footer.deriveForStorage(clone.pageBox.getFooterArea());
            clone.repeatedFooter = clone.repeatedFooter.deriveForStorage(clone.pageBox.getRepeatFooterArea());
            clone.watermark = clone.watermark.deriveForStorage(clone.pageBox.getWatermarkArea());
        }
        return clone;
    }

    @Override
    public RenderModelBuilder deriveForPageBreak() {
        ReportRenderModelBuilder clone = this.clone();
        if (this.pageBox != null) {
            clone.normalFlow = clone.normalFlow.deriveForPageBreak();
            clone.header = clone.header.deriveForPageBreak();
            clone.footer = clone.footer.deriveForPageBreak();
            clone.repeatedFooter = clone.repeatedFooter.deriveForPageBreak();
            clone.watermark = clone.watermark.deriveForPageBreak();
        }
        return clone;
    }

    @Override
    public void performParanoidModelCheck() {
        if (this.pageBox == null) {
            return;
        }
        this.normalFlow.performParanoidModelCheck(this.pageBox.getContentArea());
        this.header.performParanoidModelCheck(this.pageBox.getHeaderArea());
        this.footer.performParanoidModelCheck(this.pageBox.getFooterArea());
        this.repeatedFooter.performParanoidModelCheck(this.pageBox.getRepeatFooterArea());
        this.watermark.performParanoidModelCheck(this.pageBox.getWatermarkArea());
    }

    @Override
    public void validateAfterCommit() {
        if (this.pageBox == null) {
            return;
        }
        this.normalFlow.validateAfterCommit();
        this.header.validateAfterCommit();
        this.footer.validateAfterCommit();
        this.repeatedFooter.validateAfterCommit();
        this.watermark.validateAfterCommit();
    }

    @Override
    public void restoreStateAfterRollback() {
        this.header.initialize(this.processingContext, this.pageBox.getHeaderArea(), this.renderNodeFactory);
        this.header.restoreStateAfterRollback();
        this.footer.initialize(this.processingContext, this.pageBox.getFooterArea(), this.renderNodeFactory);
        this.footer.restoreStateAfterRollback();
        this.repeatedFooter.initialize(this.processingContext, this.pageBox.getRepeatFooterArea(), this.renderNodeFactory);
        this.repeatedFooter.restoreStateAfterRollback();
        this.watermark.initialize(this.processingContext, this.pageBox.getWatermarkArea(), this.renderNodeFactory);
        this.watermark.restoreStateAfterRollback();
        this.normalFlow.restoreStateAfterRollback();
    }
}

