/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.model;

import org.pentaho.reporting.engine.classic.core.layout.model.PageBreakPositions;

public class FilteringPageBreakPositions
implements PageBreakPositions {
    private PageBreakPositions backend;
    private long pageStart;

    public FilteringPageBreakPositions(PageBreakPositions backend, long pageStart) {
        this.backend = backend;
        this.pageStart = pageStart;
    }

    @Override
    public long findNextBreakPosition(long position) {
        if (position <= this.pageStart) {
            return this.pageStart;
        }
        return this.backend.findNextBreakPosition(position);
    }

    @Override
    public long findNextMajorBreakPosition(long position) {
        if (position <= this.pageStart) {
            return this.pageStart;
        }
        return this.backend.findNextMajorBreakPosition(position);
    }

    @Override
    public long findPreviousBreakPosition(long position) {
        return Math.max(this.pageStart, this.backend.findPreviousBreakPosition(position));
    }

    @Override
    public long findPageStartPositionForPageEndPosition(long pageOffset) {
        if (pageOffset == 0L) {
            return 0L;
        }
        if (pageOffset < this.pageStart) {
            throw new IllegalStateException();
        }
        if (pageOffset == this.pageStart) {
            return 0L;
        }
        return this.backend.findPageStartPositionForPageEndPosition(pageOffset);
    }

    @Override
    public long findPageEndForPageStartPosition(long pageOffset) {
        if (pageOffset <= this.pageStart) {
            return this.pageStart;
        }
        return this.backend.findPageEndForPageStartPosition(pageOffset);
    }

    @Override
    public boolean isCrossingPagebreak(long boxY, long boxHeight, long pagebreakShift) {
        long shiftedYPos = boxY + pagebreakShift;
        if (shiftedYPos <= this.pageStart) {
            return shiftedYPos + boxHeight >= this.pageStart;
        }
        return this.backend.isCrossingPagebreak(boxY, boxHeight, pagebreakShift);
    }

    @Override
    public boolean isCrossingPagebreakWithFixedPosition(long shiftedBoxPosition, long height, long fixedPositionResolved) {
        if (shiftedBoxPosition <= this.pageStart) {
            return false;
        }
        return this.backend.isCrossingPagebreakWithFixedPosition(shiftedBoxPosition, height, fixedPositionResolved);
    }

    @Override
    public long computeFixedPositionInFlow(long shiftedBoxPosition, long fixedPositionResolved) {
        if (shiftedBoxPosition <= this.pageStart) {
            return shiftedBoxPosition;
        }
        return Math.max(this.pageStart, this.backend.computeFixedPositionInFlow(shiftedBoxPosition, fixedPositionResolved));
    }

    @Override
    public boolean isPageStart(long position) {
        if (position < this.pageStart) {
            return false;
        }
        if (position == this.pageStart) {
            return true;
        }
        return this.backend.isPageStart(position);
    }
}

