/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.model;

import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.engine.classic.core.layout.model.context.NodeLayoutProperties;
import org.pentaho.reporting.engine.classic.core.states.ReportStateKey;

public final class FinishedRenderNode
extends RenderNode {
    private long layoutedX;
    private long layoutedY;
    private long layoutedWidth;
    private long layoutedHeight;
    private long marginsTop;
    private long marginsBottom;
    private boolean breakAfter;
    private ReportStateKey stateKey;
    private final boolean orphan;

    public FinishedRenderNode(long layoutedX, long layoutedY, long layoutedWidth, long layoutedHeight, long marginsTop, long marginsBottom, boolean breakAfter, boolean orphan) {
        this(layoutedX, layoutedY, layoutedWidth, layoutedHeight, marginsTop, marginsBottom, breakAfter, orphan, null);
    }

    public FinishedRenderNode(long layoutedX, long layoutedY, long layoutedWidth, long layoutedHeight, long marginsTop, long marginsBottom, boolean breakAfter, boolean orphan, ReportStateKey stateKey) {
        super(NodeLayoutProperties.GENERIC_PROPERTIES);
        if (layoutedWidth < 0L) {
            throw new IllegalStateException("Layouted Width is less than zero: " + layoutedWidth);
        }
        if (layoutedHeight < 0L) {
            throw new IllegalStateException("Layouted Height is less than zero: " + layoutedHeight);
        }
        this.stateKey = stateKey;
        this.breakAfter = breakAfter;
        this.layoutedX = layoutedX;
        this.layoutedY = layoutedY;
        this.layoutedWidth = layoutedWidth;
        this.layoutedWidth = layoutedWidth;
        this.layoutedHeight = layoutedHeight;
        this.marginsBottom = marginsBottom;
        this.marginsTop = marginsTop;
        this.orphan = orphan;
        this.setFinishedPaginate(true);
        this.setFinishedTable(true);
        this.setMinimumChunkWidth(layoutedWidth);
        this.setMaximumBoxWidth(layoutedWidth);
        this.setX(layoutedX);
        this.setY(layoutedY);
        this.setWidth(layoutedWidth);
        this.setHeight(layoutedHeight);
    }

    @Override
    public int getNodeType() {
        return 129;
    }

    @Override
    public boolean isBreakAfter() {
        return this.breakAfter;
    }

    public long getLayoutedWidth() {
        return this.layoutedWidth;
    }

    public long getLayoutedHeight() {
        return this.layoutedHeight;
    }

    public long getMarginsTop() {
        return this.marginsTop;
    }

    public long getMarginsBottom() {
        return this.marginsBottom;
    }

    @Override
    public boolean isIgnorableForRendering() {
        return false;
    }

    @Override
    public ReportStateKey getStateKey() {
        return this.stateKey;
    }

    @Override
    public boolean isOrphanLeaf() {
        return this.orphan;
    }

    @Override
    public RenderBox.RestrictFinishClearOut getRestrictFinishedClearOut() {
        if (this.orphan) {
            return RenderBox.RestrictFinishClearOut.LEAF;
        }
        return RenderBox.RestrictFinishClearOut.UNRESTRICTED;
    }

    public long getLayoutedY() {
        return this.layoutedY;
    }
}

