/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.model;

import org.pentaho.reporting.engine.classic.core.ReportDefinition;
import org.pentaho.reporting.engine.classic.core.filter.types.AutoLayoutBoxType;
import org.pentaho.reporting.engine.classic.core.filter.types.bands.MasterReportType;
import org.pentaho.reporting.engine.classic.core.layout.model.BlockRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.DefaultPageGrid;
import org.pentaho.reporting.engine.classic.core.layout.model.PageAreaBox;
import org.pentaho.reporting.engine.classic.core.layout.model.PageBreakPositionList;
import org.pentaho.reporting.engine.classic.core.layout.model.PageGrid;
import org.pentaho.reporting.engine.classic.core.layout.model.WatermarkAreaBox;
import org.pentaho.reporting.engine.classic.core.layout.model.context.BoxDefinition;
import org.pentaho.reporting.engine.classic.core.layout.style.SimpleStyleSheet;
import org.pentaho.reporting.engine.classic.core.style.StyleSheet;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;

public final class LogicalPageBox
extends BlockRenderBox {
    private PageBreakPositionList allVerticalBreaks;
    private long pageOffset;
    private long pageEnd;
    private WatermarkAreaBox watermarkArea;
    private PageAreaBox headerArea = new PageAreaBox();
    private PageAreaBox footerArea;
    private PageAreaBox repeatFooterArea;
    private DefaultPageGrid pageGrid;
    private InstanceID contentAreaId;
    private String pageName;
    private WatermarkAreaBox savedWatermarkArea;
    private PageAreaBox savedHeaderArea;
    private PageAreaBox savedFooterArea;
    private PageAreaBox savedRepeatFooterArea;

    public LogicalPageBox(ReportDefinition report, StyleSheet style, BoxDefinition box) {
        super(style, report.getObjectID(), box, AutoLayoutBoxType.INSTANCE, report.getAttributes(), null);
        this.headerArea.setName("Logical-Page-Header-Area");
        this.headerArea.setLogicalPage(this);
        this.repeatFooterArea = new PageAreaBox();
        this.repeatFooterArea.setName("Logical-Repeat-Footer-Area");
        this.repeatFooterArea.setLogicalPage(this);
        this.footerArea = new PageAreaBox();
        this.footerArea.setName("Logical-Page-Footer-Area");
        this.footerArea.setLogicalPage(this);
        this.watermarkArea = new WatermarkAreaBox();
        this.watermarkArea.setName("Logical-Page-Watermark-Area");
        this.watermarkArea.setLogicalPage(this);
        BlockRenderBox contentArea = new BlockRenderBox(SimpleStyleSheet.EMPTY_STYLE, new InstanceID(), BoxDefinition.EMPTY, new MasterReportType(), report.getAttributes(), null);
        contentArea.setName("Logical-Page-Content-Area");
        this.addChild(contentArea);
        this.contentAreaId = contentArea.getInstanceId();
        this.pageGrid = new DefaultPageGrid(report.getPageDefinition());
        this.allVerticalBreaks = new PageBreakPositionList();
    }

    public BlockRenderBox getContentArea() {
        BlockRenderBox blockRenderBox = (BlockRenderBox)this.findNodeById(this.contentAreaId);
        if (blockRenderBox == null) {
            throw new IllegalStateException("Cloning or deriving must have failed: No content area.");
        }
        return blockRenderBox;
    }

    public BlockRenderBox getHeaderArea() {
        return this.headerArea;
    }

    public BlockRenderBox getRepeatFooterArea() {
        return this.repeatFooterArea;
    }

    public BlockRenderBox getFooterArea() {
        return this.footerArea;
    }

    public WatermarkAreaBox getWatermarkArea() {
        return this.watermarkArea;
    }

    @Override
    public LogicalPageBox getLogicalPage() {
        return this;
    }

    public long getPageWidth() {
        return this.pageGrid.getMaximumPageWidth();
    }

    public PageGrid getPageGrid() {
        return this.pageGrid;
    }

    public long getPageOffset() {
        return this.pageOffset;
    }

    public void setPageOffset(long pageOffset) {
        this.pageOffset = pageOffset;
    }

    public long getPageEnd() {
        return this.pageEnd;
    }

    public void setPageEnd(long pageEnd) {
        this.pageEnd = pageEnd;
    }

    public long[] getPhysicalBreaks(int axis) {
        if (axis == 0) {
            return this.pageGrid.getHorizontalBreaks();
        }
        return this.pageGrid.getVerticalBreaks();
    }

    public long getPageHeight() {
        return this.pageGrid.getMaximumPageHeight();
    }

    @Override
    public LogicalPageBox deriveFrozen(boolean deepDerive) {
        LogicalPageBox box = (LogicalPageBox)super.deriveFrozen(deepDerive);
        box.headerArea = (PageAreaBox)this.headerArea.deriveFrozen(deepDerive);
        box.headerArea.setLogicalPage(box);
        box.footerArea = (PageAreaBox)this.footerArea.deriveFrozen(deepDerive);
        box.footerArea.setLogicalPage(box);
        box.repeatFooterArea = (PageAreaBox)this.repeatFooterArea.deriveFrozen(deepDerive);
        box.repeatFooterArea.setLogicalPage(box);
        box.watermarkArea = (WatermarkAreaBox)this.watermarkArea.deriveFrozen(deepDerive);
        box.watermarkArea.setLogicalPage(box);
        return box;
    }

    @Override
    public LogicalPageBox derive(boolean deepDerive) {
        LogicalPageBox box = (LogicalPageBox)super.derive(deepDerive);
        box.headerArea = (PageAreaBox)this.headerArea.derive(deepDerive);
        box.headerArea.setLogicalPage(box);
        box.footerArea = (PageAreaBox)this.footerArea.derive(deepDerive);
        box.footerArea.setLogicalPage(box);
        box.repeatFooterArea = (PageAreaBox)this.repeatFooterArea.derive(deepDerive);
        box.repeatFooterArea.setLogicalPage(box);
        box.watermarkArea = (WatermarkAreaBox)this.watermarkArea.derive(deepDerive);
        box.watermarkArea.setLogicalPage(box);
        if (box.savedFooterArea != null) {
            box.savedFooterArea = (PageAreaBox)this.savedFooterArea.derive(deepDerive);
            box.savedFooterArea.setLogicalPage(box);
        }
        if (box.savedRepeatFooterArea != null) {
            box.savedRepeatFooterArea = (PageAreaBox)this.savedRepeatFooterArea.derive(deepDerive);
            box.savedRepeatFooterArea.setLogicalPage(box);
        }
        if (box.savedHeaderArea != null) {
            box.savedHeaderArea = (PageAreaBox)this.savedHeaderArea.derive(deepDerive);
            box.savedHeaderArea.setLogicalPage(box);
        }
        if (box.savedWatermarkArea != null) {
            box.savedWatermarkArea = (WatermarkAreaBox)this.savedWatermarkArea.derive(deepDerive);
            box.savedWatermarkArea.setLogicalPage(box);
        }
        return box;
    }

    @Override
    public LogicalPageBox clone() {
        try {
            LogicalPageBox o = (LogicalPageBox)super.clone();
            o.pageGrid = (DefaultPageGrid)this.pageGrid.clone();
            o.allVerticalBreaks = this.allVerticalBreaks;
            return o;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Cloning *must* be supported.");
        }
    }

    public void setAllVerticalBreaks(PageBreakPositionList allVerticalBreaks) {
        if (allVerticalBreaks == null) {
            throw new NullPointerException();
        }
        this.allVerticalBreaks = new PageBreakPositionList(this.allVerticalBreaks);
        this.allVerticalBreaks.copyFrom(allVerticalBreaks);
    }

    public PageBreakPositionList getAllVerticalBreaks() {
        return this.allVerticalBreaks;
    }

    public long computePageEnd() {
        PageBreakPositionList allVerticalBreaks;
        long lastMasterBreak;
        long pageOffset = this.getPageOffset();
        if (pageOffset == (lastMasterBreak = (allVerticalBreaks = this.getAllVerticalBreaks()).getLastMasterBreak())) {
            return this.getHeight();
        }
        return allVerticalBreaks.findNextMajorBreakPosition(pageOffset + 1L);
    }

    public String getPageName() {
        return this.pageName;
    }

    public void setPageName(String pageName) {
        this.pageName = pageName;
    }

    @Override
    public int getNodeType() {
        return 1042;
    }

    public void storeSaveInformation() {
        this.savedFooterArea = (PageAreaBox)this.getFooterArea().derive(true);
        this.savedRepeatFooterArea = (PageAreaBox)this.getRepeatFooterArea().derive(true);
        this.savedHeaderArea = (PageAreaBox)this.getHeaderArea().derive(true);
        this.savedWatermarkArea = (WatermarkAreaBox)this.getWatermarkArea().derive(true);
    }

    public void rollbackSaveInformation() {
        this.headerArea = (PageAreaBox)this.savedHeaderArea.derive(true);
        this.footerArea = (PageAreaBox)this.savedFooterArea.derive(true);
        this.repeatFooterArea = (PageAreaBox)this.savedRepeatFooterArea.derive(true);
        this.watermarkArea = (WatermarkAreaBox)this.savedWatermarkArea.derive(true);
    }
}

