/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.model;

import org.pentaho.reporting.engine.classic.core.InvalidReportStateException;
import org.pentaho.reporting.engine.classic.core.ReportAttributeMap;
import org.pentaho.reporting.engine.classic.core.filter.types.AutoLayoutBoxType;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.engine.classic.core.layout.model.context.BoxDefinition;
import org.pentaho.reporting.engine.classic.core.layout.model.context.StaticBoxLayoutProperties;
import org.pentaho.reporting.engine.classic.core.layout.process.CountBoxesStep;
import org.pentaho.reporting.engine.classic.core.layout.text.ExtendedBaselineInfo;
import org.pentaho.reporting.engine.classic.core.metadata.ElementType;
import org.pentaho.reporting.engine.classic.core.states.ReportStateKey;
import org.pentaho.reporting.engine.classic.core.style.BandStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.StyleSheet;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;

public abstract class RenderBox
extends RenderNode {
    protected static final int FLAG_BOX_TABLE_SECTION_RESERVED = 524288;
    protected static final int FLAG_BOX_TABLE_SECTION_RESERVED2 = 0x1000000;
    protected static final int FLAG_BOX_TABLE_SECTION_RESERVED3 = 0x2000000;
    protected static final int FLAG_BOX_TABLE_SECTION_RESERVED4 = 0x4000000;
    protected static final int FLAG_BOX_TABLE_SECTION_RESERVED5 = 0x8000000;
    protected static final int FLAG_BOX_INVALID_WIDOW_ORPHAN_NODE = 0x10000000;
    private static final int FLAG_BOX_OPEN = 65536;
    private static final int FLAG_BOX_MARKED_OPEN = 131072;
    private static final int FLAG_BOX_APPLIED_OPEN = 262144;
    private static final int FLAG_BOX_MARKED_SEEN = 0x100000;
    private static final int FLAG_BOX_APPLIED_SEEN = 0x200000;
    private static final int FLAG_BOX_DEEP_FINISHED = 0x400000;
    private static final int FLAG_BOX_CONTENT_REF_HOLDER = 0x800000;
    private int contentRefCount;
    private int tableRefCount;
    private int descendantCount;
    private int markedContentRefCount;
    private int appliedContentRefCount;
    private BoxDefinition boxDefinition;
    private StaticBoxLayoutProperties staticBoxLayoutProperties;
    private RenderNode firstChildNode;
    private RenderNode lastChildNode;
    private Object rawValue;
    private ExtendedBaselineInfo baselineInfo;
    private String name;
    private BreakIndicator breakIndicator;
    private ReportStateKey stateKey;
    private RenderBox textEllipseBox;
    private Object tableExportState;
    private Boolean contentBox;
    private long staticBoxPropertiesAge;
    private long tableValidationAge;
    private long pinned;
    private long appliedPinPosition;
    private long markedPinPosition;
    private long contentAreaX1;
    private long contentAreaX2;
    private long contentAge;
    private long overflowAreaWidth;
    private long overflowAreaHeight;
    private long orphanConstraintSize;
    private long widowConstraintSize;
    private long widowConstraintSizeWithKeepTogether;
    private RestrictFinishClearOut restrictFinishClearOut;
    private int parentWidowContexts;

    protected RenderBox(int majorAxis, int minorAxis, StyleSheet styleSheet, InstanceID instanceId, BoxDefinition boxDefinition, ElementType elementType, ReportAttributeMap attributes, ReportStateKey stateKey) {
        super(majorAxis, minorAxis, styleSheet, instanceId, elementType, attributes);
        if (boxDefinition == null) {
            throw new NullPointerException();
        }
        if (!boxDefinition.isLocked()) {
            throw new InvalidReportStateException("BoxDefinition must be read-only");
        }
        this.pinned = -1L;
        this.tableValidationAge = -1L;
        this.boxDefinition = boxDefinition;
        this.setOpen(true);
        this.staticBoxLayoutProperties = new StaticBoxLayoutProperties();
        this.staticBoxPropertiesAge = -1L;
        this.staticBoxLayoutProperties.setBreakAfter(this.getStyleSheet().getBooleanStyleProperty(BandStyleKeys.PAGEBREAK_AFTER));
        this.stateKey = stateKey;
        this.descendantCount = 1;
        this.restrictFinishClearOut = RestrictFinishClearOut.UNRESTRICTED;
    }

    public RenderBox create(StyleSheet styleSheet) {
        RenderBox b = (RenderBox)this.derive(false);
        b.reinit(styleSheet, AutoLayoutBoxType.INSTANCE, ReportAttributeMap.EMPTY_MAP, new InstanceID());
        b.boxDefinition = BoxDefinition.EMPTY;
        b.staticBoxLayoutProperties = new StaticBoxLayoutProperties();
        b.staticBoxPropertiesAge = -1L;
        b.stateKey = null;
        b.setOpen(true);
        b.setMarkedOpen(false);
        b.setMarkedSeen(false);
        b.markedContentRefCount = 0;
        b.setAppliedOpen(false);
        b.setAppliedSeen(false);
        b.appliedContentRefCount = 0;
        b.contentAge = 0L;
        b.contentRefCount = 0;
        b.breakIndicator = BreakIndicator.NO_MANUAL_BREAK;
        b.staticBoxPropertiesAge = -1L;
        b.pinned = -1L;
        b.tableExportState = null;
        b.setDeepFinished(false);
        b.contentAreaX1 = 0L;
        b.contentAreaX2 = 0L;
        b.setContentRefHolder(false);
        b.descendantCount = 1;
        b.tableValidationAge = -1L;
        b.orphanConstraintSize = 0L;
        b.widowConstraintSize = 0L;
        b.widowConstraintSizeWithKeepTogether = 0L;
        b.restrictFinishClearOut = RestrictFinishClearOut.UNRESTRICTED;
        b.parentWidowContexts = 0;
        return b;
    }

    public void setParentWidowContexts(int parentWidowContexts) {
        this.parentWidowContexts = parentWidowContexts;
    }

    public int getParentWidowContexts() {
        return this.parentWidowContexts;
    }

    @Override
    public int getDescendantCount() {
        return this.descendantCount;
    }

    public boolean isContentRefHolder() {
        return this.isFlag(0x800000);
    }

    private void setContentRefHolder(boolean flag) {
        this.setFlag(0x800000, flag);
    }

    public void markAsContentRefHolder() {
        if (this.isContentRefHolder()) {
            throw new IllegalStateException();
        }
        this.setContentRefHolder(true);
        this.increaseContentReferenceCount(1, this);
    }

    public Object getRawValue() {
        return this.rawValue;
    }

    public void setRawValue(Object rawValue) {
        this.rawValue = rawValue;
    }

    @Override
    public boolean isSizeSpecifiesBorderBox() {
        return this.boxDefinition.isSizeSpecifiesBorderBox();
    }

    public RenderBox getTextEllipseBox() {
        return this.textEllipseBox;
    }

    public void setTextEllipseBox(RenderBox textEllipseBox) {
        this.textEllipseBox = textEllipseBox;
    }

    @Override
    public ReportStateKey getStateKey() {
        return this.stateKey;
    }

    protected void setStateKey(ReportStateKey stateKey) {
        this.stateKey = stateKey;
    }

    public BreakIndicator getManualBreakIndicator() {
        return this.breakIndicator;
    }

    public void setManualBreakIndicator(BreakIndicator manualBreakIndicator) {
        this.breakIndicator = manualBreakIndicator;
    }

    public BoxDefinition getBoxDefinition() {
        return this.boxDefinition;
    }

    public long getInsetsLeft() {
        return this.staticBoxLayoutProperties.getBorderLeft() + this.boxDefinition.getPaddingLeft();
    }

    public long getInsetsRight() {
        return this.staticBoxLayoutProperties.getBorderRight() + this.boxDefinition.getPaddingRight();
    }

    @Override
    public long getEffectiveMinimumChunkSize() {
        return this.getMinimumChunkWidth() + this.getInsets();
    }

    public long getInsets() {
        return this.staticBoxLayoutProperties.getBorderLeft() + this.staticBoxLayoutProperties.getBorderRight() + this.boxDefinition.getPaddingLeft() + this.boxDefinition.getPaddingRight();
    }

    public RenderNode getFirstChild() {
        return this.firstChildNode;
    }

    protected void setFirstChild(RenderNode firstChild) {
        this.firstChildNode = firstChild;
        if (RenderBox.isParanoidModelChecks() && firstChild != null && firstChild.getPrev() != null) {
            throw new NullPointerException();
        }
    }

    public RenderNode getLastChild() {
        return this.lastChildNode;
    }

    protected void setLastChild(RenderNode lastChild) {
        this.lastChildNode = lastChild;
        if (RenderBox.isParanoidModelChecks() && lastChild != null && lastChild.getNext() != null) {
            throw new NullPointerException();
        }
    }

    public void addGeneratedChild(RenderNode child) {
        if (child == null) {
            throw new NullPointerException("Child to be added must not be null.");
        }
        RenderNode oldLastChild = this.getLastChild();
        this.setLastChild(child);
        if (oldLastChild != null) {
            oldLastChild.setNext(child);
        }
        child.setParent(this);
        child.setPrev(oldLastChild);
        child.setNext(null);
        RenderNode oldFirstChild = this.getFirstChild();
        if (oldFirstChild == null) {
            this.setFirstChild(child);
        }
        if (this.isFrozen()) {
            child.freeze();
        }
        child.updateChangeTracker();
        this.onChildAdded(child);
        this.validateDescendantCounter();
    }

    private void validateDescendantCounter() {
        if (!RenderBox.isParanoidModelChecks()) {
            return;
        }
        CountBoxesStep step = new CountBoxesStep();
        int count = step.countChildren(this);
        if (count != this.descendantCount) {
            throw new InvalidReportStateException(this.getClass().getSimpleName() + "(" + this.getName() + "): Counted boxes of " + count + " but claimed to have " + this.descendantCount);
        }
    }

    public void addChild(RenderNode child) {
        if (child == null) {
            throw new NullPointerException("Child to be added must not be null.");
        }
        if (!this.isOpen()) {
            throw new IllegalStateException("Adding content to an already closed element: " + this);
        }
        if (RenderBox.isParanoidModelChecks() && (this.getLayoutNodeType() & 0x12) == 18 && (child.getLayoutNodeType() & 0x42) == 66) {
            throw new IllegalStateException("Paranoid Check: A block box cannot contain a inline box directly. They must be wrapped into a paragraph.");
        }
        RenderNode oldLastChild = this.getLastChild();
        this.setLastChild(child);
        if (oldLastChild != null) {
            oldLastChild.setNext(child);
        }
        child.setParent(this);
        child.setPrev(oldLastChild);
        child.setNext(null);
        RenderNode oldFirstChild = this.getFirstChild();
        if (oldFirstChild == null) {
            this.setFirstChild(child);
        }
        if (this.isFrozen()) {
            child.freeze();
        }
        child.updateChangeTracker();
        this.onChildAdded(child);
        this.validateDescendantCounter();
    }

    protected void increaseContentReferenceCount(int count, RenderNode source) {
        if (count < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (count == 0) {
            return;
        }
        this.contentRefCount += count;
        RenderBox renderBox = this.getParent();
        if (renderBox != null) {
            renderBox.increaseContentReferenceCount(count, this);
        }
    }

    protected void increaseTableReferenceCount(int count, RenderNode source) {
        if (count < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (count == 0) {
            return;
        }
        this.tableRefCount += count;
        RenderBox renderBox = this.getParent();
        if (renderBox != null) {
            renderBox.increaseTableReferenceCount(count, this);
        }
    }

    protected void increaseDescendantCount(int count, RenderNode source) {
        if (count < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (count == 0) {
            return;
        }
        this.descendantCount += count;
        RenderBox renderBox = this.getParent();
        if (renderBox != null) {
            renderBox.increaseDescendantCount(count, this);
        }
    }

    protected void decreaseContentReferenceCount(int count, RenderNode source) {
        if (count < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (count == 0) {
            return;
        }
        if (this.contentRefCount - count < 0) {
            throw new IndexOutOfBoundsException("New ContentRefCount would be negative");
        }
        this.contentRefCount -= count;
        RenderBox renderBox = this.getParent();
        if (renderBox != null) {
            renderBox.decreaseContentReferenceCount(count, this);
        }
    }

    protected void decreaseTableReferenceCount(int count, RenderNode source) {
        if (count < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (count == 0) {
            return;
        }
        if (this.tableRefCount - count < 0) {
            throw new IndexOutOfBoundsException("New TableRefCount would be negative");
        }
        this.tableRefCount -= count;
        RenderBox renderBox = this.getParent();
        if (renderBox != null) {
            renderBox.decreaseTableReferenceCount(count, this);
        }
    }

    protected void decreaseDescendantCount(int count, RenderNode source) {
        if (count < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (count == 0) {
            return;
        }
        if (this.descendantCount - count < 1) {
            throw new IndexOutOfBoundsException("New Descendant-Count would be negative. " + this.descendantCount + " - " + count);
        }
        this.descendantCount -= count;
        RenderBox renderBox = this.getParent();
        if (renderBox != null) {
            renderBox.decreaseDescendantCount(count, this);
        }
    }

    @Override
    public int getContentRefCount() {
        return this.contentRefCount;
    }

    @Override
    public int getTableRefCount() {
        return this.tableRefCount;
    }

    public void replaceChild(RenderNode old, RenderNode replacement) {
        RenderNode oldLastChild;
        if (old.getParent() != this) {
            throw new IllegalArgumentException("None of my childs.");
        }
        if (old == replacement) {
            return;
        }
        RenderNode oldFirstChild = this.getFirstChild();
        if (old == oldFirstChild) {
            this.setFirstChild(replacement);
        }
        if (old == (oldLastChild = this.getLastChild())) {
            this.setLastChild(replacement);
        }
        RenderNode prev = old.getPrev();
        RenderNode next = old.getNext();
        replacement.setParent(this);
        replacement.setPrev(prev);
        replacement.setNext(next);
        if (prev != null) {
            prev.setNext(replacement);
        }
        if (next != null) {
            next.setPrev(replacement);
        }
        old.setNext(null);
        old.setPrev(null);
        old.setParent(null);
        old.updateChangeTracker();
        this.onChildRemoved(old);
        replacement.updateChangeTracker();
        this.onChildAdded(replacement);
        this.validateDescendantCounter();
        if (RenderBox.isParanoidModelChecks() && replacement.getNext() == null && this.getLastChild() != replacement) {
            throw new IllegalStateException();
        }
    }

    public void replaceChilds(RenderNode old, RenderNode[] replacement) {
        int i;
        if (old.getParent() != this) {
            throw new IllegalArgumentException("None of my childs.");
        }
        int replacementCount = replacement.length;
        if (replacementCount == 0) {
            throw new IndexOutOfBoundsException("Array is empty ..");
        }
        if (old == replacement[0] && replacementCount == 1) {
            return;
        }
        RenderNode oldPrev = old.getPrev();
        RenderNode oldNext = old.getNext();
        old.setNext(null);
        old.setPrev(null);
        old.setParent(null);
        RenderNode first = null;
        RenderNode last = null;
        for (i = 0; i < replacementCount; ++i) {
            if (last == null) {
                last = replacement[i];
                if (last == null) continue;
                first = last;
                first.setParent(this);
                continue;
            }
            RenderNode node = replacement[i];
            last.setNextUnchecked(node);
            node.setPrevUnchecked(last);
            node.setParent(this);
            last = node;
        }
        if (first == null) {
            throw new IndexOutOfBoundsException("Array is empty (NullValues stripped)..");
        }
        if (old == this.getFirstChild()) {
            this.setFirstChild(first);
        }
        if (old == this.getLastChild()) {
            this.setLastChild(last);
        }
        first.setPrev(oldPrev);
        last.setNext(oldNext);
        if (oldPrev != null) {
            oldPrev.setNext(first);
        }
        if (oldNext != null) {
            oldNext.setPrev(last);
        }
        old.updateChangeTracker();
        this.onChildRemoved(old);
        for (i = 0; i < replacementCount; ++i) {
            RenderNode renderNode = replacement[i];
            renderNode.updateChangeTracker();
            this.onChildAdded(renderNode);
        }
        this.validateDescendantCounter();
    }

    private void onChildAdded(RenderNode child) {
        this.increaseContentReferenceCount(child.getContentRefCount(), child);
        this.increaseTableReferenceCount(child.getTableRefCount(), child);
        this.increaseDescendantCount(child.getDescendantCount(), child);
    }

    private void onChildRemoved(RenderNode old) {
        this.decreaseContentReferenceCount(old.getContentRefCount(), old);
        this.decreaseTableReferenceCount(old.getTableRefCount(), old);
        this.decreaseDescendantCount(old.getDescendantCount(), old);
    }

    @Override
    public RenderNode derive(boolean deepDerive) {
        RenderBox box = (RenderBox)super.derive(deepDerive);
        if (deepDerive) {
            RenderNode currentNode = null;
            for (RenderNode node = this.getFirstChild(); node != null; node = node.getNext()) {
                RenderNode previous = currentNode;
                currentNode = node.derive(true);
                currentNode.setParent(box);
                if (previous == null) {
                    if (RenderBox.isParanoidModelChecks() && currentNode.getPrev() != null) {
                        throw new IllegalStateException();
                    }
                    box.setFirstChild(currentNode);
                    continue;
                }
                previous.setNext(currentNode);
                currentNode.setPrev(previous);
            }
            box.setLastChild(currentNode);
            this.validateDescendantCounter();
            if (RenderBox.isParanoidModelChecks() && currentNode != null && currentNode.getNext() != null) {
                throw new IllegalStateException();
            }
        } else {
            box.setLastChild(null);
            box.setFirstChild(null);
            box.contentRefCount = 0;
            box.descendantCount = 1;
            box.tableRefCount = 0;
        }
        return box;
    }

    @Override
    public RenderNode deriveFrozen(boolean deepDerive) {
        RenderBox box = (RenderBox)super.deriveFrozen(deepDerive);
        if (deepDerive) {
            RenderNode currentNode = null;
            for (RenderNode node = this.getFirstChild(); node != null; node = node.getNext()) {
                RenderNode previous = currentNode;
                currentNode = node.deriveFrozen(true);
                currentNode.setParent(box);
                if (previous == null) {
                    if (RenderBox.isParanoidModelChecks() && currentNode.getPrev() != null) {
                        throw new IllegalStateException();
                    }
                    box.setFirstChild(currentNode);
                    continue;
                }
                previous.setNext(currentNode);
                currentNode.setPrev(previous);
            }
            box.setLastChild(currentNode);
            this.validateDescendantCounter();
            if (RenderBox.isParanoidModelChecks() && currentNode != null && currentNode.getNext() != null) {
                throw new IllegalStateException();
            }
        } else {
            box.setLastChild(null);
            box.setFirstChild(null);
            box.descendantCount = 1;
            box.contentRefCount = 0;
            box.tableRefCount = 0;
        }
        return box;
    }

    public void addChilds(RenderNode[] nodes) {
        int length = nodes.length;
        for (int i = 0; i < length; ++i) {
            this.addChild(nodes[i]);
        }
    }

    public void addGeneratedChilds(RenderNode[] nodes) {
        int nodeLength = nodes.length;
        for (int i = 0; i < nodeLength; ++i) {
            this.addGeneratedChild(nodes[i]);
        }
    }

    @Override
    public RenderNode findNodeById(InstanceID instanceId) {
        if (instanceId == this.getInstanceId()) {
            return this;
        }
        for (RenderNode child = this.getLastChild(); child != null; child = child.getPrev()) {
            RenderNode nodeById = child.findNodeById(instanceId);
            if (nodeById == null) continue;
            return nodeById;
        }
        return null;
    }

    public boolean isAppendable() {
        return this.isOpen();
    }

    public void clear() {
        RenderNode child = this.getFirstChild();
        while (child != null) {
            RenderNode nextChild = child.getNext();
            child.setPrev(null);
            child.setNext(null);
            child.setParent(null);
            this.onChildRemoved(child);
            child = nextChild;
        }
        this.setFirstChild(null);
        this.setLastChild(null);
        this.updateChangeTracker();
        this.validateDescendantCounter();
    }

    @Override
    protected void updateChangeTracker() {
        this.tableExportState = null;
        super.updateChangeTracker();
    }

    private RenderNode getFirstNonEmpty() {
        for (RenderNode firstChild = this.getFirstChild(); firstChild != null; firstChild = firstChild.getNext()) {
            if (firstChild.isEmpty()) continue;
            return firstChild;
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        if (!this.getBoxDefinition().isEmpty()) {
            return false;
        }
        RenderNode node = this.getFirstNonEmpty();
        return node == null;
    }

    @Override
    public boolean isDiscardable() {
        if (!this.getBoxDefinition().isEmpty()) {
            return false;
        }
        if (this.getStyleSheet().getStyleProperty(ElementStyleKeys.BACKGROUND_COLOR) != null) {
            return false;
        }
        for (RenderNode node = this.getFirstChild(); node != null; node = node.getNext()) {
            if (node.isDiscardable()) continue;
            return false;
        }
        return true;
    }

    public void close() {
        if (!this.isOpen()) {
            throw new IllegalStateException("Double close..");
        }
        this.setOpen(false);
        if (this.isContentRefHolder()) {
            this.decreaseContentReferenceCount(1, this);
        }
    }

    public void remove(RenderNode child) {
        RenderBox parent = child.getParent();
        if (parent != this) {
            throw new IllegalArgumentException("None of my childs");
        }
        RenderNode prev = child.getPrev();
        RenderNode next = child.getNext();
        if (prev != null) {
            prev.setNext(next);
        }
        if (next != null) {
            next.setPrev(prev);
        }
        child.setNext(null);
        child.setPrev(null);
        child.setParent(null);
        this.onChildRemoved(child);
        if (this.getFirstChild() == child) {
            this.setFirstChild(next);
        }
        if (this.getLastChild() == child) {
            this.setLastChild(prev);
        }
        child.updateChangeTracker();
        this.updateChangeTracker();
        this.validateDescendantCounter();
    }

    @Override
    public boolean isOpen() {
        return this.isFlag(65536) || this.contentRefCount > 0;
    }

    protected void setOpen(boolean open) {
        if (this.isOpen() == open) {
            return;
        }
        this.updateChangeTracker();
        this.setFlag(65536, open);
    }

    @Override
    public void freeze() {
        if (this.isFrozen()) {
            return;
        }
        super.freeze();
        for (RenderNode node = this.getFirstChild(); node != null; node = node.getNext()) {
            node.freeze();
        }
    }

    public RenderBox split(int axis) {
        RenderBox otherBox = (RenderBox)this.derive(false);
        if (!this.boxDefinition.isEmpty()) {
            BoxDefinition[] boxDefinitions = this.boxDefinition.split(axis);
            this.boxDefinition = boxDefinitions[0];
            otherBox.boxDefinition = boxDefinitions[1];
        }
        return otherBox;
    }

    public long getContentAreaX1() {
        return this.contentAreaX1;
    }

    public void setContentAreaX1(long contentAreaX1) {
        this.contentAreaX1 = contentAreaX1;
    }

    public long getContentAreaX2() {
        return this.contentAreaX2;
    }

    public void setContentAreaX2(long contentAreaX2) {
        this.contentAreaX2 = contentAreaX2;
    }

    public StaticBoxLayoutProperties getStaticBoxLayoutProperties() {
        return this.staticBoxLayoutProperties;
    }

    public ExtendedBaselineInfo getBaselineInfo() {
        return this.baselineInfo;
    }

    public void setBaselineInfo(ExtendedBaselineInfo baselineInfo) {
        this.baselineInfo = baselineInfo;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public boolean isBreakAfter() {
        return this.staticBoxLayoutProperties.isBreakAfter();
    }

    public long getStaticBoxPropertiesAge() {
        return this.staticBoxPropertiesAge;
    }

    public void setStaticBoxPropertiesAge(long staticBoxPropertiesAge) {
        if (this.staticBoxLayoutProperties.getNominalBaselineInfo() == null) {
            throw new IllegalStateException("Assertation: Cannot declare static-properties finished without a nominal baseline info");
        }
        this.staticBoxPropertiesAge = staticBoxPropertiesAge;
    }

    public String toString() {
        return this.getClass().getName() + '{' + "name='" + this.name + '\'' + ", x='" + this.getX() + '\'' + ", y='" + this.getY() + '\'' + ", width='" + this.getWidth() + '\'' + ", height='" + this.getHeight() + '\'' + ", elementType='" + this.getElementType() + '\'' + ", finishedPaginate='" + this.isFinishedPaginate() + '\'' + ", finishedTable='" + this.isFinishedTable() + '\'' + ", committed='" + this.isCommited() + '\'' + '}';
    }

    public void commit() {
        this.appliedPinPosition = this.markedPinPosition;
        this.appliedContentRefCount = this.markedContentRefCount;
        this.setAppliedOpen(this.isMarkedOpen());
        this.setAppliedSeen(this.isMarkedSeen());
        this.validateDescendantCounter();
    }

    public int getAppliedContentRefCount() {
        return this.appliedContentRefCount;
    }

    public boolean isAppliedOpen() {
        return this.isFlag(262144);
    }

    private void setAppliedOpen(boolean flag) {
        this.setFlag(262144, flag);
    }

    public boolean isAppliedSeen() {
        return this.isFlag(0x200000);
    }

    private void setAppliedSeen(boolean flag) {
        this.setFlag(0x200000, flag);
    }

    public boolean isMarkedOpen() {
        return this.isFlag(131072);
    }

    private void setMarkedOpen(boolean flag) {
        this.setFlag(131072, flag);
    }

    public boolean isMarkedSeen() {
        return this.isFlag(0x100000);
    }

    private void setMarkedSeen(boolean flag) {
        this.setFlag(0x100000, flag);
    }

    public void markBoxSeen() {
        this.setMarkedOpen(this.isOpen());
        this.markedContentRefCount = this.contentRefCount;
        this.setMarkedSeen(true);
        this.markedPinPosition = this.pinned;
        this.validateDescendantCounter();
    }

    public boolean isCommited() {
        return !this.isAppliedOpen() && this.isAppliedSeen() && this.appliedContentRefCount == 0;
    }

    public void rollback(boolean deepDirty) {
        this.setOpen(this.isAppliedOpen());
        this.contentRefCount = this.appliedContentRefCount;
        this.setMarkedOpen(this.isAppliedOpen());
        this.markedContentRefCount = this.appliedContentRefCount;
        this.markedPinPosition = this.appliedPinPosition;
        this.resetCacheState(deepDirty);
        this.validateDescendantCounter();
    }

    public void resetCacheState(boolean deepDirty) {
        this.resetValidateModelResult();
        this.setLinebreakAge(-1L);
        this.setCachedAge(-1L);
        if (deepDirty) {
            this.updateCacheState(CACHE_DEEP_DIRTY);
        } else {
            this.updateCacheState(CACHE_DIRTY);
        }
        this.updateChangeTracker();
    }

    @Override
    public boolean isDeepFinishedTable() {
        return this.isFlag(0x400000);
    }

    public void setDeepFinished(boolean deepFinished) {
        this.setFlag(0x400000, deepFinished);
    }

    public long getContentAge() {
        return this.contentAge;
    }

    public void setContentAge(long contentAge) {
        this.contentAge = contentAge;
    }

    public Boolean getContentBox() {
        return this.contentBox;
    }

    public void setContentBox(Boolean contentBox) {
        this.contentBox = contentBox;
    }

    public Object getTableExportState() {
        return this.tableExportState;
    }

    public void setTableExportState(Object tableExportState) {
        this.tableExportState = tableExportState;
    }

    public void markPinned(long pinPosition) {
        if (this.isPinned()) {
            return;
        }
        this.pinned = pinPosition;
        RenderBox renderBox = this.getParent();
        if (renderBox != null) {
            renderBox.markPinned(renderBox.getY());
        }
    }

    public boolean isPinned() {
        return this.pinned != -1L;
    }

    public long getPinned() {
        return this.pinned;
    }

    @Override
    public void setMinimumChunkWidth(long minimumChunkWidth) {
        super.setMinimumChunkWidth(minimumChunkWidth);
    }

    @Override
    public boolean isBoxOverflowX() {
        return this.staticBoxLayoutProperties.isOverflowX();
    }

    @Override
    public boolean isBoxOverflowY() {
        return this.staticBoxLayoutProperties.isOverflowY();
    }

    public boolean isEmptyNodesHaveSignificance() {
        return this.getNodeLayoutProperties().getStyleSheet().getBooleanStyleProperty(ElementStyleKeys.INVISIBLE_CONSUMES_SPACE);
    }

    public boolean isAcceptInlineBoxes() {
        return false;
    }

    public long getTableValidationAge() {
        return this.tableValidationAge;
    }

    public void setTableValidationAge(long tableValidationAge) {
        this.tableValidationAge = tableValidationAge;
    }

    public boolean useMinimumChunkWidth() {
        return this.getStyleSheet().getBooleanStyleProperty(ElementStyleKeys.USE_MIN_CHUNKWIDTH);
    }

    @Override
    public long getOverflowAreaHeight() {
        return this.overflowAreaHeight;
    }

    public void setOverflowAreaHeight(long overflowAreaHeight) {
        this.overflowAreaHeight = overflowAreaHeight;
    }

    @Override
    public long getOverflowAreaWidth() {
        return this.overflowAreaWidth;
    }

    public void setOverflowAreaWidth(long overflowAreaWidth) {
        this.overflowAreaWidth = overflowAreaWidth;
    }

    public void addOverflowArea(long width, long height) {
        if (width > this.overflowAreaWidth) {
            this.overflowAreaWidth = width;
        }
        if (height > this.overflowAreaHeight) {
            this.overflowAreaHeight = height;
        }
    }

    @Override
    public void apply() {
        super.apply();
        this.staticBoxPropertiesAge = this.getChangeTracker();
        this.tableValidationAge = this.getChangeTracker();
        this.overflowAreaWidth = this.getCachedWidth();
        this.overflowAreaHeight = this.getCachedHeight();
    }

    public void extendHeight(RenderNode child, long heightOffset) {
        this.extendHeightInBlockMode(child, heightOffset);
    }

    protected void extendHeightInBlockMode(RenderNode child, long heightOffset) {
        this.setHeight(this.getHeight() + heightOffset);
        this.setOverflowAreaHeight(this.getOverflowAreaHeight() + heightOffset);
        this.updateCacheState(CACHE_DEEP_DIRTY);
        RenderBox parent = this.getParent();
        if (parent != null) {
            parent.extendHeight(this, heightOffset);
        }
    }

    protected void extendHeightInRowMode(RenderNode child, long heightOffset) {
        long parentY2 = this.getY() + this.getHeight();
        long childY2 = child.getY() + child.getHeight();
        long deltaToBase = childY2 - parentY2;
        if (deltaToBase <= 0L) {
            return;
        }
        long delta = Math.min(deltaToBase, heightOffset);
        this.setHeight(this.getHeight() + delta);
        this.setOverflowAreaHeight(this.getOverflowAreaHeight() + delta);
        this.updateCacheState(CACHE_DEEP_DIRTY);
        RenderBox parent = this.getParent();
        if (parent != null) {
            parent.extendHeight(this, delta);
        }
    }

    @Override
    public int getChildCount() {
        int count = 0;
        for (RenderNode next = this.firstChildNode; next != null; next = next.getNext()) {
            ++count;
        }
        return count;
    }

    public long getOrphanConstraintSize() {
        return this.orphanConstraintSize;
    }

    public void setOrphanConstraintSize(long orphanConstraintSize) {
        this.orphanConstraintSize = orphanConstraintSize;
    }

    public long getWidowConstraintSize() {
        return this.widowConstraintSize;
    }

    public void setWidowConstraintSize(long widowConstraintSize) {
        this.widowConstraintSize = widowConstraintSize;
    }

    public long getWidowConstraintSizeWithKeepTogether() {
        return this.widowConstraintSizeWithKeepTogether;
    }

    public void setWidowConstraintSizeWithKeepTogether(long widowConstraintSizeWithKeepTogether) {
        this.widowConstraintSizeWithKeepTogether = widowConstraintSizeWithKeepTogether;
    }

    public boolean isInvalidWidowOrphanNode() {
        return this.isFlag(0x10000000);
    }

    public void setInvalidWidowOrphanNode(boolean invalidWidowOrphanNode) {
        this.setFlag(0x10000000, invalidWidowOrphanNode);
    }

    @Override
    public RestrictFinishClearOut getRestrictFinishedClearOut() {
        return this.restrictFinishClearOut;
    }

    public void setRestrictFinishedClearOut(RestrictFinishClearOut restrictFinishedClearOut) {
        if (this.restrictFinishClearOut == restrictFinishedClearOut) {
            return;
        }
        this.restrictFinishClearOut = restrictFinishedClearOut;
        RenderBox parent = this.getParent();
        if (parent != null && parent.isBlockForPagebreakPurpose() && restrictFinishedClearOut != RestrictFinishClearOut.UNRESTRICTED) {
            parent.setRestrictFinishedClearOut(RestrictFinishClearOut.RESTRICTED);
        }
    }

    protected boolean isBlockForPagebreakPurpose() {
        return false;
    }

    @Override
    public boolean isOrphanLeaf() {
        return this.restrictFinishClearOut == RestrictFinishClearOut.LEAF;
    }

    public long getVerticalInsets() {
        long insetBottom = this.staticBoxLayoutProperties.getBorderBottom() + this.boxDefinition.getPaddingBottom();
        long insetTop = this.staticBoxLayoutProperties.getBorderTop() + this.boxDefinition.getPaddingTop();
        return insetBottom + insetTop;
    }

    public static enum RestrictFinishClearOut {
        UNRESTRICTED,
        RESTRICTED,
        LEAF;

    }

    public static enum BreakIndicator {
        NO_MANUAL_BREAK,
        DIRECT_MANUAL_BREAK,
        INDIRECT_MANUAL_BREAK;

    }
}

