/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.model.context;

import java.io.Serializable;
import org.pentaho.reporting.engine.classic.core.ElementAlignment;
import org.pentaho.reporting.engine.classic.core.InvalidReportStateException;
import org.pentaho.reporting.engine.classic.core.ReportAttributeMap;
import org.pentaho.reporting.engine.classic.core.filter.types.AutoLayoutBoxType;
import org.pentaho.reporting.engine.classic.core.layout.style.SimpleStyleSheet;
import org.pentaho.reporting.engine.classic.core.metadata.ElementType;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleSheet;
import org.pentaho.reporting.engine.classic.core.style.ResolverStyleSheet;
import org.pentaho.reporting.engine.classic.core.style.StyleSheet;
import org.pentaho.reporting.engine.classic.core.style.TextStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.VerticalTextAlign;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;

public final class NodeLayoutProperties
implements Serializable,
Cloneable {
    private static final Float ZERO = new Float(0.0f);
    public static final InstanceID SIMPLE_NODE_ID = new InstanceID();
    public static final NodeLayoutProperties GENERIC_PROPERTIES = new NodeLayoutProperties();
    private VerticalTextAlign verticalTextAlign;
    private ElementAlignment verticalAlignment;
    private int majorAxis;
    private int minorAxis;
    private StyleSheet styleSheet;
    private InstanceID instanceId;
    private Float posY;
    private Float posX;
    private ReportAttributeMap attributes;
    private ElementType elementType;

    private NodeLayoutProperties() {
        this(SimpleStyleSheet.EMPTY_STYLE, ReportAttributeMap.emptyMap(), SIMPLE_NODE_ID, AutoLayoutBoxType.INSTANCE);
    }

    public NodeLayoutProperties(StyleSheet styleSheet, ReportAttributeMap attributes, InstanceID instanceID, ElementType elementType) {
        this(1, 0, styleSheet, attributes, instanceID, elementType);
    }

    public NodeLayoutProperties(int majorAxis, int minorAxis, StyleSheet styleSheet, ReportAttributeMap attributes, InstanceID instanceID, ElementType elementType) {
        if (instanceID == null) {
            throw new NullPointerException();
        }
        if (styleSheet == null) {
            throw new NullPointerException();
        }
        if (attributes == null) {
            throw new NullPointerException();
        }
        if (styleSheet instanceof ResolverStyleSheet) {
            throw new IllegalStateException();
        }
        if (styleSheet instanceof ElementStyleSheet) {
            throw new InvalidReportStateException("Cannot have render-nodes with mutable style");
        }
        if (styleSheet.getStyleProperty(TextStyleKeys.FONTSIZE) == null) {
            throw new InvalidReportStateException("Every resolved style must have a non-null font-size");
        }
        if (styleSheet.getStyleProperty(ElementStyleKeys.STROKE) == null) {
            throw new InvalidReportStateException("Every resolved style must have a non-null stroke");
        }
        this.majorAxis = majorAxis;
        this.minorAxis = minorAxis;
        this.instanceId = instanceID;
        this.styleSheet = styleSheet;
        this.attributes = attributes;
        this.elementType = elementType;
        Object vTextAlign = styleSheet.getStyleProperty(TextStyleKeys.VERTICAL_TEXT_ALIGNMENT);
        this.verticalTextAlign = vTextAlign != null ? (VerticalTextAlign)vTextAlign : VerticalTextAlign.BASELINE;
    }

    public VerticalTextAlign getVerticalTextAlign() {
        return this.verticalTextAlign;
    }

    public StyleSheet getStyleSheet() {
        return this.styleSheet;
    }

    public InstanceID getInstanceId() {
        return this.instanceId;
    }

    public int getMajorAxis() {
        return this.majorAxis;
    }

    public int getMinorAxis() {
        return this.minorAxis;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public ElementAlignment getVerticalAlignment() {
        if (this.verticalAlignment == null) {
            this.verticalAlignment = (ElementAlignment)this.styleSheet.getStyleProperty(ElementStyleKeys.VALIGNMENT);
        }
        return this.verticalAlignment;
    }

    public double getPosY() {
        if (this.posY == null) {
            Object o = this.styleSheet.getStyleProperty(ElementStyleKeys.POS_Y);
            this.posY = o == null ? ZERO : (Float)o;
        }
        return this.posY.doubleValue();
    }

    public double getPosX() {
        if (this.posX == null) {
            Object o = this.styleSheet.getStyleProperty(ElementStyleKeys.POS_X);
            this.posX = o == null ? ZERO : (Float)o;
        }
        return this.posX.doubleValue();
    }

    public ReportAttributeMap getAttributes() {
        return this.attributes;
    }

    public ElementType getElementType() {
        return this.elementType;
    }

    public String toString() {
        return "NodeLayoutProperties{verticalAlignment=" + this.getVerticalAlignment() + ", majorAxis=" + this.majorAxis + ", minorAxis=" + this.minorAxis + '}';
    }
}

